package ibase.dashboard.scm.servlet;
import ibase.dashboard.scm.ejb.SalesPerformanceRemote;
import ibase.system.config.AppConnectParm;
import ibase.webitm.utility.ITMException;
import java.io.IOException;
import java.io.OutputStream;
import javax.naming.InitialContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.json.simple.JSONObject;

public class BrandZoneWiseMetroServlet extends HttpServlet
{
	private static final long serialVersionUID = 1L;

	public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException
	{
		doPost(request, response);
	}
	@SuppressWarnings("unchecked")
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException
	{
		SalesPerformanceRemote salesPerformance = null;
		InitialContext context                  = null;
		AppConnectParm appConnectParm           = new AppConnectParm();
		String dataSourceName = "";
		String month = "",brandName="",zonedescr="",divDescr="";
		try
		{
			response.setContentType("application/xml");
			HttpSession session = request.getSession(true);
			ibase.utility.UserInfoBean userInfo = (ibase.utility.UserInfoBean) session.getAttribute("USER_INFO");
			dataSourceName      = request.getParameter("dataSourceName"); 
			month = (request.getParameter("month"));
			brandName = (request.getParameter("brandname"));
			zonedescr = (request.getParameter("zonedescr"));
			divDescr  = (request.getParameter("divdescr"));			
			context   = new InitialContext(appConnectParm.getProperty());
			salesPerformance = (SalesPerformanceRemote) context.lookup("ibase/SalesPerformance/remote");
			/*setUserInfo(userInfo) for DB connection on dated:14062016*/
			salesPerformance.setUserInfo(userInfo);
			JSONObject jsonObjData      = (JSONObject)salesPerformance.getBrandZoneWiseMetroDetail(dataSourceName,month,brandName,zonedescr,divDescr);
			OutputStream outputStream   = response.getOutputStream();			
		    outputStream.write(jsonObjData.toString().getBytes());
			outputStream.flush();
			outputStream.close();
			System.out.println(" Final data set for BrandZoneWiseMetroServlet build the Graph is===" + jsonObjData);	
			
		} catch (Exception e)
		{
			System.out.println("Exception : BrandZoneWiseMetroServlet :doPost(HttpServletRequest request, HttpServletResponse response) :" + e.getMessage());
			try
			{
			  throw new ITMException(e);
			} catch (ITMException e1)
			{
				e1.printStackTrace();
			}
		}
	}

}