import { BaseBlockComponent } from '../base-block.component';
import { Component, Input, ViewChild, forwardRef, Attribute } from '@angular/core';
import { NG_VALUE_ACCESSOR, NG_VALIDATORS, NgModel } from '@angular/forms';
export class BBTextboxComponent extends BaseBlockComponent {
    constructor(validator) {
        super();
        this.validator = validator;
        this.align = "right";
        this.requiredMessage = 'This field is required';
        this.invalidMessage = 'Please enter a valid input';
        this.bbExpression = /^/;
        this.customErrorMessages = {
            'required': () => this.requiredMessage,
            'minlength': (params) => 'The min number of characters is ' + params.requiredLength,
            'maxlength': (params) => 'The max allowed number of characters is ' + params.requiredLength,
            'email': (params) => params.message,
            'password': (params) => params.message,
            'phone': (params) => params.message
        };
        this.bbType = 'text';
    }
    validate(c) {
        if (!this.validator) {
            return;
        }
        if (!c.value) {
            this.errors = null;
            return;
        }
        const isValidText = this.bbExpression.test(c.value);
        const message = {
            'textbox': {
                'message': this.invalidMessage
            }
        };
        if (!isValidText) {
            this.errors = message;
        }
        else {
            this.errors = null;
        }
        return isValidText ? null : message;
    }
}
BBTextboxComponent.decorators = [
    { type: Component, args: [{
                selector: 'bb-textbox',
                template: `

      <span [ngSwitch]="uxDesign">
      	<span *ngSwitchCase="'UX3'"> 
      		<md-form-field>
      			<input mdInput #textbox="ngModel" [(ngModel)]="value" [type]="bbType" [placeholder]="bbPlaceholder" [required]="bbRequired" [disabled]="bbDisabled" [value]="bbValue" [maxlength]="bbMaxlength" [minlength]="bbMinlength" [readOnly]="bbReadOnly" [autofocus]="bbAutofocus"/>
      			 <md-hint> 
       				<validation [control]="model" [errors]="errors" [errorMessages]="customErrorMessages"></validation>
       			 </md-hint> 
      		</md-form-field>	
      	</span>
	
      	<span *ngSwitchCase="'UX2'">
      		<span  [ngClass]="{'labelPostion':bbLabelPostion === 'top'}">{{bbLabel}}</span>
      		<input  #textbox="ngModel" [(ngModel)]="value" [type]="bbType" [required]="bbRequired" [disabled]="bbDisabled" [value]="bbValue" [maxlength]="bbMaxlength" [minlength]="bbMinlength" [readOnly]="bbReadOnly" [autofocus]="bbAutofocus"/>
      		<validation [control]="model" [errors]="errors" [errorMessages]="customErrorMessages"></validation>
      	</span>
	
      	<span *ngSwitchCase="'UX1'">
      		<input  #textbox="ngModel" [(ngModel)]="value" [type]="bbType" [placeholder]="bbPlaceholder" [required]="bbRequired" [disabled]="bbDisabled" [value]="bbValue" [maxlength]="bbMaxlength" [minlength]="bbMinlength" [readOnly]="bbReadOnly" [autofocus]="bbAutofocus"/>
      		<validation [control]="model" [errors]="errors" [errorMessages]="customErrorMessages"></validation>
      	</span>
      </span>	
    `,
                styles: [`
      .labelPostion{
      display: table;
      }
    `],
                providers: [
                    {
                        provide: NG_VALUE_ACCESSOR,
                        useExisting: forwardRef(() => BBTextboxComponent),
                        multi: true
                    },
                    {
                        provide: NG_VALIDATORS,
                        useExisting: BBTextboxComponent,
                        multi: true
                    }
                ]
            },] },
];
/** @nocollapse */
BBTextboxComponent.ctorParameters = () => [
    { type: undefined, decorators: [{ type: Attribute, args: ["validator",] },] },
];
BBTextboxComponent.propDecorators = {
    'align': [{ type: Input, args: ['align',] },],
    'requiredMessage': [{ type: Input, args: ['requiredMessage',] },],
    'invalidMessage': [{ type: Input, args: ['invalidMessage',] },],
    'bbExpression': [{ type: Input, args: ['expression',] },],
    'model': [{ type: ViewChild, args: [NgModel,] },],
};
//# sourceMappingURL=bb-textbox.component.js.map