package ibase.dashboard.sfa.ejb;

import ibase.system.config.ConnDriver;
import ibase.utility.CommonConstants;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;

import java.io.File;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;


import javax.ejb.Stateless;
import org.json.simple.JSONObject;

@Stateless
public class AttendanceCompliance extends ValidatorEJB implements AttendanceComplianceLocal,
		AttendanceComplianceRemote
{
	public AttendanceCompliance()
	{
	}

	@SuppressWarnings("unchecked")
	public JSONObject getAttendance(String dataSourceName, String empCode, String viewOptionSelectd)
			throws RemoteException, ITMException
	{
		JSONObject rowDataPendingTaskJson = new JSONObject();
		JSONObject rowData = null;
		String sql = "";
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		int count = 0, rowCount = 0;
		StringBuffer rowBuffer = null;
		Map<String, ArrayList<String>> regionWiseAttendanceMap = null;
		ArrayList<String> complianceReport = null;
		String salesPersCode = "", salesPersName = "", userImagePath = "", tran_image = "";
		String state = "", reportHead = "", notReportingDays = "", mobileNo = "";
		try
		{
			SimpleDateFormat convertToDbDate =new SimpleDateFormat(new GenericUtility().getDBDateFormat());
			SimpleDateFormat simpleDateFormat =new SimpleDateFormat(new GenericUtility().getApplDateFormat());
			conn = connDriver.getConnectDB(dataSourceName);
			connDriver = null;
	
			/*sql =   " SELECT A.SALES_PERS, SP.SP_NAME, A.LAST_REPORT, ROUND(TRUNC(sysdate)-TRUNC(A.LAST_REPORT)) NOT_REPORTED_DAYS," +
			" I.DESCR DIVISION , E.HOBBY1 REGION, S.DESCR STATE, (NVL(TRIM(E1.EMP_FNAME),'') ||NVL(TRIM(E1.EMP_MNAME),' ') ||NVL(TRIM(E1.EMP_LNAME),'')) EMP_NAME, " +
			" E.MOBILE_NO FROM (SELECT t.SALES_PERS, MAX(T.EVENT_DATE) LAST_REPORT " +
			" FROM SPRS_ACT_TRAN T " +
			" WHERE T.SALEs_PERS IN (SELECT S.SALES_pERS FROM SALES_PErS S " +
			" INNER JOIN EMPLOYEE E ON S.SALES_PERS = E.EMP_CODE " +
			" WHERE E.STATUS ='Y' " +
			" START WITH e.emp_code = '" + empCode + "' " +
			" CONNECT BY prior E.EMP_CODE = E.REPORT_TO " +
			" ) AND T.CONFIRMED='Y' " +
			" GROUP BY t.SALES_PERS )A INNER JOIN SALES_PERS SP ON A.SALES_PERS = SP.SALES_PERS " +
			" INNER JOIN EMPLOYEE E ON SP.SALES_PERS = E.EMP_CODE " +
			" INNER JOIN ITEMSER I ON I.ITEM_SER=SP.ITEM_SER LEFT " +
			" OUTER JOIN EMPLOYEE E1 ON E1.EMP_CODE = E.REPORT_TO " +
			" LEFT OUTER JOIN STATE S ON S.STATE_CODE = E.CUR_STATE ";*/
			
			sql = "SELECT A.SALES_PERS,  SP.SP_NAME,  A.LAST_REPORT,  " +
				"ROUND(TRUNC(sysdate)-TRUNC(A.LAST_REPORT)) NOT_REPORTED_DAYS,  I.DESCR DIVISION ,  " +
				"E.HOBBY1 REGION,  S.DESCR STATE,  (NVL(TRIM(E1.EMP_FNAME),'')  ||NVL(TRIM(E1.EMP_MNAME),' ')" +
				"  ||NVL(TRIM(E1.EMP_LNAME),'')) EMP_NAME,  E.MOBILE_NO FROM  (SELECT t.SALES_PERS,   " +
				" MAX(T.EVENT_DATE) LAST_REPORT  FROM SPRS_ACT_TRAN T  WHERE T.SALEs_PERS IN " +
				"(SELECT S.SALES_pERS  FROM SALES_PErS S  INNER JOIN EMPLOYEE E  ON " +
				"S.SALES_PERS = E.EMP_CODE WHERE E.STATUS ='Y' START WITH e.emp_code = '" + empCode + "' " +
				"CONNECT BY prior E.EMP_CODE = E.REPORT_TO    )  AND T.CONFIRMED='Y'  " +
				"GROUP BY t.SALES_PERS  )A INNER JOIN SALES_PERS SP ON A.SALES_PERS = SP.SALES_PERS " +
				"INNER JOIN EMPLOYEE E ON SP.SALES_PERS = E.EMP_CODE INNER JOIN ITEMSER I " +
				"ON I.ITEM_SER=SP.ITEM_SER LEFT OUTER JOIN EMPLOYEE E1 ON E1.EMP_CODE = E.REPORT_TO " +
				"LEFT OUTER JOIN STATE S ON S.STATE_CODE = E.CUR_STATE";

			System.out.println("sql is =" + sql);
			pstmt = conn.prepareStatement(sql,ResultSet.TYPE_SCROLL_SENSITIVE,ResultSet.CONCUR_READ_ONLY);
   			rs    = pstmt.executeQuery();
   			rowCount = 0;
   			rs.last();
			rowCount = rs.getRow();
			rs.beforeFirst();
			rowBuffer = new StringBuffer();
			if(rowCount == 0)
			{
				rowBuffer = new StringBuffer("<table  id='htmlTable' cellpadding='2' align='center'><tr><td align = 'center' class='gwt-ScrollTable'>No Data to Display</td></tr>");
			}
			if(viewOptionSelectd != null && viewOptionSelectd.equalsIgnoreCase("JNJ"))
			{
				rowData = new JSONObject();
				regionWiseAttendanceMap = new LinkedHashMap<String, ArrayList<String>>();
				complianceReport = new ArrayList<String>();
				while (rs.next())
				{
					salesPersCode = checkNull(rs.getString("SALES_PERS"));
					salesPersName = checkNull(rs.getString("SP_NAME"));
					String object = "images"+ File.separator + "users";
					state         = checkNull(rs.getString("STATE")); 
					reportHead    = checkNull(rs.getString("EMP_NAME"));
					notReportingDays = checkNull(rs.getString("NOT_REPORTED_DAYS"));
					mobileNo      = checkNull(rs.getString("MOBILE_NO"));
			     	userImagePath = "/ibase/CustomMenuImageServlet?fldValue="+salesPersCode+"&object="+object+"&objName="+object+"&ALT_FLD_VALUE="+salesPersName;
			     	tran_image = "<img class='cardProdImg2' src='"+userImagePath+"' style='margin-top:-15px;'/>";
			     	String devisonWiseRegion = checkNull(rs.getString("DIVISION"))+" "+checkNull(rs.getString("REGION"));
					
			     	if(regionWiseAttendanceMap.containsKey(devisonWiseRegion))
					{
			     		complianceReport.add("<div class='tdMousehover'>" +
								"<table border='0' cellpadding='0' cellspacing='1' width='100%' style= 'padding: 2px;margin:auto;'>" +
								"<tr class = 'row' id='"+salesPersCode+"' onclick='getRowWisePkValue(this.id)'>" +
								"<td width='2%'>"+tran_image+"</td>" +
								"<td><table cellpadding='0' cellspacing='0' width='70%' style='padding-left:5px;'>" +
									"<tr><td><table cellpadding='0' cellspacing='1'>" +
											"<tr><td><font style='font-size:14px;'>"+salesPersName+" ("+salesPersCode+") "+"</font></td></tr>" +
											"</table></td></tr>" +
									"<tr><td><table cellpadding='0' cellspacing='1'>" +
											"<tr><td><font style='font-size:13px;'> "+state+", "+mobileNo+" </font></td>" +
											//"<td style='padding-left:20px;'><font style='font-size:13px;'> near by "+availQtyForNearBy+"pc </font></td>" +
											"</tr>" +
											"</table></td></tr>" +
									"<tr><td ><table cellpadding='0' cellspacing='1'>" +
											"<tr><td class='defaultIconSubTitle'><font style='font-size:11px;'>Reporting Head: ("+reportHead+") </font></td>" +
											//"<td class='defaultIconSubTitle' style='padding-left:20px;'><font style='font-size:11px;'> "+pendingValue+"INR </font></td>" +
											"</tr>" +
											"</table></td></tr>" +
									"</table></td>" +
								"<td align='right' style='padding-right:10px;'><div style='margin-top:-15px;'> "+notReportingDays+" days </div></td></tr></table></div>");
					}
					else
					{
						complianceReport = new ArrayList<String>();
						complianceReport.add("<div class='tdMousehover'>" +
								"<table border='0' cellpadding='0' cellspacing='1' width='100%' style= 'padding: 2px;margin:auto;'>" +
								"<tr class = 'row' id='"+salesPersCode+"' onclick='getRowWisePkValue(this.id)'>" +
								"<td width='2%'>"+tran_image+"</td>" +
								"<td><table cellpadding='0' cellspacing='0' width='70%' style='padding-left:5px;'>" +
									"<tr><td><table cellpadding='0' cellspacing='1'>" +
											"<tr><td><font style='font-size:14px;'> "+salesPersName+" ("+salesPersCode+") "+"</font></td></tr>" +
											"</table></td></tr>" +
									"<tr><td><table cellpadding='0' cellspacing='1'>" +
											"<tr><td><font style='font-size:13px;'> "+state+", </font></td>" +
											"<td style='padding-left:20px;'><font style='font-size:13px;'> "+mobileNo+" </font></td>" +
											//"<td style='padding-left:20px;'><font style='font-size:13px;'> near by "+availQtyForNearBy+"pc </font></td>" +
											"</tr>" +
											"</table></td></tr>" +
									"<tr><td ><table cellpadding='0' cellspacing='1'>" +
											"<tr><td class='defaultIconSubTitle'><font style='font-size:11px;'>Reporting Head: ("+reportHead+") </font></td>" +
											//"<td class='defaultIconSubTitle' style='padding-left:20px;'><font style='font-size:11px;'> "+pendingValue+"INR </font></td>" +
											"</tr>" +
											"</table></td></tr>" +
									"</table></td>" +
								"<td align='right' style='padding-right:10px;'><div style='margin-top:-15px;'> "+notReportingDays+" days </div></td></tr></table></div>");
					
					}
			     	regionWiseAttendanceMap.put(devisonWiseRegion, complianceReport);
				}
				for (Map.Entry<String, ArrayList<String>> entry : regionWiseAttendanceMap.entrySet())
	            {
	                System.out.print(entry.getKey() + ": "+entry.getValue());
	                rowBuffer.append("<div class='defaultTitle'>"+entry.getKey()+"</div>");
	                ArrayList<String> mapValue = entry.getValue();
	                for(int i = 0; i < mapValue.size(); i++)
	                {
	                	rowBuffer.append(mapValue.get(i));
	                }
	                
	            }
				rowData.put("complianceReportTable", rowBuffer.toString());
				rowData.put("exportToExcel", "<td><img src='"+CommonConstants.TOMCAT_HOME+"/ibase/E12BROWSER/FusionChart/images/excel.png' width='20px' height='20px' alt='Export to Excel' id='excel' name='excel' onclick='exportExcel(this.parentNode.id)' align='right' style='padding : 16px;'></td>");
				rowDataPendingTaskJson.put(count, rowData);
				count++;
			}
			else
			{
				while (rs.next())
				{
					rowData = new JSONObject();
					rowData.put("salespersn",   checkNull(rs.getString("SALES_PERS")));
					rowData.put("spname",       checkNull(rs.getString("SP_NAME")));
					String dueDate             =checkNull(rs.getString("LAST_REPORT"));
					if(dueDate.trim().length()>0)
			        {
			            rowData.put("lastreport", simpleDateFormat.format(convertToDbDate.parse(dueDate)));
			        }
			        else
			        {
			            rowData.put("lastreport",checkNull (rs.getString("LAST_REPORT")));
			        }
					
					rowData.put("notreporteddays",  checkNull(rs.getString("NOT_REPORTED_DAYS")));
					rowData.put("division",         checkNull(rs.getString("DIVISION")));
					rowData.put("region",           checkNull(rs.getString("REGION")));
					rowData.put("state",            checkNull(rs.getString("STATE")));
					rowData.put("empname",          checkNull(rs.getString("EMP_NAME")));
					rowData.put("mobileno",         checkNull(rs.getString("MOBILE_NO")));
					rowDataPendingTaskJson.put(Integer.valueOf(count), rowData);
					count++;
				}
			}
			rs.close();
			rs=null;
			pstmt.close();
			pstmt=null;
			System.out.println(" rowDataPendingTaskJson is =" + rowDataPendingTaskJson);

		}
		catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
						rs.close();
					rs = null;
					if (pstmt != null)
						pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			}
			catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :getTask():" + d.getMessage());
				throw new ITMException(d);
			}
		}

		return rowDataPendingTaskJson;
	}

	
	@SuppressWarnings("unchecked")
	@Override
    public JSONObject getComplianceSummary(String dataSourceName, String loginId, String period) throws RemoteException, ITMException
    {
		JSONObject rawDataComplianceHirarchyDB2Json = new JSONObject();
		JSONObject rowData = null;
		String sql = "", code = "";
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		Map<String, Integer> complienceSummaryMap = new LinkedHashMap<String, Integer>();
		int reportedDays = 0, nonReportedDays = 0, total;
		double reportedDaysPerc = 0.0, nonReportedDaysPerc = 0.0;
		try
		{
			System.out.println("Inside AttendanceCompliance for getComplianceSummary Data Soruce Name=: "+dataSourceName+" loginId=:"+ loginId+"---- period=:"+ period);
			conn = connDriver.getConnectDB(dataSourceName);
			connDriver = null;	
			if(period != null && period.length()>0)
			{
				period = period;
			}
			else
			{
				sql   = "select code from period Where To_Date(Sysdate) Between Fr_Date and To_Date";
				pstmt = conn.prepareStatement(sql);
				rs = pstmt.executeQuery();
			    if (rs.next())
		        {
			    	period = checkNull(rs.getString("code")); 				  
				    System.out.println("period case of if block: "+period);
				}
			    rs.close();
			    rs = null;
			    pstmt.close();
			    pstmt = null;
			}
			sql =   "SELECT SUM(  CASE    WHEN REP_NONREP='R'    THEN 1    ELSE 0  END ) AS Reported ,  " +
					"SUM(  CASE    WHEN REP_NONREP='NR'    THEN 1    ELSE 0  END ) AS NonReported,  " +
					"SUM(  CASE    WHEN REP_NONREP='R'    THEN 1    ELSE 0  END +  CASE    " +
					"WHEN REP_NONREP='NR'    THEN 1    ELSE 0  END) AS TOTAL FROM  " +
					"(SELECT SALES_PERS_AV.AVAILABLE_DY ,    SPRS_ACT_TRAN.ACTIVITY_CODE ,    " +
					"(    CASE      WHEN ( ROW_NUMBER() OVER ( PARTITION BY SALES_PERS_AV.SALESPERS " +
					",AVAILABLE_DY ORDER BY SALES_PERS_AV.SALESPERS ,AVAILABLE_DY ) ) = 1 AND " +
					"SPRS_ACT_TRAN.SALES_PERS   IS NOT NULL      THEN 'R'      WHEN ( ROW_NUMBER() " +
					"OVER ( PARTITION BY SALES_PERS_AV.SALESPERS ,AVAILABLE_DY " +
					"ORDER BY SALES_PERS_AV.SALESPERS ,AVAILABLE_DY ) ) <> 1      " +
					"AND SPRS_ACT_TRAN.SALES_PERS  IS NOT NULL THEN '-' ELSE 'NR' END ) AS REP_NONREP , " +
					" NVL(STRG_CUSTOMER.FIRST_NAME, '')    || NVL(STRG_CUSTOMER.MIDDLE_NAME, '')    " +
					"|| NVL(STRG_CUSTOMER.LAST_NAME, '') AS CUSTOMER_NAME  FROM    " +
					"(SELECT users.CODE   AS SALESPERS ,  AV_DATES.available_dy AS AVAILABLE_DY FROM  " +
					"( SELECT CODE ,'a' AS a FROM users ) users , (SELECT dt AS available_dy , 'a' AS a " +
					"FROM sfa_time  WHERE DT BETWEEN TRUNC(TO_DATE(TO_CHAR(TO_DATE('01-'  || " +
					"SUBSTR('"+period+"', 5, 6)  || '-'  || SUBSTR('"+period+"', 1, 4), 'DD-MM-YYYY'), 'DD-MM-YYYY')," +
					" 'DD-MM-YYYY'), 'MM')  AND TRUNC(last_day(TO_DATE(TO_CHAR(TO_DATE('01-' || " +
					"SUBSTR('"+period+"', 5, 6) || '-'  || SUBSTR('"+period+"', 1, 4), 'DD-MM-YYYY'), 'DD-MM-YYYY')," +
					" 'DD-MM-YYYY')))  ) AV_DATES  WHERE users.a = AV_DATES.a    MINUS    " +
					"SELECT EMPLOYEE.EMP_CODE AS SALESPERS, holiday.hol_date  AS AVAILABLE_DY FROM holiday, " +
					" EMPLOYEE    WHERE holiday.hol_tblno = EMPLOYEE.hol_tblno    " +
					"AND holiday.hol_date BETWEEN TRUNC(TO_DATE(TO_CHAR(TO_DATE('01-'  || " +
					"SUBSTR('"+period+"', 5, 6) || '-'  || SUBSTR('"+period+"', 1, 4), 'DD-MM-YYYY'), 'DD-MM-YYYY')," +
					" 'DD-MM-YYYY'), 'MM')    AND TRUNC(last_day(TO_DATE(TO_CHAR(TO_DATE('01-' " +
					" || SUBSTR('"+period+"', 5, 6)  || '-'  || SUBSTR('"+period+"', 1, 4), 'DD-MM-YYYY')," +
					" 'DD-MM-YYYY'), 'DD-MM-YYYY')))  AND NOT EXISTS  (SELECT *  FROM sprs_act_tran s " +
					"  WHERE s.sales_pers = employee.emp_code  AND s.event_date  = holiday.hol_date ) ) " +
					"SALES_PERS_AV  LEFT OUTER JOIN (SELECT S.* FROM SPRS_ACT_TRAN S  " +
					"WHERE S.ACTIVITY_CODE <> 'PR'  AND S.CONFIRMED  = 'Y' ) SPRS_ACT_TRAN  " +
					"ON SPRS_ACT_TRAN.SALES_PERS  = SALES_PERS_AV.SALESPERS  " +
					"AND SPRS_ACT_TRAN.EVENT_DATE = SALES_PERS_AV.AVAILABLE_DY  LEFT OUTER JOIN   " +
					" ( SELECT S.* FROM STRG_MEET S WHERE S.EVENT_TYPE <> 'PR'    )" +
					" STRG_MEET  ON SPRS_ACT_TRAN.SALES_PERS  = STRG_MEET.SALES_PERS " +
					" AND SPRS_ACT_TRAN.EVENT_DATE = STRG_MEET.EVENT_DATE  AND " +
					"SPRS_ACT_TRAN.DCR_ID  = STRG_MEET.DCR_ID  LEFT OUTER JOIN STRG_CUSTOMER  " +
					"ON STRG_MEET.STRG_CODE   = STRG_CUSTOMER.SC_CODE  WHERE SALES_PERS_AV.SALESPERS " +
					"IN    (SELECT emp_code FROM employee START WITH emp_code = (SELECT emp_code " +
					"FROM users WHERE code = '"+loginId+"' AND STATUS='A'   )  " +
					"CONNECT BY prior emp_code = report_to    )  )A ";

			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			int count = 0;	
			while (rs.next())
			{
				reportedDays    = Integer.parseInt(checkNumber(rs.getString("Reported")));
				nonReportedDays = Integer.parseInt(checkNumber(rs.getString("NonReported")));
				total			= Integer.parseInt(checkNumber(rs.getString("TOTAL")));
				
				//reportedDaysPerc    = (reportedDays/total)*100;
				//nonReportedDaysPerc = (100 - reportedDaysPerc);
				
				System.out.println("reportedDays: "+reportedDays+" nonReportedDays: "+nonReportedDays+" total: "+total);
				//System.out.println("reportedDaysPerc: "+reportedDaysPerc+" nonReportedDaysPerc: "+nonReportedDaysPerc);
				
				complienceSummaryMap.put("Not Reported", reportedDays);
				complienceSummaryMap.put("Reported", nonReportedDays);
			}
			for (Map.Entry<String, Integer> entry : complienceSummaryMap.entrySet())
            {
                System.out.print("complienceSummaryMap entry: "+entry.getKey() + ": "+entry.getValue());
                rowData = new JSONObject();
                rowData.put("reported_nonReported", entry.getKey());
                rowData.put("reportedDays", entry.getValue());
                rawDataComplianceHirarchyDB2Json.put(count, rowData);
				count ++;
            }
			rs.close();
			rs=null;
			pstmt.close();
			pstmt=null;
		}
		catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
					rs.close();
					rs = null;
					if (pstmt != null)
					pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :AttendanceCompliance:" + d.getMessage());
				throw new ITMException(d);
			}
		}
		System.out.println("AttendanceCompliance JSON String======>>"+rawDataComplianceHirarchyDB2Json.toString());
		return rawDataComplianceHirarchyDB2Json;
		
	}
	private String checkNull(String str)
	{
		if (str == null)
		{
			return "";
		} else
		{
			return str;
		}
	}
	private String checkNumber(String str)
	{
		if (str == null)
		{
			return "0";
		} else
		{
			return str;
		}
	}
}
