package ibase.dashboard.iem.servlet;

import ibase.dashboard.iem.ejb.ManagmentDashboardRemote;
import ibase.system.config.AppConnectParm;
import ibase.utility.UserInfoBean;
import ibase.webitm.utility.ITMException;
import java.io.IOException;
import java.io.OutputStream;
import javax.naming.InitialContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.json.simple.JSONObject;

public class WorkAlloSummaryServlet extends HttpServlet
{
	private static final long serialVersionUID = 1L;
	
	public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException
	{
		doPost(request, response);
	}

	public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException
	{
		ManagmentDashboardRemote mangmntDashboardRmt = null;
		InitialContext context = null;
		AppConnectParm appConnectParm = new AppConnectParm();
		String dataSourceName = "";
		String frmDate = "";
		String toDate = "";
		String projectmngr = "";	
		String dataProvider = "";		
		UserInfoBean userInfo = null;
		HttpSession session = null;
		try
		{
			System.out.println("in  WorkAlloSummaryServlet  ");
			response.setContentType("application/xml");			
			frmDate        = request.getParameter("frmDate");
			toDate         = request.getParameter("toDate");
			dataSourceName = request.getParameter("dataSourceName");		
			projectmngr    = request.getParameter("PROJECT_MANAGER");
			dataProvider   		= request.getParameter("viewOptionSelectd");
			System.out.println("viewOptionSelectd in Workallocation servlet=="+dataProvider);
			//projectmngr    ="BE001";
			System.out.println(" projectmngr from drop down is="+projectmngr);
			if (projectmngr == null || projectmngr.trim().length() == 0)
			{
				session      = request.getSession(true);
				userInfo     = (UserInfoBean) session.getAttribute("USER_INFO");
				projectmngr  = userInfo.getEmpCode();
			}
			System.out.println("projectmngr= "+projectmngr + " from data ="+ frmDate +" to date ="+toDate);
			context                   = new InitialContext(appConnectParm.getProperty());
			mangmntDashboardRmt       = (ManagmentDashboardRemote) context.lookup("ibase/ManagmentDashboard/remote");
			JSONObject jsonObjData    = (JSONObject) mangmntDashboardRmt.getWorkAlloSummary(dataSourceName, dataProvider ,projectmngr, frmDate, toDate);
			OutputStream outputStream = response.getOutputStream();
			outputStream.write(jsonObjData.toString().getBytes());
			outputStream.flush();
			outputStream.close();
			System.out.println(" Final data set for WorkAlloSummaryServlet  build the Graph is===" + jsonObjData);

		} catch (Exception e)
		{
			System.out.println("Exception :ibase.dashboard.iem.servlet: WorkAlloSummaryServlet :doPost(HttpServletRequest request, HttpServletResponse response) :" + e);
			try
			{
				throw new ITMException(e);
			} catch (ITMException e1)
			{
				e1.printStackTrace();
			}
		}
	}


}