package ibase.dashboard.common.hibernate.utility;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

import org.hibernate.HibernateException;
import org.hibernate.SessionFactory;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.MetadataSources;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
//import org.hibernate.cfg.Configuration;
//import org.hibernate.service.ServiceRegistry;

public class HibernateUtil {

	//private static final SessionFactory sessionFactory = buildSessionFactory();
	private static final SessionFactory sessionFactory;

	//private static SessionFactory buildSessionFactory() 
	static 
	{
		try 
		{
			/*
			// For Hibernate 4.x
			// 1. configuring hibernate
			Configuration configuration = new Configuration().configure("resource/hibernate.cfg.xml");

			// 2. create sessionfactory
			ServiceRegistry serviceRegistry = new StandardServiceRegistryBuilder().applySettings(configuration.getProperties()).build();
	        SessionFactory sessionFactory = configuration.buildSessionFactory(serviceRegistry);
			
			// Create the SessionFactory from hibernate.cfg.xml
			return sessionFactory;
	        */
			
			// For Hibernate 5.x
			// 1. configuring hibernate
    		StandardServiceRegistry standardRegistry = new StandardServiceRegistryBuilder().configure("resource/hibernate.cfg.xml").build();
	    	
    		// 2. create sessionfactory
	    	Metadata metaData = new MetadataSources(standardRegistry).getMetadataBuilder().build();
	    	sessionFactory = metaData.getSessionFactoryBuilder().build();
		} 
		catch (Throwable ex) 
		{
			// Make sure you log the exception, as it might be swallowed
			System.err.println("Initial SessionFactory creation failed." + ex);
			throw new ExceptionInInitializerError(ex);
		}
	}
	
	public static SessionFactory getSessionFactory() 
	{
		return sessionFactory;
	}

	public static void shutdown() 
	{
		// Close caches and connection pools
		getSessionFactory().close();
	}
	
	
	private static final Map<String, SessionFactory> sessionFactories = new HashMap<String, SessionFactory>();

	private static SessionFactory buildSessionFactory(String dbName) 
	{
		try 
		{
			/*
			// For Hibernate 4.x
			// 1. configuring hibernate
			Configuration configuration = new Configuration().configure("hibernate.cfg.xml");

			// 2. create sessionfactory
			ServiceRegistry serviceRegistry = new StandardServiceRegistryBuilder().applySettings(configuration.getProperties()).build();
	        SessionFactory sessionFactory = configuration.buildSessionFactory(serviceRegistry);
	        */
			
			// For Hibernate 5.x
			// 1. configuring hibernate
    		StandardServiceRegistry standardRegistry = new StandardServiceRegistryBuilder().configure("resource/hibernate.cfg.xml").build();
	    	
    		// 2. create sessionfactory
	    	Metadata metaData = new MetadataSources(standardRegistry).getMetadataBuilder().build();
	    	SessionFactory sessionFactory = metaData.getSessionFactoryBuilder().build();
	       
	        sessionFactories.put(dbName,sessionFactory);
	        
	        // Create the SessionFactory from hibernate.cfg.xml
			return sessionFactory;
		} 
		catch (final HibernateException e) 
		{
			// Make sure you log the exception, as it might be swallowed
			System.err.println("Initial SessionFactory creation failed." + e);
			e.printStackTrace();
			throw new ExceptionInInitializerError(e);
	    }
		catch (Throwable ex) 
		{
			// Make sure you log the exception, as it might be swallowed
			System.err.println("Initial SessionFactory creation failed." + ex);
			ex.printStackTrace();
			throw new ExceptionInInitializerError(ex);
		}
	}
	
	public static SessionFactory getSessionFactory(String dbName) 
	{
		if( "DEFAULT".equalsIgnoreCase(dbName) )
		{
			return getSessionFactory();
		}
		else
		{
			SessionFactory _sessionFactory = sessionFactories.get(dbName);
			if( _sessionFactory == null )
			{
				_sessionFactory = buildSessionFactory(dbName);
			}
			return _sessionFactory;
		}
	}

	public static void shutdown(String dbName) 
	{
		// Close caches and connection pools
		getSessionFactory(dbName).close();
	}
	
	public static String DB_DATE_FORMAT = "yyyy-MM-dd";
	public static String APPL_DATE_FORMAT = "dd/MM/yyyy";
	
	//Get Date object in Provided Format
	public static Date getDateObject(String dateStr, String dateFormat) 
	{
		Date dateObj = null;
		SimpleDateFormat simpleDateFormat = null;
		try
		{			
			simpleDateFormat = new SimpleDateFormat(dateFormat);
			dateObj = simpleDateFormat.parse(dateStr);
		}
		catch(Exception e)
		{
			System.out.println("Exception :GenericUtility :getDateObject :==>\n"+e.getMessage());
			e.printStackTrace();
		}
		return dateObj;
	}
	
	//While Sending date to Client End
	//Get formatted Date String DB to APPL format
	public static String getValidDB2APPLDate(String dateStr)
	{
		return getValidDateString(dateStr, DB_DATE_FORMAT, APPL_DATE_FORMAT);
	}
	
	//While inserting / updating date to Database
	//Get formatted Date String APPL to DB format
	public static String getValidAPPL2DBDate(String dateStr)
	{
		return getValidDateString(dateStr, APPL_DATE_FORMAT, DB_DATE_FORMAT);
	}
	
	private static String getValidDateString(String dateStr, String sourceDateFormat, String targetDateFormat) 
	{
		Object date = null;
		SimpleDateFormat sdfOutput = null;
		String retDateStr = "";
		try
		{
			if (!(sourceDateFormat.equalsIgnoreCase(targetDateFormat)))
			{
				if (sourceDateFormat.indexOf("/") != -1)
				{
					dateStr.replace('/', '-');
				}
				else if (sourceDateFormat.indexOf(".") != -1)
				{
					dateStr.replace('.', '-');
				}

				date = new SimpleDateFormat(sourceDateFormat).parse(dateStr);
				sdfOutput = new SimpleDateFormat(targetDateFormat);
				retDateStr = sdfOutput.format(date);
			}
			else
			{
				retDateStr = dateStr;
			}
		}
		catch (Exception e)
		{
			System.out.println("Exception :GenericUtility :getValidDateString :==>"+e.getMessage());
			e.printStackTrace();
		}
		return retDateStr;
	}
}