package ibase.webitm.ejb.appraisal;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

import javax.ejb.Stateless;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.ITMException;

/**
 * Session Bean implementation class AppraisalSpecEJB
 * [Master component of Appraisal Specification]
 */
@Stateless
public class AppraisalSpecEJB extends ValidatorEJB implements AppraisalSpecRemote, AppraisalSpecLocal 
{
	public String wfValData(String xmlString, String xmlString1, String xmlString2, String objContext, String editFlag, String xtraParams) throws RemoteException, ITMException 
	{
		System.out.println("Came Inside wfValData:::");

		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String errString = "";
		System.out.println("xmlString ["+xmlString+"]");
		System.out.println("xmlString1["+xmlString1+"]");
		System.out.println("xmlString2["+xmlString2+"]");
		try
		{
			if(xmlString != null && xmlString.trim().length()!=0)
			{
				dom = parseString(xmlString); 
			}
			if(xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = parseString(xmlString1); 
			}
			if(xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = parseString(xmlString2);
			}
			errString = wfValData(dom,dom1,dom2,objContext,editFlag,xtraParams);
		}
		catch(Exception e)
		{
			System.out.println("Exception : [AppraisalSpecEJB][wfValData(String xmlString)] : ==>\n"+e.getMessage());
			e.printStackTrace();

		}
		return (errString); 
	}

	public String wfValData(Document dom, Document dom1, Document dom2, String objContext, String editFlag, String xtraParams) throws ITMException
	{
		String userId = "";
		String errString = "";
		NodeList parentList = null;
		NodeList childList = null;
		Node parentNode = null;
		Node childNode = null;
		String childNodeName = null;
		int counter;
		Connection conn = null;
		int noOfChilds = 0;
		int currentFormNo = 0;		

		StringBuffer errStringXml = null;

		int cnt = 0;
		String sql = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		
		String sqlString = "";
		String sqlInput = "";
		String apprSpec = "";
		String specDetails = "";
		String apprSpecParent = "";
		E12GenericUtility genericUtility = new E12GenericUtility();

		System.out.println("editFlag...wfValdata ["+editFlag+"]");

		try
		{
			conn = getConnection();
			conn.setAutoCommit(false);

			userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
			errStringXml = new StringBuffer("<?xml version=\"1.0\"?>\r\n<Root><Errors>");
			if(objContext != null && objContext.trim().length()>0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			parentList = dom.getElementsByTagName("Detail" + currentFormNo);
			parentNode = parentList.item(0);
			childList = parentNode.getChildNodes();
			noOfChilds = childList.getLength();
			for(counter = 0; counter < noOfChilds; counter++)
			{
				childNode = childList.item(counter);
				childNodeName = childNode.getNodeName();
				switch(currentFormNo)
				{
				case 1:
					if(childNodeName.equalsIgnoreCase("APPR_SPEC"))
					{ 
						apprSpec = genericUtility.getColumnValue("appr_spec", dom);
						System.out.println("apprSpec::"+apprSpec);
						if(apprSpec == null || apprSpec.trim().length() == 0)
						{
							errString = getErrorString("APPR_SPEC", "VTAPPRSPEC", userId);
						}
						else if(apprSpec != null && apprSpec.trim().length()> 0 && editFlag.equalsIgnoreCase("A"))
						{
							cnt = 0;
							sql = "Select count(*) as cnt from appraisal_spec where appr_spec = ?";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, apprSpec);
							rs = pstmt.executeQuery();
							while(rs.next())
							{
								cnt = rs.getInt("cnt");
							}
							if(rs != null)
							{
								rs.close();
								rs = null;
							}
							if(pstmt != null)
							{
								pstmt.close();
								pstmt = null;
							}
							if(cnt > 0)
							{
								errString = getErrorString("APPR_SPEC", "VTINVLSPEC", userId);
							}
						}
					}
					else if(childNodeName.equalsIgnoreCase("SPEC_DETAILS"))
					{ 
						specDetails = genericUtility.getColumnValue("spec_details", dom);
						System.out.println("specDetails:["+specDetails+"]");
						if(specDetails == null || specDetails.trim().length() == 0)
						{
							errString = getErrorString("SPEC_DETAILS", "VTSPECDETS", userId);
						}
					}
					else if(childNodeName.equalsIgnoreCase("APPR_SPEC__PARENT"))
					{ 
						apprSpecParent = genericUtility.getColumnValue("appr_spec__parent", dom);
						System.out.println("apprSpecParent::["+apprSpecParent+"]");
						if(apprSpecParent != null && apprSpecParent.trim().length() > 0)
						{
							sql = "Select count(*) as cnt from appraisal_spec where appr_spec = ?";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, apprSpecParent);
							rs = pstmt.executeQuery();
							while(rs.next())
							{
								cnt = rs.getInt("cnt");
							}
							if(rs != null)
							{
								rs.close();
								rs = null;
							}
							if(pstmt != null)
							{
								pstmt.close();
								pstmt = null;
							}
							if(cnt == 0)
							{
								errString = getErrorString("APPR_SPEC__PARENT", "VTSPECPARE", userId);
							}
						}
					}
					else if(childNodeName.equalsIgnoreCase("sql_input"))
					{
						sqlInput = genericUtility.getColumnValue("sql_input", dom);
						if(sqlInput != null && sqlInput.trim().length() > 0)
						{
							sqlString = genericUtility.getColumnValue("sql", dom);
							if(sqlString == null || sqlString.trim().length() == 0)
							{
								errString = getErrorString("sql", "VTNULLSQL", userId);
							}
						}
					}
					break;
				}
				if(errString != null && errString.trim().length()> 0)
				{
					break;
				}
			}
			errStringXml.append("</Errors></Root> \r\n");
		}
		catch(Exception e)
		{
			System.out.println( "Exception : [AppraisalSpecEJB][wfValData(String xmlString)] : ==>\n"+e.getMessage());
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(conn != null)
				{
					conn.close();
					conn = null;
				}
			}
			catch(Exception e1)
			{
				System.out.println( "Exception : [AppraisalSpecEJB][wfValData] : ==>\n"+e1.getMessage());
				throw new ITMException(e1);
			}
		}
		return errString;
	}
}
