package proteus.ecm.hibernate.bean;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Store;
import org.json.JSONObject;

@Indexed
@Entity
@Table(name = "ITM_ATTRIB_VAL")
@XmlRootElement(name = "ItemAttribVal")
public class ItemAttributeVal implements java.io.Serializable 
{
	private static final long serialVersionUID = 1L;

	@Id
	@Field(store = Store.YES, analyze = Analyze.NO)
	@Column(name = "ATTRIB_CODE")
	private String attribCode;

	@Id
	@Field(store = Store.YES, analyze = Analyze.NO)
	@Column(name = "ATTRIB_ID")
	private String attribId;

	@Column(name = "DESCR")
	private String descr;

	@Column(name = "SH_DESCR")
	private String shDescr;

	@Column(name = "ACTIVE_YN")
	private String activeYn;
	
    @Column(name="SORT_ORDER", nullable = true) 
    private Integer sortOrder;
    
    public ItemAttributeVal() {
    	
    }
    
	public ItemAttributeVal(String attribCode, String attribId, String descr, String shDescr, String activeYn, Integer sortOrder) 
	{
		this.attribCode = attribCode;
		this.attribId = attribId;
		this.shDescr = shDescr;
		this.activeYn = activeYn;
		this.sortOrder = sortOrder;
	}

	public String getAttribCode() {
		return attribCode;
	}

	@XmlElement
	public void setAttribCode(String attribCode) {
		this.attribCode = attribCode;
	}

	public String getAttribId() {
		return attribId;
	}

	@XmlElement
	public void setAttribId(String attribId) {
		this.attribId = attribId;
	}

	public String getDescr() {
		return descr;
	}

	@XmlElement
	public void setDescr(String descr) {
		this.descr = descr;
	}

	public String getShDescr() {
		return shDescr;
	}

	@XmlElement
	public void setShDescr(String shDescr) {
		this.shDescr = shDescr;
	}

	public String getActiveYn() {
		return activeYn;
	}

	@XmlElement
	public void setActiveYn(String activeYn) {
		this.activeYn = activeYn;
	}

	public Integer getSortOrder() {
		return sortOrder;
	}

	@XmlElement 
	public void setSortOrder(Integer sortOrder) { 
		this.sortOrder = sortOrder; 
	}

	@Override
	public String toString() {
		return "\n itemAttributeVal.toString >> [" + new JSONObject(this).toString() + "]";
	}
}
