package proteus.ecm.hibernate.bean;

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

import org.hibernate.annotations.Type;
import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Store;

@Indexed
@Entity
@Table(name = "ECM_USER_ACTIVITY")
@XmlRootElement(name = "UserActivity")
public class ECMUserActivity implements java.io.Serializable 
{	
	private static final long serialVersionUID = 1L;
	
	@Id
	@Field(store = Store.YES, analyze = Analyze.NO)
	/*@SequenceGenerator(name = "MySequence", sequenceName = "usr_act_seq", allocationSize=1)
	@GeneratedValue(strategy=GenerationType.SEQUENCE, generator="MySequence")
	*/
	@Column(name="TRAN_ID")
	private String tranId;
	
	@Id
	@Field(store = Store.YES, analyze = Analyze.NO)
	@Column(name="USER_ID")
	private String userId;
	
	@Id
	@Field(store = Store.YES, analyze = Analyze.NO)
	@Column(name="SITE_CODE")
	private String siteCode;
	
	@Id
	@Field(store = Store.YES, analyze = Analyze.NO)
	@Column(name="ITEM_CODE")
	private String itemCode;
	
	@Column(name="ACTIVITY_TYPE")
	private String activityType;
	
	@Type(type="timestamp")
	@Column(name="ACTIVITY_DATE")
	private Date activityDate;
	
	@Column(name="ACTIVITY_DETAIL")
	private String activityDetail;
	
	public ECMUserActivity() {

	}	
	
	public ECMUserActivity(String trandId, String userId, String siteCode, String itemCode, String activityType,
			Date activityDate, String activityDetail) {
		this.tranId = trandId;
		this.userId = userId;
		this.siteCode = siteCode;
		this.itemCode = itemCode;
		this.activityType = activityType;
		this.activityDate = activityDate;
		this.activityDetail = activityDetail;
	}

	public String getTrandId() {
		return tranId;
	}

	@XmlElement
	public void setTranId(String trandId) {
		this.tranId = trandId;
	}

	public String getUserId() {
		return userId;
	}

	@XmlElement
	public void setUserId(String userId) {
		this.userId = userId;
	}

	public String getSiteCode() {
		return siteCode;
	}

	@XmlElement
	public void setSiteCode(String siteCode) {
		this.siteCode = siteCode;
	}

	public String getItemCode() {
		return itemCode;
	}

	@XmlElement
	public void setItemCode(String itemCode) {
		this.itemCode = itemCode;
	}

	public String getActivityType() {
		return activityType;
	}

	@XmlElement
	public void setActivityType(String activityType) {
		this.activityType = activityType;
	}

	public Date getActivityDate() {
		return activityDate;
	}

	@XmlElement
	public void setActivityDate(Date activityDate) {
		this.activityDate = activityDate;
	}

	public String getActivityDetail() {
		return activityDetail;
	}

	@XmlElement
	public void setActivityDetail(String activityDetail) {
		this.activityDetail = activityDetail;
	}
		
}
