import {Injectable} from '@angular/core';
import {Action} from '@ngrx/store';

import {ItemDetail} from '../../ecm-model/product-detail-model';

@Injectable()
export class CartActions {
    static LOAD_CART_ITEMS = '[Cart] Load Cart Items';
    loadCartItems(): Action {
        return {
            type: CartActions.LOAD_CART_ITEMS
        };
    }
    
    static LOAD_CART_ITEMS_SUCCESS = '[Cart] Load Cart Items Success';
    loadCartItemsSuccess(cartItems): Action {
        console.log('[Cart] Load Cart Items Success',cartItems.length);
        
        if(!cartItems.length)
        {
            cartItems = [];
        }
        return {
            type: CartActions.LOAD_CART_ITEMS_SUCCESS,
            payload: cartItems
        };
        
    }
    
    static ADD_TO_CART = '[Cart] Add to Cart';
    addToCart(cartItem): Action {
        return {
            type: CartActions.ADD_TO_CART,
            payload: cartItem
        };
    }

    static ADD_TO_CART_SUCCESS = '[Cart] Add to Cart Success';
    addToCartSuccess(cartItem): Action {
        return {
            type: CartActions.ADD_TO_CART_SUCCESS,
            payload: cartItem
        };
    }
    
    static UPDATE_CART = '[Cart] Update Cart';
    updateCart(item): Action {
        return {
            type: CartActions.UPDATE_CART,
            payload: item
        };
    }

    static UPDATE_CART_SUCCESS = '[Cart] Update Cart Success';
    updateCartSuccess(item): Action {
        return {
            type: CartActions.UPDATE_CART_SUCCESS,
            payload: item
        };
    }
    
    static DELETE_CART_ITEM = '[Cart] Delete CartItem';
    deleteCartItem(item): Action {
        return {
            type: CartActions.DELETE_CART_ITEM,
            payload: item
        };
    }

    static DELETE_CART_ITEM_SUCCESS = '[Cart] Delete CartItem Success';
    deleteCartItemSuccess(item): Action {
        return {
            type: CartActions.DELETE_CART_ITEM_SUCCESS,
            payload: item
        };
    }
    
    static RESET_CART = '[CART] Reset CART';
    resetCart(): Action {
        return {
            type: CartActions.RESET_CART
        };
    }
}