package proteus.ecm.cache.dao;

import java.util.Date;

import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;

import org.infinispan.Cache;
import org.infinispan.commons.CacheException;

import proteus.ecm.cache.CacheManager;
import proteus.ecm.cache.bean.ECMUserTracker;

public class UserActivityCache
{
	
	// @RestService == > GET : "/action/cart/{itemCode}" & "/action/recentView/{itemCode}" 
	public ECMUserTracker getCachedUserData(String sessionId, String cacheName)
	{
		System.out.println("Inside getCachedUserData >>" + sessionId + "<>" + cacheName);
		ECMUserTracker userBean = null;
		try
		{
			if (!CacheManager.getInstance().cacheExists(cacheName)) {
				System.out.printf("\n Using System default Cache as Requested Cache \"%s\" is not configured", cacheName); // cacheName = CacheManager.SYSTEM_CACHE_NAME;
				CacheManager.createInstance(cacheName);
			}
			
			String cacheKey = "USER_" + sessionId;

			Cache cache = CacheManager.getInstance().getCache(cacheName);
			Object userObj = cache.get(cacheKey);
			if (userObj != null) {
				userBean = (ECMUserTracker) userObj; // TypeCasting
			}
			System.out.println("Inside getCachedUserData > userBean >" + userBean);

		} 
		catch (SecurityException | IllegalStateException | CacheException e) 
		{
			System.out.println("getCachedUserData()---- Exception type : " + e.getClass().getName() + "]" + e + "[" + e.getCause());
			e.printStackTrace();
		} 
		catch (Exception e) 
		{
			System.out.println("getCachedUserData() ---- Exception type : " + e.getClass().getName() + "]" + e + "[" + e.getCause());
			e.printStackTrace();
		}

		return userBean;
	}

	// @RestService == > POST : "/action/cart/{itemCode}"
	public void storeCartItem(String itemCode, String cartDetails, String sessionId, String cacheName) 
	{
		System.out.println("Inside storeCartItem >>" + sessionId + "<>" + cacheName);
		try 
		{
			if (!CacheManager.getInstance().cacheExists(cacheName)) {
				System.out.printf("\n Using System default Cache as Requested Cache \"%s\" is not configured", cacheName); // cacheName = CacheManager.SYSTEM_CACHE_NAME;
				CacheManager.createInstance(cacheName);
			}
			
			String cacheKey = "USER_" + sessionId;

			Cache cache = CacheManager.getInstance().getCache(cacheName);
			Object userObj = cache.get(cacheKey);
			ECMUserTracker userBean = new ECMUserTracker();
			if (userObj != null) {
				userBean = (ECMUserTracker) userObj; // TypeCasting
			}
			userBean.addToCartProduct(itemCode, cartDetails);
			System.out.println("Inside storeCartItem > userBean >" + userBean);

			TransactionManager tm = cache.getAdvancedCache().getTransactionManager();
			tm.begin();
			cache.put(cacheKey, userBean);
			tm.commit();

		} 
		catch (SecurityException | IllegalStateException | RollbackException | HeuristicMixedException | HeuristicRollbackException | NotSupportedException | SystemException | CacheException e) 
		{
			System.out.println("storeCartItem()----Exception type : " + e.getClass().getName() + "]" + e + "[" + e.getCause() + "] storeCartItem----\n");
			e.printStackTrace();
		} 
		catch (Exception e)
		{
			System.out.println("storeCartItem(catCode)1 ---- Exception type : " + e.getClass().getName() + "]" + e + "[" + e.getCause());
			e.printStackTrace();
		}
	}

	// @RestService == > POST : "/action/recentView/{itemCode}"
	public void storeRecentViewItem(String itemCode, Date activityDate, String cacheName, String sessionId) 
	{
		System.out.println("Inside storeRecentViewItem >>" + cacheName);

		try 
		{
			if (!CacheManager.getInstance().cacheExists(cacheName)) {
				System.out.printf("\n Using System default Cache as Requested Cache \"%s\" is not configured", cacheName); // cacheName = CacheManager.SYSTEM_CACHE_NAME;
				CacheManager.createInstance(cacheName);
			}
			String cacheKey = "USER_" + sessionId;

			Cache cache = CacheManager.getInstance().getCache(cacheName);
			Object userObj = cache.get(cacheKey);
			ECMUserTracker userBean = new ECMUserTracker();
			if (userObj != null) {
				userBean = (ECMUserTracker) userObj; // TypeCasting
			}
			userBean.setBrowsedProduct(itemCode, activityDate);
			System.out.println("Inside storeRecentViewItem > userBean >" + userBean);
			TransactionManager tm = cache.getAdvancedCache().getTransactionManager();
			tm.begin();
			cache.put(cacheKey, userBean);
			tm.commit();
		} 
		catch (SecurityException | IllegalStateException | RollbackException | HeuristicMixedException | HeuristicRollbackException | NotSupportedException | SystemException | CacheException e) 
		{
			System.out.println("Exception type : " + e.getClass().getName() + "]" + e + "[" + e.getCause() + "] storeRecentViewItem----\n");
			e.printStackTrace();
		}
		catch (Exception e)
		{
			System.out.println("storeRecentViewItem() ---- Exception type : " + e.getClass().getName() + "]" + e + "[" + e.getCause());
			e.printStackTrace();
		}
	}

	// @RestService == > DELETE : "/action/cart/{itemCode}"
	public void removeCartItem(String itemCode, String sessionId, String cacheName) 
	{
		System.out.println("Inside removeCartItem >>" + sessionId + "<>" + cacheName);
		try 
		{
			if (!CacheManager.getInstance().cacheExists(cacheName)) {
				System.out.printf("\n Using System default Cache as Requested Cache \"%s\" is not configured", cacheName); // cacheName = CacheManager.SYSTEM_CACHE_NAME;
				CacheManager.createInstance(cacheName);
			}
			String cacheKey = "USER_" + sessionId;

			Cache cache = CacheManager.getInstance().getCache(cacheName);
			Object userObj = cache.get(cacheKey);
			ECMUserTracker userBean = new ECMUserTracker();
			if (userObj != null) {
				userBean = (ECMUserTracker) userObj; // TypeCasting
			}
			userBean.removeCartProduct(itemCode);
			System.out.println("Inside removeCartItem > userBean >" + userBean);

			TransactionManager tm = cache.getAdvancedCache().getTransactionManager();
			tm.begin();
			cache.put(cacheKey, userBean);
			tm.commit();

		} 
		catch (SecurityException | IllegalStateException | RollbackException | HeuristicMixedException | HeuristicRollbackException | NotSupportedException | SystemException | CacheException e) 
		{
			System.out.println("removeCartItem()----Exception type : " + e.getClass().getName() + "]" + e + "[" + e.getCause() + "] removeCartItem----\n");
			e.printStackTrace();
		} 
		catch (Exception e)
		{
			System.out.println("removeCartItem() ---- Exception type : " + e.getClass().getName() + "]" + e + "[" + e.getCause());
			e.printStackTrace();
		}
	}

	public void storeWishlistItem(String itemCode, String wishlistDetails, String cacheName, String sessionId) 
	{
		System.out.println("Inside storeWishlistItem >>" + cacheName);

		try 
		{
			if (!CacheManager.getInstance().cacheExists(cacheName)) {
				System.out.printf("\n Using System default Cache as Requested Cache \"%s\" is not configured", cacheName); // cacheName = CacheManager.SYSTEM_CACHE_NAME;
				CacheManager.createInstance(cacheName);
			}
			String cacheKey = "USER_" + sessionId;

			Cache cache = CacheManager.getInstance().getCache(cacheName);
			Object userObj = cache.get(cacheKey);
			ECMUserTracker userBean = new ECMUserTracker();
			if (userObj != null) {
				userBean = (ECMUserTracker) userObj; // TypeCasting
			}
			userBean.setWishlistedProducts(itemCode, wishlistDetails);
			System.out.println("Inside storeWishlistItem > userBean >" + userBean);
			TransactionManager tm = cache.getAdvancedCache().getTransactionManager();
			tm.begin();
			cache.put(cacheKey, userBean);
			tm.commit();
		} 
		catch (SecurityException | IllegalStateException | RollbackException | HeuristicMixedException | HeuristicRollbackException | NotSupportedException | SystemException | CacheException e) 
		{
			System.out.println("Exception type : " + e.getClass().getName() + "]" + e + "[" + e.getCause() + "] storeWishlistItem----\n");
			e.printStackTrace();
		}
		catch (Exception e)
		{
			System.out.println("storeWishlistItem() ---- Exception type : " + e.getClass().getName() + "]" + e + "[" + e.getCause());
			e.printStackTrace();
		}
	}

	public void removeWishlistItem(String itemCode, String sessionId, String cacheName)
	{
		System.out.println("Inside removeWishlistItem >>" + sessionId + "<>" + cacheName);
		try 
		{
			if (!CacheManager.getInstance().cacheExists(cacheName)) {
				System.out.printf("\n Using System default Cache as Requested Cache \"%s\" is not configured", cacheName); // cacheName = CacheManager.SYSTEM_CACHE_NAME;
				CacheManager.createInstance(cacheName);
			}
			String cacheKey = "USER_" + sessionId;

			Cache cache = CacheManager.getInstance().getCache(cacheName);
			Object userObj = cache.get(cacheKey);
			ECMUserTracker userBean = new ECMUserTracker();
			if (userObj != null) {
				userBean = (ECMUserTracker) userObj; // TypeCasting
			}
			userBean.removeWishlistedProducts(itemCode);
			System.out.println("Inside removeWishlistItem > userBean >" + userBean);

			TransactionManager tm = cache.getAdvancedCache().getTransactionManager();
			tm.begin();
			cache.put(cacheKey, userBean);
			tm.commit();

		} 
		catch (SecurityException | IllegalStateException | RollbackException | HeuristicMixedException | HeuristicRollbackException | NotSupportedException | SystemException | CacheException e) 
		{
			System.out.println("removeWishlistItem()----Exception type : " + e.getClass().getName() + "]" + e + "[" + e.getCause() + "] removeWishlistItem----\n");
			e.printStackTrace();
		} 
		catch (Exception e)
		{
			System.out.println("removeWishlistItem() ---- Exception type : " + e.getClass().getName() + "]" + e + "[" + e.getCause());
			e.printStackTrace();
		}
	}

}
