import { Component, OnInit, Input, ViewEncapsulation, OnChanges, ViewChild } from '@angular/core';
import { MdSnackBar } from '@angular/material';

import { RESIZE_EVENT } from '../ecm-store/ecm-resize';

import { AppState } from '../ecm-store/reducers';
import { Store } from '@ngrx/store';
import { WishListActions } from '../ecm-store/actions';

import { EcmPanelComponent } from '../ecm-view/ecm-panel/ecm-panel.component';

declare var reinitFlickity: any;

@Component( {
    selector: 'ecm-carousel',
    templateUrl: './ecm-carousel.component.html',
    styleUrls: ['./ecm-carousel.component.css'],
    encapsulation: ViewEncapsulation.None
})
export class EcmCarouselComponent implements OnInit, OnChanges {

    @Input() cardItems: any;
    cardsPerSlide: string = '{ "groupCells": 3 }';
    
    @ViewChild( 'ecmPanel' ) ecmPanel: EcmPanelComponent;
    
    constructor(private wishlistAction: WishListActions, private store: Store<AppState>, public snackBar: MdSnackBar) {}

    ngOnInit() {
        /*
        console.log( " ngOnInit this.cardItems [" + this.cardItems + "]");
        if( this.cardItems && this.cardItems.length > 10 ) {
            let size = this.cardItems.length;
            
            this.cardItems = this.cardItems.slice(0, 9);
            console.log( "size[" + size + "]this.cardItems [" + this.cardItems + "]");
            
            let viewAll = {"viewAll" : "View All +"};
            this.cardItems.push( viewAll );
            console.log( "viewAll [" + viewAll + "]");
            console.log( "this.cardItems [" + this.cardItems + "]");
        }
        */

        RESIZE_EVENT.subscribe(data => {
            //console.log("data["+data+"]");
            this.callUpdate( data );
        });
        let data = document.documentElement.clientWidth;
        this.callUpdate( data );
    }
    
    callUpdate( data : any ) {
        if( data > 1024 )
        {
            this.update(3);
        }
        else if( data < 1023 && data > 639 )
        {
            this.update(2);
        }
        else if( data < 640 )
        {
            this.update(1);
        }
    }
    
    update( numOfCard : number ) {
        this.cardsPerSlide = '{ "groupCells": ' + numOfCard + ' }';
        reinitFlickity();
    }
    
    viewAll() {
        alert("View All Treding Items");
    }
    
    ngOnChanges(){
        console.log("ngOnChanges of Carousel");
    }
    
    addToWishlist( item ) {
        if(this.isAuthUser())
        {
            this.store.dispatch( this.wishlistAction.addToWishlistSuccess( item ) );
            this.openSnackBar('Item Added to your Wishlist');
        }
        else
        {
            //this.header.userAction();
            this.ecmPanel.open({ type: 'overlay', option: 'SIGNIN_OPT', top:'100px', left: 'calc( 50% - 375px / 2 )', width:'375px', height: '535px' });
        }
    }
    
    removeFromWishlist( item ){
        this.store.dispatch( this.wishlistAction.deleteWishlistItemSuccess( item ) );
        this.openSnackBar('Item Deleted from your Wishlist');
    }
    
    openSnackBar( message: string ) {
        this.snackBar.open( message, '', {
            duration: 2000,
        });
    }
    
    isAuthUser(){
        var isAuthUser;
        var userInfo = localStorage.getItem( 'userInfo' );
        if ( userInfo !== 'undefined' && userInfo !== null && userInfo !== 'null' )
        { 
            isAuthUser = true;
        }
        else
        {
            isAuthUser = false;
        }
        return isAuthUser;
    }
}
