/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.proxy.factory;

import java.util.Map;
import org.jboss.ejb3.proxy.factory.ProxyFactoryNotRegisteredException;
import org.jboss.ejb3.proxy.factory.RemoteProxyFactory;
import org.jboss.ejb3.remoting.LoadBalancePolicyNotRegisteredException;
import org.jboss.ha.client.loadbalance.LoadBalancePolicy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteProxyFactoryRegistry {
    private Map<String, Class<? extends RemoteProxyFactory>> factories;
    private Map<String, Class<LoadBalancePolicy>> loadBalancePolicies;

    public Map<String, Class<? extends RemoteProxyFactory>> getFactories() {
        return this.factories;
    }

    public void setFactories(Map<String, Class<? extends RemoteProxyFactory>> factories) {
        this.factories = factories;
    }

    public Map<String, Class<LoadBalancePolicy>> getLoadBalancePolicies() {
        return this.loadBalancePolicies;
    }

    public void setLoadBalancePolicies(Map<String, Class<LoadBalancePolicy>> loadBalancePolicies) {
        this.loadBalancePolicies = loadBalancePolicies;
    }

    public Class<? extends RemoteProxyFactory> getProxyFactoryClass(String name) throws ProxyFactoryNotRegisteredException {
        Class<? extends RemoteProxyFactory> proxyFactory = this.factories.get(name);
        if (proxyFactory == null) {
            throw new ProxyFactoryNotRegisteredException("Remoting Proxy Factory with name " + name + " is not registered.");
        }
        return proxyFactory;
    }

    public Class<LoadBalancePolicy> getLoadBalancePolicy(String name) throws LoadBalancePolicyNotRegisteredException {
        Class<LoadBalancePolicy> loadBalancePolicy = this.loadBalancePolicies.get(name);
        if (loadBalancePolicy == null) {
            throw new LoadBalancePolicyNotRegisteredException("LoadBalancePolicy with name " + name + " is not registered.");
        }
        return loadBalancePolicy;
    }
}

