/**
 *  Purpose:Create transaction  screen Pallet Request, Request ID:  W15GSUN001
 *  Purpose:Create Pallet Request with stock details ,Request ID: W15HSUN003
 *  Normal Pallet         :Item_ser__rg1::other than 'FS',Location Group::other than Exempted,QC status::not in QC
 *  Pallet with suffix 'Q':Item_ser__rg1::other than 'FS',Location Group::other than Exempted,QC status::pending in QC
 *  Pallet with suffix 'X':Item_ser__rg1::other than 'FS',Location Group::Exempted           ,QC status::not in QC
 *  Pallet with suffix 'M':Item_ser__rg1::other than 'FS',Location Group::Exempted           ,QC status::pending in QC
 *  Pallet with suffix 'B':Item_ser__rg1::'FS'           ,Location Group::other than Exempted,QC status::not in QC
 *  Pallet with suffix 'S':Item_ser__rg1::'FS'           ,Location Group::other than Exempted,QC status::pending in QC
 *  Pallet with suffix 'P':Item_ser__rg1::'FS'           ,Location Group::Exempted           ,QC status::not in QC
 *  Pallet with suffix 'U':Item_ser__rg1::'FS'           ,Location Group::Exempted           ,QC status::pending in QC
 *  Pallet with suffix 'R':Rejected Pallet     
 */

package ibase.webitm.ejb.wms;

import ibase.system.config.*;
import ibase.webitm.ejb.*;
import ibase.webitm.ejb.dis.DistCommon;
import ibase.utility.E12GenericUtility;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.wms.CommonWmsUtil;

import java.io.File;
import java.rmi.RemoteException;
import java.sql.*;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.Date;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import org.w3c.dom.*;

@javax.ejb.Stateless
public class PalletReqIC extends ValidatorEJB implements PalletReqICLocal, PalletReqICRemote 
{
   E12GenericUtility genericUtility = new E12GenericUtility();
	DistCommon discommon = new DistCommon();
	@Override

	public String wfValData() throws RemoteException, ITMException
	{
		return "";
	}

	/**
	 * The public method is used for converting the current form data into a document(DOM)
	 * The dom is then given as argument to the overloaded function wfValData to perform validation
	 * Returns validation string if exists else returns null in XML format
	 * @param xmlString contains the current form data in XML format
	 * @param xmlString1 contains all the header information in the XML format
	 * @param xmlString2 contains the data of all the forms in XML format
	 * @param objContext represents the form number
	 * @param editFlag represents the mode of transaction(A-Add or E-Edit)
	 * @param xtraParams contains additional information such as loginEmpCode,loginCode,chgTerm etc
	 */	
	@Override
	public String wfValData(String xmlString, String xmlString1, String xmlString2, String objContext,String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String errString = null;
		E12GenericUtility genericUtility = new E12GenericUtility();    

		try
		{
			System.out.println( "xmlString ::" + xmlString);
			System.out.println( "xmlString1 ::" + xmlString1);
			System.out.println( "xmlString2 ::" + xmlString2);
			if(xmlString != null && xmlString.trim().length()!=0)
			{
				dom = genericUtility.parseString(xmlString); 
			}
			if(xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = genericUtility.parseString(xmlString1); 
			}
			if(xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = genericUtility.parseString(xmlString2); 
			}
			errString = wfValData( dom, dom1, dom2, objContext, xtraParams,editFlag);
			System.out.println( "ErrString: " + errString);
		}
		catch(Exception e)
		{
			errString = genericUtility.createErrorString(e);
			e.printStackTrace();
			throw new ITMException(e);
		}
		return (errString); 
	}

	/**
	 * The public overloaded method takes a document as input and is used for the validation of required fields 
	 * Returns validation string if exist otherwise returns null in XML format
	 * @param currFormDataDom contains the current form data as a document object model
	 * @param hdrDataDom contains all the header information
	 * @param allFormDataDom contains the field data of all the forms 
	 * @param objContext represents form number
	 * @param editFlag represents the mode of transaction(A-Add or E-Edit)
	 * @param xtraParams contains additional information such as loginEmpCode,loginCode,chgTerm etc
	 */
	@Override
	public String wfValData(Document dom, Document dom1, Document dom2, String objContext, String xtraParams,String editFlag) throws RemoteException, ITMException
	{   				
		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null;
		StringBuffer errStringXml = new StringBuffer("<?xml version=\"1.0\"?>\r\n<Root><Errors>");
		String errorType = "", errCode = "", locCode = "",lotSl="",lotNo="",itemCode="",sqlQ="",sql="";
		ArrayList <String> errList = new ArrayList<String>();
		ArrayList <String>errFields = new ArrayList <String> ();
		E12GenericUtility genericUtility;
		String remarks="",addUser="",addTerm="",addDate="",chgUser="",chgTerm="",chgDate="",descr="" , sql1="";
		int lotSlcnt=0,lotNocnt=0,itemCodecnt=0,locCodecnt=0,itemCodecntQ=0,palletCount = 0,ctr = 0, currentFormNo = 0, childNodeListLength = 0, siteCount = 0, cnt = 0,loccnt=0,palcnt=0,cntLoc = 0;
		double quantity=0,noArt=0,qtyPerArt,noArtQuot=0,noArtRem =0 , notArt = 0,palTcnt=0,quantityStock=0,noArtStock=0, noArtD=0,quantityStockQ=0;
		int locCount = 0;
		String quantityStr="",noArtStr="",tranId="",stkSql="",siteCode = "",userId = "",childNodeName = "",errString = "",
		itemSql="",StatusSql="",status ="",itemRgSql="",locGroupDisp="",locSql="",locGroup="",itemSer="",itemSerRgDisparm=""
			,locSuffixDisp , lastCharS="";
		char lastChar ;
		Document currFormDataDom = dom;
		String loginSite = "",objName="",palletNoQ="";
		ArrayList<String> palletList = new ArrayList();
		ArrayList ArrList = new ArrayList();
		PreparedStatement pstmt = null;
		Connection conn = null;
		ResultSet rs= null;
		objName = getObjNameFromDom(dom, "objName", "2");
		System.out.println("objName----->>["+objName+"]");	
		System.out.println("editFlag----->>["+editFlag+"]");	

		try
		{	
			genericUtility = new E12GenericUtility();		
			System.out.println("xtraParam----->>["+xtraParams+"]");


			loginSite = checkNull(genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginSiteCode" ));

			//Changed and Commented By Santosh on 14-06-2016 :[START]
			//ConnDriver connDriver = new ConnDriver();
			//conn = connDriver.getConnectDB("DriverITM");
			conn = getConnection();
			conn.setAutoCommit(false);
			//connDriver = null;
			//Changed and Commented By Santosh on 14-06-2016 :[END]
			userId = getValueFromXTRA_PARAMS(xtraParams, "loginCode");

			if (objContext != null && objContext.trim().length() > 0) 
			{
				currentFormNo = Integer.parseInt(objContext);
			}	

			switch ( currentFormNo )  // Switch Case for form number
			{
			case 1:
				System.out.println("DOM---->>["+genericUtility.serializeDom(dom).toString()+"]");
				System.out.println("DOM1----->>["+genericUtility.serializeDom(dom1).toString()+"]");
				System.out.println("DOM2----->>["+genericUtility.serializeDom(dom2).toString()+"]");
				System.out.println("editFlag----->>["+editFlag+"]");	

				parentNodeList = dom.getElementsByTagName("Detail1");
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				childNodeListLength = childNodeList.getLength();

				for (ctr = 0; ctr < childNodeListLength; ctr++) 
				{					
					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();
					System.out.println("childNodeName11------->>["+childNodeName+"]");

					/*if("site_code".equalsIgnoreCase(childNodeName))
					{
						siteCode = checkNullAndTrim(genericUtility.getColumnValue("site_code",dom));						
						System.out.println("siteCode ---------->>["+siteCode+"]");	
						if(siteCode.length() == 0)
						{
							errCode = "VMSITECNUL";//Site code cannot be blank
							errList.add( errCode );

							childNode = childNodeList.item(ctr);
							childNodeName = childNode.getNodeName();

							errFields.add( childNodeName.toLowerCase() );
							break;
						}
						else
						{
							if(! "E".equalsIgnoreCase(editFlag))
							{
								siteCount = getDBRowCount(conn, "site", "site_code", siteCode);

								if(siteCount == 0)
								{
									errCode = "VMSITESEXT";//Entered site code not present in site master.
									errList.add( errCode );
									errFields.add( childNodeName.toLowerCase() );
									break;
								}
							}
						}
					}*/

					/*if("loc_code".equalsIgnoreCase(childNodeName))
					{
						locCode = checkNullAndTrim(genericUtility.getColumnValue("loc_code",dom));	
						if(locCode.length() == 0 || locCode.equalsIgnoreCase("")) //BLANK
						{
							errCode = "VMLOCATNUL";//location code cannot be blank
							errList.add( errCode );

							childNode = childNodeList.item(ctr);
							childNodeName = childNode.getNodeName();

							errFields.add( childNodeName.toLowerCase() );
							break;
						}
						else 
						{
							//sql = "SELECT  COUNT(1) FROM LOCATION WHERE INV_STAT !=? AND LOC_CODE=? AND SITE_CODE=?";
							//sql="SELECT  COUNT(1) FROM LOCATION WHERE INV_STAT NOT IN (?,?) AND LOC_CODE=? AND SITE_CODE=?";
							// as site_code is not consider for location master
							sql="SELECT  COUNT(1) FROM LOCATION WHERE INV_STAT NOT IN (?,?) AND LOC_CODE=? ";

							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, "AWMS");
							pstmt.setString(2, "AWMSQ");
							pstmt.setString(3, locCode);
							//pstmt.setString(4, loginSite);
							rs = pstmt.executeQuery();
							if(rs.next())
							{		
								loccnt = rs.getInt(1);
								System.out.println("count location>>>>>>>" +loccnt);
								if(loccnt==0)
								{
									System.out.println("loc_code not exist");
									errCode = "VMLOCATEXT";
									errList.add( errCode );
									errFields.add( childNodeName.toLowerCase() );
									break;
								}
							}
							if(pstmt != null){ pstmt.close();pstmt = null;}
							if(rs != null){rs.close();rs = null;}
						}
					}*/
				}//for loop
				break;

			case 2:
				System.out.println("------in case 2---------------");
				System.out.println("DOM---->>["+genericUtility.serializeDom(dom).toString()+"]");
				System.out.println("DOM1----->>["+genericUtility.serializeDom(dom1).toString()+"]");
				System.out.println("DOM2----->>["+genericUtility.serializeDom(dom2).toString()+"]");	
				System.out.println("editFlag----->>["+editFlag+"]");	

				String palletNo = "";
				parentNodeList = dom2.getElementsByTagName("Detail2");
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				childNodeListLength = childNodeList.getLength();
				//Change by Jagruti Shinde Request Id:[W15JSUN017]  requirement change for Exempted/BSR location inv_stat[start]
				locSuffixDisp = checkNullAndTrim(discommon.getDisparams("999999", "AWMS_LOCATION_SUFFIX", conn));
				System.out.println("AWMS_LOCATION_SUFFIX["+locSuffixDisp+"]");
				String[] locS = locSuffixDisp.split(",");
				System.out.println("Disparm Lenght for locSuffixDisp="+locS.length);
				//Change by Jagruti Shinde Request Id:[W15JSUN017]  requirement change for Exempted/BSR location inv_stat[End]
				for (ctr = 0; ctr < childNodeListLength; ctr++) 
				{
					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();

					palletNo = checkNullAndTrim(genericUtility.getColumnValue("pallet_no",dom));	
					locCode = checkNullAndTrim(genericUtility.getColumnValue("loc_code",dom));	
					itemCode = checkNullAndTrim(genericUtility.getColumnValue("item_code",dom));
					lotNo = (genericUtility.getColumnValue("lot_no",dom));
					lotSl = (genericUtility.getColumnValue("lot_sl",dom));
					noArtStr = checkNullAndTrim(genericUtility.getColumnValue("no_art",dom));
					quantityStr = checkNullAndTrim(genericUtility.getColumnValue("quantity",dom));
					tranId = checkNullAndTrim(genericUtility.getColumnValue("tran_id",dom));
					System.out.println("tran id---" +tranId);

					System.out.println("PALLET NO---" +palletNo);
					if("pallet_no".equalsIgnoreCase(childNodeName))
					{
						if(palletNo.length() == 0 || palletNo.equalsIgnoreCase(""))
						{
							errCode = "VMPALLENUL";//pallet no  cannot be blank
							errList.add( errCode );

							childNode = childNodeList.item(ctr);
							childNodeName = childNode.getNodeName();

							errFields.add( childNodeName.toLowerCase() );
							break;
						}
						else 
						{
							//Change by Jagruti Shinde Request Id:[W15JSUN017]  requirement change for Exempted/BSR location inv_stat[start]
							//site_code is not consider for location master
							/*sql = "SELECT  COUNT(1) FROM LOCATION WHERE INV_STAT = ?  AND LOC_CODE =? ";							
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, "AWMS");
							pstmt.setString(2, palletNo);
							//pstmt.setString(3, loginSite);
							rs = pstmt.executeQuery();
							if(rs.next())
							{	
								cntLoc = rs.getInt(1);
							}
							if(pstmt != null){pstmt.close();pstmt = null;}
							if(rs != null){rs.close();rs = null;}
							if(cntLoc == 0)
							{
								System.out.println("awms pallet count" +cntLoc);
								errCode = "VMPALLEEXT";//pallet 
								errList.add( errCode );
								errFields.add( childNodeName.toLowerCase() );
								break;
							}*/
							sql = "SELECT COUNT(1) FROM LOCATION WHERE INV_STAT = ?  AND LOC_CODE =? ";							
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, "AWMS");
							pstmt.setString(2, palletNo);
							//pstmt.setString(3, loginSite);
							rs = pstmt.executeQuery();
							if(rs.next())
							{	
								cntLoc = rs.getInt(1);
								System.out.println( "cntLoc:::"+cntLoc);
							}
							if(pstmt != null)
							{
								pstmt.close();
								pstmt = null;
							}
							if(rs != null)
							{
								rs.close();
								rs = null;
							}

							if(cntLoc > 0)
							{
								lastChar=palletNo.charAt(palletNo.trim().length()-1);
								System.out.println("lastChar:"+lastChar); 
								System.out.println("locSuffix disparm=["+locSuffixDisp+"] and lastChar["+lastChar+"]");

								if(locSuffixDisp.contains(String.valueOf(lastChar)))
								{
									System.out.println("****Match found in disparm for"+lastChar);
									System.out.println("location with suffix");
									errCode = "VTPALLEEXT";
									errList.add( errCode );
									errFields.add( childNodeName.toLowerCase() );
									break;
								}
								else
								{
									//Changed by Jagruti Shinde,for considering QC rejected locations in Pallet out.Request id:[W16ASUN022]
									//stkSql = "SELECT COUNT(1) FROM STOCK WHERE INV_STAT IN(?,?)  AND LOC_CODE IN (?,?,?,?,?,?,?,?)  AND SITE_CODE=? AND QUANTITY>0";
									stkSql = "SELECT COUNT(1) FROM STOCK WHERE INV_STAT IN(?,?)  AND LOC_CODE IN (?,?,?,?,?,?,?,?,?)  AND SITE_CODE=? AND QUANTITY>0";

									pstmt = conn.prepareStatement(stkSql);
									pstmt.setString(1, "AWMS");
									pstmt.setString(2, "AWMSQ");
									pstmt.setString(3, palletNo);
									pstmt.setString(4, palletNo+"Q");
									pstmt.setString(5, palletNo+"B");
									pstmt.setString(6, palletNo+"X");
									pstmt.setString(7, palletNo+"M");
									pstmt.setString(8, palletNo+"U");
									pstmt.setString(9, palletNo+"P");
									pstmt.setString(10,palletNo+"S");
									//Changed by Jagruti Shinde ,for considering QC rejected locations in Pallet out.Request id:[W16ASUN022]
									pstmt.setString(11,palletNo+"R");
									pstmt.setString(12, loginSite);
									rs = pstmt.executeQuery();
									if(rs.next())
									{	
										palcnt = rs.getInt(1);
									}
									if (pstmt != null)
									{ 
										pstmt.close(); 
										pstmt = null; 
									}
									if (rs != null) 
									{ 
										rs.close(); 
										rs = null; 
									}

									if(palcnt == 0)
									{
										System.out.println("awms pallet count" +palcnt);
										errCode = "VMPALLETQN";//pallet quantity should be more than zero
										errList.add( errCode );
										errFields.add( childNodeName.toLowerCase() );
										break;
									}
								}
							}
							else
							{
								System.out.println("pallet not in AWMS" +cntLoc);
								errCode = "VTPALLEEXT";//pallet 
								errList.add( errCode );
								errFields.add( childNodeName.toLowerCase() );
								break;
							}
							//Change by Jagruti Shinde Request Id:[W15JSUN017]  requirement change for Exempted/BSR location inv_stat[End]

							if ("pallet_req_stk".equalsIgnoreCase(objName))
							{
								//Changed by Jagruti Shinde Request Id:[W16ASUN004] for considering one pallet either for pallet out or pallet consolidation
								//sql = "SELECT FN_CHK_PRS(TRIM(?),?) FROM DUAL ";
								sql = "SELECT FN_CHK_PR(TRIM(?),?) FROM DUAL ";
								pstmt = conn.prepareStatement(sql);

								pstmt.setString(1, palletNo);
								pstmt.setString(2, tranId);
								rs = pstmt.executeQuery();
								if (rs.next())
								{
									palTcnt = rs.getInt(1);
								}
								if (pstmt != null)
								{ 
									pstmt.close(); 
									pstmt = null;
								}
								if (rs != null) 
								{
									rs.close();
									rs = null; 
								}

								if (palTcnt > 0)
								{
									System.out.println("PRESENT IN SWMS FOR DETAILS" + palTcnt);
									errCode = "VMPALDEPEX";
									errList.add(errCode);
									errFields.add(childNodeName.toLowerCase());
									break;
								}
								else if(isRecordExist(dom2))
								{
									System.out.println("pallet detail exist");
									errCode = "VMPALDETEX";//pallet details already exits
									errList.add( errCode );
									errFields.add( childNodeName.toLowerCase() );
									break;
								}
							}
							else
							{
								//Changed by Jagruti Shinde Request Id:[W16ASUN004] for considering one pallet either for pallet out or pallet consolidation
								//sql = "SELECT FN_CHK_PRS(TRIM(?),?) FROM DUAL ";
								sql = "SELECT FN_CHK_PR(TRIM(?),?) FROM DUAL ";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1, palletNo);
								pstmt.setString(2, tranId);
								rs = pstmt.executeQuery();
								if (rs.next())
								{
									palTcnt = rs.getInt(1);
								}
								if (pstmt != null) 
								{ 
									pstmt.close(); 
									pstmt = null;
								}
								if (rs != null) 
								{ 
									rs.close(); 
									rs = null; 
								}

								if (palTcnt > 0)
								{
									System.out.println("PRESENT IN SWMS" + palTcnt);
									errCode = "VMPALDCOEX";
									errList.add(errCode);
									errFields.add(childNodeName.toLowerCase());
									break;
								}

								//System.out.println("IN PALLET REQUEST EDIT FLAG");	
								palletList = checkDuplicaterecord(dom2);
								Set s = new HashSet(palletList);
								System.out.println("Size of arrayList ["+palletList.size()+"]");
								System.out.println("Size of Set ["+s.size()+"]");								  
								if(s.size() < palletList.size())
								{
									System.out.println("pallet  exist");
									errList.add( "VMPALLETSM" );
									errFields.add( childNodeName.toLowerCase() );
									break;
								}							  
								s.clear();
							}

						}
					}
					/*if("loc_code".equalsIgnoreCase(childNodeName))
						{
							//if( "E".equalsIgnoreCase(editFlag) || "A".equalsIgnoreCase(editFlag))
							//{
							System.out.println("editFlag>>>>>>>" +editFlag);
							if(locCode.length() == 0 || locCode.equalsIgnoreCase("")) 
							{

								errCode = "VMLOCATNUL";
								errList.add( errCode );

								childNode = childNodeList.item(ctr);
								childNodeName = childNode.getNodeName();

								errFields.add( childNodeName.toLowerCase() );
								break;
							}
							else 
							{
								String sql = "SELECT  COUNT(1) FROM LOCATION WHERE INV_STAT !=? AND LOC_CODE =? AND SITE_CODE =?";

								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1, "AWMS");
								pstmt.setString(2, locCode);
								pstmt.setString(3, loginSite);
								rs = pstmt.executeQuery();
								if(rs.next())
								{
									locCodecnt = rs.getInt(1);	
									System.out.println("count >>>>>>>" +locCodecnt);
									if(locCodecnt==0)
									{
										System.out.println("location detail exist");
										errCode = "VMLOCATEXT";
										errList.add( errCode );
										errFields.add( childNodeName.toLowerCase() );
										break;
									}
								}
								rs.close();
								pstmt.close();
							}
						}
					 */						
					//Changed for pallet request with stock details [Start]Request Id:W15HSUN003
					if("item_code".equalsIgnoreCase(childNodeName))
					{
						//System.out.println("editFlag item_code>>>>>>>" +editFlag);
						if(itemCode.length() == 0 || itemCode.equalsIgnoreCase("")) 
						{
							errCode = "VMITEMCNUL";
							errList.add( errCode );

							childNode = childNodeList.item(ctr);
							childNodeName = childNode.getNodeName();

							errFields.add( childNodeName.toLowerCase() );
							break;
						}
						else 
						{
							//Changed by Jagruti Shinde,for considering QC rejected locations in Pallet out.Request id:[W16ASUN022]
							//sql = "SELECT COUNT(1) FROM STOCK S ,LOCATION L WHERE S.INV_STAT IN(?,?) AND S.LOC_CODE IN(?,?,?,?,?,?,?,?) AND S.SITE_CODE=? AND S.ITEM_CODE=? AND S.LOC_CODE=L.LOC_CODE AND S.QUANTITY>0 ";
							sql = "SELECT COUNT(1) FROM STOCK S ,LOCATION L WHERE S.INV_STAT IN(?,?) AND S.LOC_CODE IN(?,?,?,?,?,?,?,?,?) AND S.SITE_CODE=? AND S.ITEM_CODE=? AND S.LOC_CODE=L.LOC_CODE AND S.QUANTITY>0 ";

							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, "AWMS");
							pstmt.setString(2, "AWMSQ");
							pstmt.setString(3, palletNo);
							pstmt.setString(4, palletNo+"Q");
							pstmt.setString(5, palletNo+"B");
							pstmt.setString(6, palletNo+"X");
							pstmt.setString(7, palletNo+"M");
							pstmt.setString(8, palletNo+"U");
							pstmt.setString(9, palletNo+"P");
							pstmt.setString(10, palletNo+"S");
							//Changed by Jagruti Shinde,for considering QC rejected locations in Pallet out.Request id:[W16ASUN022]
							pstmt.setString(11, palletNo+"R");
							pstmt.setString(12, loginSite);
							pstmt.setString(13, itemCode);
							rs = pstmt.executeQuery();
							if(rs.next())
							{	
								itemCodecnt = rs.getInt(1);	
								System.out.println("ITEM CODE COUNT FOR AWMS" +itemCodecnt);

							}
							if (pstmt != null)
							{ 
								pstmt.close();
								pstmt = null;
							}
							if (rs != null) 
							{ 
								rs.close(); 
								rs = null; 
							}

							if(itemCodecnt==0)
							{
								System.out.println("item code exist");
								errCode = "VMITEMCEXT";
								errList.add( errCode );
								errFields.add( childNodeName.toLowerCase() );
								break;
							}
						}
					}
					if("lot_no".equalsIgnoreCase(childNodeName))
					{
						if(lotNo == null || lotNo.length()==0) 
						{
							errCode = "VMLOTNONUL";
							errList.add( errCode );

							childNode = childNodeList.item(ctr);
							childNodeName = childNode.getNodeName();

							errFields.add( childNodeName.toLowerCase() );
							break;
						}
						else 
						{
							//Changed by Jagruti Shinde,for considering QC rejected locations in Pallet out.Request id:[W16ASUN022]
							//sql = "SELECT COUNT(1) FROM STOCK S WHERE S.INV_STAT IN(?,?) AND S.LOC_CODE IN(?,?,?,?,?,?,?,?) AND  S.SITE_CODE=?  AND  S.QUANTITY>0  AND  S.ITEM_CODE=? AND S.LOT_NO=?"; 
							sql = "SELECT COUNT(1) FROM STOCK S WHERE S.INV_STAT IN(?,?) AND S.LOC_CODE IN(?,?,?,?,?,?,?,?,?) AND  S.SITE_CODE=?  AND  S.QUANTITY>0  AND  S.ITEM_CODE=? AND S.LOT_NO=?"; 
	
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, "AWMS");
							pstmt.setString(2, "AWMSQ");
							pstmt.setString(3, palletNo);
							pstmt.setString(4, palletNo+"Q");
							pstmt.setString(5, palletNo+"B");
							pstmt.setString(6, palletNo+"X");
							pstmt.setString(7, palletNo+"M");
							pstmt.setString(8, palletNo+"U");
							pstmt.setString(9, palletNo+"P");
							pstmt.setString(10, palletNo+"S");
							//Changed by Jagruti Shinde,for considering QC rejected locations in Pallet out.Request id:[W16ASUN022]
							pstmt.setString(11, palletNo+"R");
							pstmt.setString(12, loginSite);
							pstmt.setString(13, itemCode);
							pstmt.setString(14, lotNo);
							rs = pstmt.executeQuery();
							if(rs.next())
							{	
								lotNocnt = rs.getInt(1);	
								System.out.println("lot number for awms" +lotNocnt);

							}
							if (pstmt != null) 
							{ 
								pstmt.close(); 
								pstmt = null;
							}
							if (rs != null) 
							{
								rs.close(); 
								rs = null;
							}

							if(lotNocnt==0)
							{
								System.out.println("lot number not exist");
								errCode = "VMLOTNOEXT";
								errList.add( errCode );
								errFields.add( childNodeName.toLowerCase() );
								break;
							}
						}
					}
					if("lot_sl".equalsIgnoreCase(childNodeName))
					{
						if(lotSl == null || lotSl.length()==0) 
						{
							errCode = "VMLOTSLNUL";
							errList.add( errCode );

							childNode = childNodeList.item(ctr);
							childNodeName = childNode.getNodeName();

							errFields.add( childNodeName.toLowerCase() );
							break;
						}
						else 
						{
							//Changed by Jagruti Shinde,for considering QC rejected locations in Pallet out.Request id:[W16ASUN022]
							//sql = "SELECT COUNT(1) FROM STOCK S WHERE S.INV_STAT IN(?,?) AND S.LOC_CODE IN(?,?,?,?,?,?,?,?) AND  S.SITE_CODE=?  AND S.QUANTITY>0  AND  S.ITEM_CODE=? AND S.LOT_NO=? AND S.LOT_SL=?";
							sql = "SELECT COUNT(1) FROM STOCK S WHERE S.INV_STAT IN(?,?) AND S.LOC_CODE IN(?,?,?,?,?,?,?,?,?) AND  S.SITE_CODE=?  AND S.QUANTITY>0  AND  S.ITEM_CODE=? AND S.LOT_NO=? AND S.LOT_SL=?";

							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, "AWMS");
							pstmt.setString(2, "AWMSQ");
							pstmt.setString(3, palletNo);
							pstmt.setString(4, palletNo+"Q");
							pstmt.setString(5, palletNo+"B");
							pstmt.setString(6, palletNo+"X");
							pstmt.setString(7, palletNo+"M");
							pstmt.setString(8, palletNo+"U");
							pstmt.setString(9, palletNo+"P");
							pstmt.setString(10, palletNo+"S");
							//Changed by Jagruti Shinde,for considering QC rejected locations in Pallet out.Request id:[W16ASUN022]
							pstmt.setString(11, palletNo+"R");
							pstmt.setString(12, loginSite);
							pstmt.setString(13, itemCode);
							pstmt.setString(14, lotNo);
							pstmt.setString(15, lotSl);
							rs = pstmt.executeQuery();
							if(rs.next())
							{	
								lotSlcnt = rs.getInt(1);
								System.out.println("lot sl count for awms" +lotSlcnt);
							}
							if (pstmt != null) 
							{ 
								pstmt.close();
								pstmt = null;
							}
							if (rs != null) 
							{ 
								rs.close();
								rs = null; 
							}
							if(lotSlcnt==0)
							{
								System.out.println("lot sl exist");
								errCode = "VMLOTSLEXT";
								errList.add( errCode );
								errFields.add( childNodeName.toLowerCase() );
								break;
							}
						}
					}
					if("no_art".equalsIgnoreCase(childNodeName))
					{
						noArtStr = noArtStr.length() == 0 ? "0" : noArtStr;
						noArtD = Double.parseDouble(noArtStr);

						if(noArtD == 0 ) 
						{
							errCode = "VMNOARTNUL";
							errList.add( errCode );
							childNode = childNodeList.item(ctr);
							childNodeName = childNode.getNodeName();

							errFields.add( childNodeName.toLowerCase() );
							break;
						}
						else 
						{
							lotSl = checkNullAndTrim(genericUtility.getColumnValue("lot_sl",currFormDataDom));
							lotNo = checkNullAndTrim(genericUtility.getColumnValue("lot_no",currFormDataDom));
							itemCode = checkNullAndTrim(genericUtility.getColumnValue("item_code",currFormDataDom));
							palletNo = checkNullAndTrim(genericUtility.getColumnValue("pallet_no",currFormDataDom));
							loginSite = checkNull(genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginSiteCode" ));

							//	String sql = "SELECT S.QUANTITY,S.NO_ART FROM STOCK S ,LOCATION L WHERE L.INV_STAT=? AND L.LOC_CODE=? AND  L.SITE_CODE=? AND S.LOC_CODE=L.LOC_CODE AND S.QUANTITY>0  AND  S.ITEM_CODE=? AND S.LOT_NO=? AND S.LOT_SL=?";
							//				  String sql = "SELECT S.QUANTITY, S.QTY_PER_ART FROM STOCK S ,LOCATION L " +
							//				  "WHERE L.INV_STAT=? AND L.LOC_CODE=? AND  L.SITE_CODE=? " +
							//				  "AND S.LOC_CODE=L.LOC_CODE AND S.QUANTITY>0  AND  S.ITEM_CODE=? AND S.LOT_NO=? AND S.LOT_SL=?";

							/*sql = "SELECT S.QUANTITY, S.QTY_PER_ART FROM STOCK S ,LOCATION L " +
							"WHERE L.INV_STAT IN (?,?) AND L.LOC_CODE IN (?,?) AND  L.SITE_CODE= ? " +
							"AND S.LOC_CODE=L.LOC_CODE AND S.QUANTITY>0  AND  S.ITEM_CODE = ? AND S.LOT_NO = ? AND S.LOT_SL = ?";*/


							//Change by Jagruti Shinde for Exempted /BSR Location Request Id:W15JSUN017 
							//site_code is not consider for location table
							/*sql = "SELECT S.QUANTITY, S.QTY_PER_ART FROM STOCK S ,LOCATION L " +
							"WHERE L.INV_STAT IN (?,?) AND L.LOC_CODE IN (?,?,?,?,?,?,?,?) AND  S.SITE_CODE= ? " +
							"AND S.LOC_CODE=L.LOC_CODE AND S.QUANTITY>0  AND  S.ITEM_CODE = ? AND S.LOT_NO = ? AND S.LOT_SL = ?";*/
							
							//Changed by Jagruti Shinde,for considering QC rejected locations in Pallet out.Request id:[W16ASUN022]
							/*sql = "SELECT S.QUANTITY, S.QTY_PER_ART FROM STOCK S ,LOCATION L " +
							"WHERE S.INV_STAT IN (?,?) AND S.LOC_CODE IN (?,?,?,?,?,?,?,?) AND  S.SITE_CODE= ? " +
							"AND S.LOC_CODE=L.LOC_CODE AND S.QUANTITY>0  AND  S.ITEM_CODE = ? AND S.LOT_NO = ? AND S.LOT_SL = ?";*/
							
							sql = "SELECT S.QUANTITY, S.QTY_PER_ART FROM STOCK S ,LOCATION L " +
							"WHERE S.INV_STAT IN (?,?) AND S.LOC_CODE IN (?,?,?,?,?,?,?,?,?) AND  S.SITE_CODE= ? " +
							"AND S.LOC_CODE=L.LOC_CODE AND S.QUANTITY>0  AND  S.ITEM_CODE = ? AND S.LOT_NO = ? AND S.LOT_SL = ?";

							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, "AWMS");
							pstmt.setString(2, "AWMSQ");
							pstmt.setString(3, palletNo);
							pstmt.setString(4, palletNo+"Q");
							pstmt.setString(5, palletNo+"B");
							pstmt.setString(6, palletNo+"X");
							pstmt.setString(7, palletNo+"M");
							pstmt.setString(8, palletNo+"U");
							pstmt.setString(9, palletNo+"P");
							pstmt.setString(10, palletNo+"S");
							//Changed by Jagruti Shinde ,for considering QC rejected locations in Pallet out.Request id:[W16ASUN022]
							pstmt.setString(11, palletNo+"R");
							pstmt.setString(12, loginSite);
							pstmt.setString(13, itemCode);
							pstmt.setString(14, lotNo);
							pstmt.setString(15, lotSl);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								quantity = rs.getDouble("QUANTITY");
								qtyPerArt = rs.getDouble("QTY_PER_ART");
								System.out.println( "IN  NO_ART VALIDATION");

								noArtQuot= quantity / qtyPerArt ;
								noArtRem = quantity % qtyPerArt ;
								if(noArtRem > 0)
								{
									noArtRem = 1;
								}
								noArtQuot = (int) noArtQuot;

								noArt = noArtQuot + noArtRem;

								if(noArtD > noArt)
								{
									System.out.println("noart exist");
									errCode = "VMNOARTEXT";
									errList.add( errCode );
									errFields.add( childNodeName.toLowerCase() );
									break;
								}
							}
							if (pstmt != null) 
							{ 
								pstmt.close();
								pstmt = null;
							}
							if (rs != null) 
							{ 
								rs.close(); 
								rs = null;
							}
						}
					}
					if("quantity".equalsIgnoreCase(childNodeName))
					{
						quantityStr = quantityStr.length() == 0 ? "0" : quantityStr;
						quantity = Double.parseDouble(quantityStr);
						System.out.println("quantity from dom>>>>>>>" +quantity);
						System.out.println("quantityStr from dom>>>>>>>" +quantityStr);

						if(quantity == 0 )
						{
							errCode = "VMQUANTNUL";
							errList.add( errCode );
							System.out.println("quantity errList>>>>>>>" +errList);
							childNode = childNodeList.item(ctr);
							childNodeName = childNode.getNodeName();
							errFields.add( childNodeName.toLowerCase() );
							break;
						}
						else 
						{
							//System.out.println("quantity else---");
							// sql = "SELECT S.QUANTITY FROM STOCK S ,LOCATION L WHERE L.INV_STAT=? AND L.LOC_CODE=? AND  L.SITE_CODE=? AND S.LOC_CODE=L.LOC_CODE AND S.QUANTITY>0  AND  S.ITEM_CODE=? AND S.LOT_NO=? AND  S.LOT_SL=? ";
							/*sql = "SELECT S.QUANTITY FROM STOCK S ,LOCATION L WHERE L.INV_STAT IN (?,?) " +
							"AND L.LOC_CODE IN (?,?) AND  L.SITE_CODE=? AND S.LOC_CODE=L.LOC_CODE AND S.QUANTITY>0  " +
							"AND  S.ITEM_CODE=? AND S.LOT_NO=? AND  S.LOT_SL=? ";*/

							//Change by Jagruti Shinde for Exempted /BSR Location Request Id:W15JSUN017 
							//site_code is not consider for location table
							/*sql = "SELECT S.QUANTITY FROM STOCK S ,LOCATION L WHERE L.INV_STAT IN (?,?) " +
							"AND L.LOC_CODE IN (?,?,?,?,?,?,?,?) AND  S.SITE_CODE=? AND S.LOC_CODE=L.LOC_CODE AND S.QUANTITY>0  " +
							"AND  S.ITEM_CODE=? AND S.LOT_NO=? AND  S.LOT_SL=? ";*/
							
							//Changed by Jagruti Shinde,for considering QC rejected locations in Pallet out.Request id:[W16ASUN022]
							/*sql = "SELECT S.QUANTITY FROM STOCK S ,LOCATION L WHERE S.INV_STAT IN (?,?) " +
							"AND S.LOC_CODE IN (?,?,?,?,?,?,?,?) AND  S.SITE_CODE=? AND S.LOC_CODE=L.LOC_CODE AND S.QUANTITY>0  " +
							"AND  S.ITEM_CODE=? AND S.LOT_NO=? AND  S.LOT_SL=? ";*/
							
							sql = "SELECT S.QUANTITY FROM STOCK S ,LOCATION L WHERE S.INV_STAT IN (?,?) " +
							"AND S.LOC_CODE IN (?,?,?,?,?,?,?,?,?) AND  S.SITE_CODE=? AND S.LOC_CODE=L.LOC_CODE AND S.QUANTITY>0  " +
							"AND  S.ITEM_CODE=? AND S.LOT_NO=? AND  S.LOT_SL=? ";

							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, "AWMS");
							pstmt.setString(2, "AWMSQ");
							pstmt.setString(3, palletNo);
							pstmt.setString(4, palletNo+"Q");
							pstmt.setString(5, palletNo+"B");
							pstmt.setString(6, palletNo+"X");
							pstmt.setString(7, palletNo+"M");
							pstmt.setString(8, palletNo+"U");
							pstmt.setString(9, palletNo+"P");
							pstmt.setString(10, palletNo+"S");
							//Changed by Jagruti Shinde,for considering QC rejected locations in Pallet out.Request id:[W16ASUN022]
							pstmt.setString(11, palletNo+"R");
							pstmt.setString(12, loginSite);
							pstmt.setString(13, itemCode);
							pstmt.setString(14, lotNo);
							pstmt.setString(15, lotSl);

							rs = pstmt.executeQuery();
							if(rs.next())
							{	
								quantityStock = rs.getDouble("QUANTITY");
								System.out.println("quantityStock>>>>>>>" +quantityStock);
								System.out.println( "QUANTITY VALIDATION");
								if(quantity > quantityStock)
								{
									System.out.println("quantity exist");
									errCode = "VMQUANTEXT";
									errList.add( errCode );
									errFields.add( childNodeName.toLowerCase() );
									break;
								}
							}
							if (pstmt != null) 
							{ 
								pstmt.close(); 
								pstmt = null; 
							}
							if (rs != null) 
							{ 
								rs.close(); 
								rs = null; 
							}
						}

					}//Changed for pallet request with stock details [End]Request Id:W15HSUN003
				}
				break;
			} //switch end
			System.out.println("after switch"+errList);
			int errListSize = errList.size();
			System.out.println("errListSize .........." + errListSize);
			String errFldName = null;
			if ( errList != null && errListSize > 0 )
			{
				for (cnt = 0; cnt < errListSize; cnt++ )
				{
					errCode = errList.get(cnt);
					errFldName = errFields.get(cnt);

					System.out.println("errCode .........." + errCode);
					errString = getErrorString( errFldName, errCode, userId );

					errorType =  errorType( conn, errCode );
					if ( errString.length() > 0)
					{
						String bifurErrString = errString.substring( errString.indexOf("<Errors>") + 8,errString.indexOf("<trace>"));
						bifurErrString =bifurErrString+errString.substring( errString.indexOf("</trace>") + 8,errString.indexOf("</Errors>"));
						errStringXml.append(bifurErrString);
						System.out.println("errStringXml .........."+errStringXml);
						errString = "";
					}
					if ( errorType.equalsIgnoreCase("E"))
					{
						break;
					}
				}
				errList.clear();
				errList = null;
				errFields.clear();
				errFields = null;
				errStringXml.append("</Errors></Root>\r\n");
			}
			else
			{
				errStringXml = new StringBuffer( "" );
			}	
			errString = errStringXml.toString();
		}//try end
		catch ( Exception e )
		{
			System.out.println ( "Exception: PalletReqIC: wfValData( Document currFormDataDom ): " + e.getMessage() + ":" );
			throw new ITMException(e);

		}
		finally
		{
			try
			{
				if (conn != null)
				{
					conn.close();
					conn = null;
				}
			}
			catch(Exception e)
			{
				System.out.println( "Exception : PalletReqIC:wfValData : " + e.getMessage() );
				throw new ITMException(e);
			}
		}
		System.out.println( "errString>>>>>>>::"+errString );
		return errString;
	}

	private String errorType( Connection conn , String errorCode )
	{
		String msgType = "";
		PreparedStatement pstmt = null ; 
		ResultSet rs = null;
		try
		{			
			String  sql = " SELECT MSG_TYPE FROM MESSAGES WHERE MSG_NO = ? ";

			pstmt = conn.prepareStatement( sql );			
			pstmt.setString(1, errorCode);			
			rs = pstmt.executeQuery();
			while( rs.next() )
			{
				msgType = rs.getString("MSG_TYPE");
			}			
		}
		catch (Exception ex)
		{
			ex.printStackTrace();
		}		
		finally
		{
			try
			{
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch ( Exception e )
			{
				e.printStackTrace();
			}
		}		
		return msgType;
	}

	/**
	 * The public method is defined without any parameters and returns blank string
	 */
	@Override
	public String itemChanged() throws RemoteException, ITMException
	{
		return "";
	}

	/**
	 * The public method is used for converting the current form data into a document(dom)
	 * The dom is then given as argument to the overloaded function wfValData to perform validation
	 * Returns validation string if exists else returns null in XML format
	 * @param xmlString contains the current form data in XML format
	 * @param xmlString1 contains all the header information in the XML format
	 * @param xmlString2 contains the data of all the forms in XML format
	 * @param objContext represents the form number
	 * @param editFlag represents the mode of transaction(A-Add or E-Edit)
	 * @param xtraParams contains additional information such as loginEmpCode,loginCode,chgTerm etc
	 */
	@Override
	public String itemChanged(String xmlString, String xmlString1, String xmlString2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		Document currFormDataDom = null;
		Document hdrDataDom = null;
		Document allFormDataDom = null;
		String errString = null;
		E12GenericUtility genericUtility = new E12GenericUtility();
		System.out.println("xmlString ["+xmlString+"]");
		System.out.println("xmlString1 ["+xmlString1+"]");
		System.out.println("xmlString2 ["+xmlString2+"]");
		try
		{
			if (xmlString != null && xmlString.trim().length()!=0)
			{
				currFormDataDom = genericUtility.parseString(xmlString); 
			}
			if (xmlString1 != null && xmlString1.trim().length()!=0)
			{
				hdrDataDom = genericUtility.parseString(xmlString1); 
			}
			if (xmlString2 != null && xmlString2.trim().length()!=0)
			{
				allFormDataDom = genericUtility.parseString(xmlString2); 
			}
			System.out.println ( "Calling  itemChanged( currFormDataDom, hdrDataDom, allFormDataDom, objContext, currentColumn, editFlag, xtraParams )");
			errString = itemChanged( currFormDataDom, hdrDataDom, allFormDataDom, objContext, currentColumn, editFlag, xtraParams );
			System.out.println ( "ErrString :" + errString);
		}
		catch (Exception e)
		{
			System.out.println ( "Exception :PalletReqIC :itemChanged(String,String):" + e.getMessage() + ":" );
			throw new ITMException(e);
		}
		System.out.println ( "returning from PalletReqIC itemChanged \n[" + errString + "]" );

		return errString;
	}
	/**
	 * The public overloaded method takes a document as input and is used for the validation of required fields 
	 * Returns validation string if exist otherwise returns null in XML format
	 * @param currFormDataDom contains the current form data as a document object model
	 * @param hdrDataDom contains all the header information
	 * @param allFormDataDom contains the field data of all the forms 
	 * @param objContext represents form number
	 * @param currentColumn represents the current field 
	 * @param editFlag represents the mode of transaction(A-Add or E-Edit)
	 * @param xtraParams contains additional information
	 */
	@Override
	public String itemChanged( Document currFormDataDom, Document hdrDataDom, Document allFormDataDom, String objContext, String currentColumn,String editFlag, String xtraParams ) throws RemoteException,ITMException
	{	
		Connection conn = null;

		StringBuffer valueXmlString;		
		String loginSite = "",loginEmpCode = "",chgUser = "" , chgTerm = "",siteDescr = "", siteCodeSupp = "" ,tranDate = "";
		String siteCode = "",lotNo="",lotSl="",itemCode="",palletNo="",noArtStr="",quantityStr="",sql="",locCode="",locDescr="";
		int currentFormNo = 0;
		ResultSet rs=null;
		double quantity=0,noArt=0,qtyPerArt=0,noArtQuot=0,noArtRem =0 , notArt = 0, totalQuantity = 0, noArtD=0;

		System.out.println("xtraParams=["+xtraParams+"]");
		E12GenericUtility genericUtility = new E12GenericUtility();		

		valueXmlString = new StringBuffer("<?xml version=\"1.0\"?>\r\n<Root>\r\n<Header>\r\n<editFlag>").append( editFlag );
		try
		{			
			loginSite = checkNull(genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginSiteCode" ));			
			loginEmpCode = checkNull(genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginEmpCode"));	
			chgUser = checkNull(genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode"));
			chgTerm = checkNull(genericUtility.getValueFromXTRA_PARAMS(xtraParams, "termId"));

			System.out.println("loginEmpCode---->>["+loginEmpCode+"] chgUser---->>["+chgUser+"]");	
			System.out.println("currFormDataDom---->>["+genericUtility.serializeDom(currFormDataDom)+"] ");
			System.out.println("hdrDataDom---->>["+genericUtility.serializeDom(hdrDataDom)+"] ");
			System.out.println("allFormDataDom---->>["+genericUtility.serializeDom(allFormDataDom)+"] ");
			Calendar currentDate = Calendar.getInstance();
			SimpleDateFormat simpleDateFormatObj = new SimpleDateFormat(genericUtility.getApplDateFormat());
			tranDate = simpleDateFormatObj.format(currentDate.getTime());
			//Changed and Commented By Santosh on 14-06-2016 :[START]
			//ConnDriver connDriver = new ConnDriver();
			//conn = connDriver.getConnectDB( "DriverITM" );	
			conn = getConnection();
			//connDriver = null;
			//Changed and Commented By Santosh on 14-06-2016 :[END]

			if( objContext != null && objContext.trim().length() > 0 )
			{
				currentFormNo = Integer.parseInt( objContext );
			}
			System.out.println("current form no["+currentFormNo+"]");
			valueXmlString.append("</editFlag>\r\n</Header>\r\n");
			switch ( currentFormNo )  
			{
			case 1:
			{
				valueXmlString.append( "<Detail1>\r\n" );
				if( currentColumn.trim().equalsIgnoreCase( "itm_default" ) )
				{
					System.out.println("loginSite : ["+loginSite+"]");
					siteDescr = checkNullAndTrim(getColumnDescr(conn, "descr", "site", "site_code", loginSite));
					valueXmlString.append( "<site_code><![CDATA[" ).append( loginSite ).append( "]]></site_code>\r\n" );
					valueXmlString.append( "<site_descr><![CDATA[" ).append( siteDescr ).append( "]]></site_descr>\r\n" );
				}
				else if( currentColumn.trim().equalsIgnoreCase( "site_code" ) )
				{
					siteCode = checkNullAndTrim(genericUtility.getColumnValue("site_code",currFormDataDom));
					System.out.println("siteCode : ["+siteCode+"]");
					if(siteCode.length()  > 0)
					{
						siteDescr = checkNullAndTrim(getColumnDescr(conn, "descr", "site", "site_code", siteCode));												
						valueXmlString.append( "<site_descr><![CDATA[" ).append( siteDescr ).append( "]]></site_descr>\r\n" );
					}
					else
					{												
						valueXmlString.append( "<site_descr><![CDATA[" ).append( "" ).append( "]]></site_descr>\r\n" );
					}
				}
				/*else if( currentColumn.trim().equalsIgnoreCase( "loc_code" ) )
				{
					locCode = checkNullAndTrim(genericUtility.getColumnValue("loc_code",currFormDataDom));	
					System.out.println("loc_code : ["+locCode+"]");
					if(locCode.length()  > 0)
					{
						locDescr = checkNullAndTrim(getColumnDescr(conn, "descr", "location", "loc_code", locCode));
						valueXmlString.append( "<location_descr><![CDATA[" ).append( locDescr ).append( "]]></location_descr>\r\n" );
					}
					else
					{
						valueXmlString.append( "<location_descr><![CDATA[" ).append( "" ).append( "]]></location_descr>\r\n" );	
					}
				}*/
				valueXmlString.append( "<add_user><![CDATA[" ).append( chgUser ).append( "]]></add_user>\r\n" );
				valueXmlString.append( "<tran_type><![CDATA[" ).append( "O" ).append( "]]></tran_type>\r\n" );
				valueXmlString.append( "<confirmed><![CDATA[" ).append( "N" ).append( "]]></confirmed>\r\n" );
				valueXmlString.append( "<tran_date><![CDATA[" ).append( tranDate ).append( "]]></tran_date>\r\n" );
				valueXmlString.append( "<add_date><![CDATA[" ).append( tranDate ).append( "]]></add_date>\r\n" );
				valueXmlString.append( "<add_user><![CDATA[" ).append( chgUser ).append( "]]></add_user>\r\n" );
				valueXmlString.append( "<add_term><![CDATA[" ).append( chgTerm ).append( "]]></add_term>\r\n" );

				valueXmlString.append("</Detail1>\r\n");
			} //Case 1. End
			break;
			case 2:
			{
				System.out.println("header dom2 "+genericUtility.serializeDom(hdrDataDom));
				System.out.println("header dom2 "+genericUtility.serializeDom(allFormDataDom));

				valueXmlString.append( "<Detail2>\r\n" );
				if( currentColumn.trim().equalsIgnoreCase( "itm_default" ) )
				{
					/*locCode = checkNullAndTrim(genericUtility.getColumnValue("loc_code",hdrDataDom));						
					System.out.println("location Code : ["+locCode+"]");
					valueXmlString.append( "<loc_code><![CDATA[" ).append( locCode ).append( "]]></loc_code>\r\n" );
					locDescr = null;
					locDescr = checkNullAndTrim(genericUtility.getColumnValue("location_descr",hdrDataDom));	
					valueXmlString.append( "<location_descr><![CDATA[" ).append( locDescr ).append( "]]></location_descr>\r\n" );*/
					valueXmlString.append( "<status><![CDATA[" ).append( "P" ).append( "]]></status>\r\n" );
					//valueXmlString.append( "<no_art><![CDATA[" ).append( "1" ).append( "]]></no_art>\r\n" );
				}
				/*else if( currentColumn.trim().equalsIgnoreCase( "loc_code" ) )
				{
					locCode = checkNullAndTrim(genericUtility.getColumnValue("loc_code",currFormDataDom));	
					System.out.println("loc_code : ["+locCode+"]");
					if(locCode.length()  > 0)
					{
						locDescr = checkNullAndTrim(getColumnDescr(conn, "descr", "location", "loc_code", locCode));
						valueXmlString.append( "<location_descr><![CDATA[" ).append( locDescr ).append( "]]></location_descr>\r\n" );
					}
					else
					{
						valueXmlString.append( "<location_descr><![CDATA[" ).append( "" ).append( "]]></location_descr>\r\n" );	
					}
				}*/
				else if( currentColumn.trim().equalsIgnoreCase( "lot_no" ) )
				{
					lotNo = checkNullAndTrim(genericUtility.getColumnValue("lot_no",currFormDataDom));	
					System.out.println( "lotNo item change::"+lotNo);
				}
				else if( currentColumn.trim().equalsIgnoreCase( "item_code" ) )
				{
					itemCode = checkNullAndTrim(genericUtility.getColumnValue("item_code",currFormDataDom));	
					System.out.println( "itemCode item change::"+itemCode);
				}
				else if( currentColumn.trim().equalsIgnoreCase( "pallet_no" ) )
				{
					palletNo = checkNullAndTrim(genericUtility.getColumnValue("pallet_no",currFormDataDom));	
					System.out.println( "palletNo item change::"+palletNo);
				}

				else if( currentColumn.trim().equalsIgnoreCase( "lot_sl" ) )
				{
					lotSl = checkNullAndTrim(genericUtility.getColumnValue("lot_sl",currFormDataDom));
					lotNo = checkNullAndTrim(genericUtility.getColumnValue("lot_no",currFormDataDom));
					itemCode = checkNullAndTrim(genericUtility.getColumnValue("item_code",currFormDataDom));
					palletNo = checkNullAndTrim(genericUtility.getColumnValue("pallet_no",currFormDataDom));
					loginSite = checkNull(genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginSiteCode" ));

					//	String sql = "SELECT S.QUANTITY,S.NO_ART FROM STOCK S ,LOCATION L WHERE L.INV_STAT=? AND L.LOC_CODE=? AND  L.SITE_CODE=? AND S.LOC_CODE=L.LOC_CODE AND S.QUANTITY>0  AND  S.ITEM_CODE=? AND S.LOT_NO=? AND S.LOT_SL=?";
					/*sql = "SELECT S.QUANTITY, S.QTY_PER_ART FROM STOCK S ,LOCATION L " +
					"WHERE L.INV_STAT=? AND L.LOC_CODE=? AND  L.SITE_CODE=? " +
					"AND S.LOC_CODE=L.LOC_CODE AND S.QUANTITY>0  AND  S.ITEM_CODE=? AND S.LOT_NO=? AND S.LOT_SL=?";
					 */

					//Change by Jagruti Shinde for Exempted /BSR Location Request Id:W15JSUN017 
					//site_code is not consider for location table
					/*sql = "SELECT S.QUANTITY, S.QTY_PER_ART FROM STOCK S ,LOCATION L " +
					"WHERE L.INV_STAT IN (?,?)AND L.LOC_CODE IN (?,?,?,?,?,?,?,?) AND  S.SITE_CODE=? " +
					"AND S.LOC_CODE=L.LOC_CODE AND S.QUANTITY>0  AND  S.ITEM_CODE=? AND S.LOT_NO=? AND S.LOT_SL=?";*/
					
					//Changed by Jagruti Shinde,for considering QC rejected locations in Pallet out.Request id:[W16ASUN022]
					/*sql = "SELECT S.QUANTITY, S.QTY_PER_ART FROM STOCK S ,LOCATION L " +
					"WHERE S.INV_STAT IN (?,?)AND S.LOC_CODE IN (?,?,?,?,?,?,?,?) AND  S.SITE_CODE=? " +
					"AND S.LOC_CODE=L.LOC_CODE AND S.QUANTITY>0  AND  S.ITEM_CODE=? AND S.LOT_NO=? AND S.LOT_SL=?";*/
					
					sql = "SELECT S.QUANTITY, S.QTY_PER_ART FROM STOCK S ,LOCATION L " +
					"WHERE S.INV_STAT IN (?,?)AND S.LOC_CODE IN (?,?,?,?,?,?,?,?,?) AND  S.SITE_CODE=? " +
					"AND S.LOC_CODE=L.LOC_CODE AND S.QUANTITY>0  AND  S.ITEM_CODE=? AND S.LOT_NO=? AND S.LOT_SL=?";
					
					PreparedStatement pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, "AWMS");
					pstmt.setString(2, "AWMSQ");
					pstmt.setString(3, palletNo);
					pstmt.setString(4, palletNo+"Q");
					pstmt.setString(5, palletNo+"B");
					pstmt.setString(6, palletNo+"X");
					pstmt.setString(7, palletNo+"M");
					pstmt.setString(8, palletNo+"U");
					pstmt.setString(9, palletNo+"P");
					pstmt.setString(10, palletNo+"S");
					//Changed by Jagruti Shinde ,for considering QC rejected locations in Pallet out.Request id:[W16ASUN022]
					pstmt.setString(11, palletNo+"R");
					pstmt.setString(12, loginSite);
					pstmt.setString(13, itemCode);
					pstmt.setString(14, lotNo);
					pstmt.setString(15, lotSl);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						quantity = rs.getDouble("QUANTITY");
						qtyPerArt = rs.getDouble("QTY_PER_ART");
						System.out.println( "IN  LOT SL ITEM CHANGE");

						noArtQuot= quantity / qtyPerArt ;
						noArtRem = quantity % qtyPerArt ;
						if(noArtRem > 0)
						{
							noArtRem = 1;
						}
						noArtQuot = (int) noArtQuot;

						noArt = noArtQuot + noArtRem;
						System.out.println( "noArt>>>>>>>::"+noArt);
						System.out.println( "noArtQuot>>>>>>>::"+noArtQuot);
						System.out.println( "noArtRem>>>>>>>::"+noArtRem);
						System.out.println( "qtyPerArt>>>>>>>::"+qtyPerArt);
						System.out.println( "quantity()>>>>>>>::"+quantity);

						/*System.out.println( "quantity sl::"+quantity);
						System.out.println( "noArt sl::"+noArt);
						System.out.println( "lotSl sl::"+lotSl);
						System.out.println( "itemCode sl::"+itemCode);
						System.out.println( "lotNo sl::"+lotNo);
						System.out.println( "palletNo sl::"+palletNo);*/

						valueXmlString.append( "<quantity><![CDATA[" ).append( quantity ).append( "]]></quantity>\r\n" );
						valueXmlString.append( "<no_art><![CDATA[" ).append( noArt ).append( "]]></no_art>\r\n" );
					}
					else
					{
						valueXmlString.append( "<quantity><![CDATA[" ).append( 0 ).append( "]]></quantity>\r\n" );
						valueXmlString.append( "<no_art><![CDATA[" ).append( 0 ).append( "]]></no_art>\r\n" );
					}
					rs.close();
					pstmt.close();
				}

				/*else if( currentColumn.trim().equalsIgnoreCase( "quantity" ) )
				{
					lotSl = checkNullAndTrim(genericUtility.getColumnValue("lot_sl",currFormDataDom));
					lotNo = checkNullAndTrim(genericUtility.getColumnValue("lot_no",currFormDataDom));
					itemCode = checkNullAndTrim(genericUtility.getColumnValue("item_code",currFormDataDom));
					palletNo = checkNullAndTrim(genericUtility.getColumnValue("pallet_no",currFormDataDom));
					loginSite = checkNull(genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginSiteCode" ));
					quantityStr = checkNullAndTrim(genericUtility.getColumnValue("quantity",currFormDataDom));
					quantityStr = quantityStr.length() == 0 ? "0" : quantityStr;
					quantity = Double.parseDouble(quantityStr);
					System.out.println( "noArt>>>>>>>::"+noArt);
					System.out.println( "noArtQuot>>>>>>>::"+noArtQuot);
					System.out.println( "noArtRem>>>>>>>::"+noArtRem);
					System.out.println( "qtyPerArt>>>>>>>::"+qtyPerArt);
					System.out.println( "quantity()>>>>>>>::"+quantity);

					String sql = "SELECT S.QTY_PER_ART FROM STOCK S ,LOCATION L WHERE L.INV_STAT=? AND L.LOC_CODE=? AND  L.SITE_CODE=? AND S.LOC_CODE=L.LOC_CODE AND S.QUANTITY>0  AND  S.ITEM_CODE=? AND S.LOT_NO=? AND S.LOT_SL=? ";

					PreparedStatement pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, "AWMS");
					pstmt.setString(2, palletNo);
					pstmt.setString(3, loginSite);
					pstmt.setString(4, itemCode);
					pstmt.setString(5, lotNo);
					pstmt.setString(6, lotSl);

					rs = pstmt.executeQuery();
					if(rs.next())
					{
						qtyPerArt = rs.getDouble("QTY_PER_ART");
					}
					rs.close();
					pstmt.close();

					noArtQuot= quantity / qtyPerArt ;
					noArtRem = quantity % qtyPerArt ;
					if(noArtRem > 0)
					{
						noArtRem = 1;
					}
					noArtQuot = (int) noArtQuot;

					noArt = noArtQuot + noArtRem;
					System.out.println( "noArt>>>>>>>::"+noArt);
					System.out.println( "noArtQuot>>>>>>>::"+noArtQuot);
					System.out.println( "noArtRem>>>>>>>::"+noArtRem);
					System.out.println( "qtyPerArt>>>>>>>::"+qtyPerArt);
					System.out.println( "quantity()>>>>>>>::"+quantity);



					System.out.println( "quantity q::"+quantity);
					System.out.println( "noArt q::"+noArt);
					System.out.println( "lotSl q::"+lotSl);
					System.out.println( "itemCode q::"+itemCode);
					System.out.println( "lotNo q::"+lotNo);
					System.out.println( "palletNo q::"+palletNo);




					if(quantity <= 0)
					{
						valueXmlString.append( "<quantity><![CDATA[" ).append( 0 ).append( "]]></quantity>\r\n" );
						valueXmlString.append( "<lot_sl><![CDATA[" ).append( " " ).append( "]]></lot_sl>\r\n" );
						valueXmlString.append( "<no_art><![CDATA[" ).append( 0 ).append( "]]></no_art>\r\n" );
					}
					else
					{
						valueXmlString.append( "<no_art><![CDATA[" ).append( noArt ).append( "]]></no_art>\r\n" );
					}

				}*/
				else if( currentColumn.trim().equalsIgnoreCase( "no_art" ) )
				{
					lotSl = checkNullAndTrim(genericUtility.getColumnValue("lot_sl",currFormDataDom));
					lotNo = checkNullAndTrim(genericUtility.getColumnValue("lot_no",currFormDataDom));
					itemCode = checkNullAndTrim(genericUtility.getColumnValue("item_code",currFormDataDom));
					palletNo = checkNullAndTrim(genericUtility.getColumnValue("pallet_no",currFormDataDom));
					loginSite = checkNull(genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginSiteCode" ));
					noArtStr = checkNullAndTrim(genericUtility.getColumnValue("no_art",currFormDataDom));
					String noArtTemp = noArtStr;
					noArtStr = noArtStr.length() == 0 ? "0" : noArtStr;
					noArtD = Double.parseDouble(noArtStr);
					System.out.println( "lotSl>>>>>>>::"+lotSl);
					System.out.println( "lotNo>>>>>>>::"+lotNo);
					System.out.println( "itemCode>>>>>>>::"+itemCode);

					if(itemCode.length() >0 && lotSl.length() >0  && lotNo.length() >0)
					{
						/*sql = "SELECT S.QTY_PER_ART FROM STOCK S ,LOCATION L" +
						" WHERE L.INV_STAT=? AND L.LOC_CODE=? AND  L.SITE_CODE=? AND" +
						" S.LOC_CODE=L.LOC_CODE AND S.QUANTITY>0  AND  S.ITEM_CODE=? AND " +
						"S.LOT_NO=? AND S.LOT_SL=? ";*/

						//Change by Jagruti Shinde for Exempted /BSR Location Request Id:W15JSUN017 
						//site_code is not consider for location table
						/*sql = "SELECT S.QTY_PER_ART FROM STOCK S ,LOCATION L" +
						" WHERE L.INV_STAT IN(?,?) AND L.LOC_CODE IN(?,?,?,?,?,?,?,?) AND  S.SITE_CODE=? AND" +
						" S.LOC_CODE=L.LOC_CODE AND S.QUANTITY>0  AND  S.ITEM_CODE=? AND " +
						"S.LOT_NO=? AND S.LOT_SL=? ";*/
						
						//Changed by Jagruti Shinde,for considering QC rejected locations in Pallet out.Request id:[W16ASUN022]
						/*sql = "SELECT S.QTY_PER_ART FROM STOCK S ,LOCATION L" +
						" WHERE S.INV_STAT IN(?,?) AND S.LOC_CODE IN(?,?,?,?,?,?,?,?) AND  S.SITE_CODE=? AND" +
						" S.LOC_CODE=L.LOC_CODE AND S.QUANTITY>0  AND  S.ITEM_CODE=? AND " +
						"S.LOT_NO=? AND S.LOT_SL=? ";*/
						
						sql = "SELECT S.QTY_PER_ART FROM STOCK S ,LOCATION L" +
						" WHERE S.INV_STAT IN(?,?) AND S.LOC_CODE IN(?,?,?,?,?,?,?,?,?) AND  S.SITE_CODE=? AND" +
						" S.LOC_CODE=L.LOC_CODE AND S.QUANTITY>0  AND  S.ITEM_CODE=? AND " +
						"S.LOT_NO=? AND S.LOT_SL=? ";
						
						PreparedStatement pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, "AWMS");
						pstmt.setString(2, "AWMSQ");
						pstmt.setString(3, palletNo);
						pstmt.setString(4, palletNo+"Q");
						pstmt.setString(5, palletNo+"B");
						pstmt.setString(6, palletNo+"X");
						pstmt.setString(7, palletNo+"M");
						pstmt.setString(8, palletNo+"U");
						pstmt.setString(9, palletNo+"P");
						pstmt.setString(10, palletNo+"S");
						//Changed by Jagruti Shinde ,for considering QC rejected locations in Pallet out.Request id:[W16ASUN022]
						pstmt.setString(11, palletNo+"R");
						pstmt.setString(12, loginSite);
						pstmt.setString(13, itemCode);
						pstmt.setString(14, lotNo);
						pstmt.setString(15, lotSl);

						rs = pstmt.executeQuery();
						if(rs.next())
						{
							qtyPerArt = rs.getDouble("QTY_PER_ART");
						}
						rs.close();
						pstmt.close();

						quantity  = noArtD * qtyPerArt ;

						System.out.println( "noArtD>>>>>>>::"+noArtD);
						System.out.println( "qtyPerArt>>>>>>>::"+qtyPerArt);
						System.out.println( "quantity()>>>>>>>::"+quantity);
						System.out.println( "IN  NO_ART ITEM CHANGE");

						/*System.out.println( "quantity n::"+quantity);
						System.out.println( "noArt n::"+noArtD);
						System.out.println( "lotSl n::"+lotSl);
						System.out.println( "itemCode n::"+quantity);
						System.out.println( "lotNo n::"+lotNo);
						System.out.println( "palletNo n::"+palletNo);
						 */


						if(noArtD <= 0 || noArtTemp.length() == 0)
						{
							quantity  = 1 * qtyPerArt ;
							valueXmlString.append( "<quantity><![CDATA[" ).append( quantity ).append( "]]></quantity>\r\n" );
							System.out.println( "quantity AT 1 NO ART>>>>>>>::"+quantity);
							//valueXmlString.append( "<lot_sl><![CDATA[" ).append( " " ).append( "]]></lot_sl>\r\n" );
							valueXmlString.append( "<no_art><![CDATA[" ).append( 1 ).append( "]]></no_art>\r\n" );
						}
						else
						{
							valueXmlString.append( "<quantity><![CDATA[" ).append( quantity ).append( "]]></quantity>\r\n" );
						}
					}
				}

				valueXmlString.append( "</Detail2>\r\n" );
			}
			break;
			}//switch
			valueXmlString.append( "</Root>\r\n" );	 
		}//End of try block
		catch (Exception e)
		{				
			e.printStackTrace();			
		}
		finally
		{	
			try
			{				
				if ( conn != null )
				{
					conn.close();
					conn = null;
				}
			}
			catch (Exception e)
			{
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		System.out.println( "valueXmlString.toString()>>>>>>>::"+valueXmlString.toString());
		return valueXmlString.toString();
	}
	/**
	 * The function checks whether the input string is null. 
	 * If null, the function returns blank string.  
	 * @param input
	 */
	private String checkNull( String input )	
	{
		if ( input == null )
		{
			input = "";
		}
		return input.trim();
	}
	/**
	 * The function checks whether the input string is null. 
	 * If null, the function returns blank string otherwise trim the input string and return.  
	 * @param input
	 */

	private String checkNullAndTrim( String inputVal )
	{
		if ( inputVal == null )
		{
			inputVal = "";
		}
		else
		{
			inputVal = inputVal.trim();
		}
		return inputVal;
	}
	private int getDBRowCount(Connection conn, String table_name, String whrCondCol, String whrCondVal)
	{
		int count=0;				
		ResultSet rs=null;
		PreparedStatement pstmt = null;
		String sql="";

		sql="select count(*) from "+table_name+" where "+whrCondCol+" = ?";
		System.out.println("SQL in getDBRowCount method : "+sql);
		try
		{
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,whrCondVal);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				count = rs.getInt(1);
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(rs!=null)
			{
				rs.close();
				rs = null;
			}
		}
		catch(Exception ex){
			System.out.println("Exception In getDBRowCount method of PalletReqIC Class : "+ex.getMessage());
			ex.printStackTrace();
		}
		System.out.println("Return count from getDBRowCount ----->>["+count+"]");					
		return count;
	}
	private String getColumnDescr(Connection conn, String columnName ,String tableName, String columnName2, String value) throws Exception
	{
		PreparedStatement pstmt = null ;
		ResultSet rs = null ; 
		String sql = "";
		String findValue = "";
		try
		{			
			sql = "SELECT " + columnName + " from " + tableName + " where " + columnName2 +"= ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,value);
			rs = pstmt.executeQuery();
			if(rs.next())
			{					
				findValue = rs.getString(1);
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;	        
		}
		catch(Exception e)
		{
			System.out.println("Exception in getColumnDescr ");
			e.printStackTrace();
			throw new Exception(e);
		}
		finally
		{
			if(rs!=null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
		}
		System.out.println("returning String from getColumnDescr " + findValue);
		return findValue;
	}

	public boolean isRecordPresentInMiscDrCrRcp(Connection conn,
			String invoiceID) {
		// TODO Auto-generated method stub
		return false;
	}

	private ArrayList checkDuplicaterecord(Document dom) throws ITMException
	{
		ArrayList arryList = new ArrayList();
		NodeList parentNodeList = null, childNodeList  = null;
		Node parentNode = null, childNode = null;
		int parentNodeListLength = 0;
		String childNodeName = "";
		String updateFlag = getAttribValue(parentNode,"attribute", "updateFlag"); //(parentNode, "attribute", "status"));
		try 
		{
			parentNodeList = dom.getElementsByTagName("Detail2");
			parentNodeListLength = parentNodeList.getLength();
			for (int row = 0; row < parentNodeList.getLength(); row++) 
			{
				parentNode = parentNodeList.item(row);				

				System.out.println(" sumit updateFlag ["+updateFlag+"]");
				childNodeList = parentNode.getChildNodes();
				for (int col = 0; col < childNodeList.getLength(); col++) {
					childNode = childNodeList.item(col);

					if (childNode.getNodeType() == childNode.ELEMENT_NODE) {
						childNodeName = childNode.getNodeName();
						if( !"D".equalsIgnoreCase(updateFlag))
						{
							if ("pallet_no".equalsIgnoreCase(childNodeName)) 
							{
								arryList.add(childNode.getFirstChild().getNodeValue().trim());
								System.out.println("===palletno-->[" + arryList+ "]");
							}
						}
					}
				}
				System.out.println("ELSE FOR CHECK");

			}
		} 
		catch (Exception e) 
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		return arryList;
	}	

	private String getAttribValue(Node detailNode, String nodeName, String attribStr)
	{
		String attribValue = "",domStr="";
		try
		{
			domStr = genericUtility.serializeDom(detailNode);
			Document dom = genericUtility.parseString(domStr);
			if( dom != null /*&& dom.getAttributes() != null*/)
			{
				Node attributeNode = dom.getElementsByTagName( nodeName ).item(0);
				attribValue = getAttribValue(attributeNode, attribStr);
			}
		}
		catch(Exception e)
		{
			System.out.println("Exception : getAttribValue :" + e.getMessage());
		}
		return attribValue;
	}
	private String getAttribValue(Node detailNode, String attribStr)
	{
		String attribValue = "";
		try
		{
			if( detailNode != null && detailNode.getAttributes() != null)
			{
				Node attribNode = detailNode.getAttributes().getNamedItem( attribStr );
				if( attribNode != null )
				{
					attribValue = checkNull( attribNode.getNodeValue() );
				}
			}
		}
		catch(Exception e)
		{
			System.out.println("Exception : getAttribValue :" + e.getMessage());
		}
		return attribValue;
	}
	//Changed for pallet request with stock details [Start]Request Id:W15HSUN003
	public boolean isRecordExist(Document dom) throws ITMException
	{

		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null;
		int childNodeListLength = 0;
		boolean isExist=false;
		String childNodeName = null,palletNo = "",itemCode = "",lotNo = "",lotSl ="",quantity="",PalletKey="",updateFlag="";
		ArrayList<String> palletDetailList=new ArrayList<String>();
		if(dom != null)
		{
			E12GenericUtility genericUtility = new E12GenericUtility();    
			parentNodeList = dom.getElementsByTagName("Detail2");
			childNodeListLength = parentNodeList.getLength();
			System.out.println("serializeDom----->>"+genericUtility.serializeDom(dom));
			System.out.println("childNodeListLength----->>"+childNodeListLength);
			for (int ctr = 0; ctr < childNodeListLength; ctr++)
			{				
				childNode = parentNodeList.item(ctr);			
				childNodeName = childNode.getNodeName();
				updateFlag = getAttribValue(childNode,"attribute", "updateFlag"); //(parentNode, "attribute", "status"));
				System.out.println("Child name --->> "+childNodeName);	

				if (childNode.getNodeType() == Node.ELEMENT_NODE)
				{
					Element eElement = (Element) childNode;					
					palletNo =  checkNull(eElement.getElementsByTagName("pallet_no").item(0).getTextContent());	
					itemCode =  checkNull(eElement.getElementsByTagName("item_code").item(0).getTextContent());
					lotNo =  checkNull(eElement.getElementsByTagName("lot_no").item(0).getTextContent());
					lotSl =  checkNull(eElement.getElementsByTagName("lot_sl").item(0).getTextContent());
					System.out.println("palletNo---->"+palletNo+ " PalletNo--->["+palletNo+"]");					
					if( !"D".equalsIgnoreCase(updateFlag))
					{
						System.out.println("updateFlag --->> "+updateFlag);	
						PalletKey=palletNo+":"+itemCode+":"+lotNo+":"+lotSl;
						palletDetailList.add(PalletKey);
					}
				}
			}
			System.out.println("palletDetail --->> "+palletDetailList);	

			Set<String> uniqueSet = new HashSet<String>(palletDetailList);
			for (String temp : uniqueSet)
			{
				System.out.println(temp + ": " + Collections.frequency(palletDetailList, temp));
				int i = Collections.frequency(palletDetailList, temp);
				System.out.println("frequency --->> "+i);	
				if(i > 1)
				{
					isExist = true;    
					break;
				}
			}
		}
		else
		{
			System.out.println("dom is null please check.........");
		}
		System.out.println("dom is null please check........."+isExist);
		return isExist ;
	}
	private String getObjNameFromDom( Document dom, String attribute, String objContext ) throws RemoteException,ITMException
	{
		NodeList detailList = null;
		Node currDetail = null,reqDetail = null;
		String objName = "";
		int	detailListLength = 0;

		try
		{
			detailList = dom.getElementsByTagName("Detail"+objContext);
			detailListLength = detailList.getLength();
			for (int ctr = 0; ctr < detailListLength; ctr++)
			{
				currDetail = detailList.item(ctr);
				objName = currDetail.getAttributes().getNamedItem(attribute).getNodeValue();
				if( objName != null && objName.trim().length() > 0)
				{				
					return objName;
				}
			}
		}
		catch ( Exception e )
		{
			throw new ITMException(e);
		}
		return objName;
	}
	//Changed for pallet request with stock details [End]Request Id:W15HSUN003
}


