package ibase.webitm.bean.gstclient;

//import ibase.webitm.bean.gst.GstDetailData;
//import ibase.webitm.bean.gst.GstHrdDetData;
import java.io.IOException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
//import ibase.webitm.bean.gst.GstHeaderData;

public class GstHrdDetDataSerializer extends JsonSerializer<GstHrdDetData> 
{

	@Override
	public void serialize(GstHrdDetData GstHrdDetData, JsonGenerator json, SerializerProvider serializerProvider) throws IOException,	JsonProcessingException 
	{
		json.writeStartObject();
		json.writeFieldName("hdr");
		json.writeStartArray();

		for(GstHeaderData hdr : GstHrdDetData.headerData)
		{
			writeHrd(GstHrdDetData, json, hdr);
		}

		json.writeEndArray();
		json.writeEndObject();
	}

	private void writeHrd(GstHrdDetData generichdr, JsonGenerator json, GstHeaderData hdr) 
	{
		try 
		{
			json.writeStartObject();

			json.writeStringField("tranid", hdr.tranID);
			json.writeStringField("trandate", hdr.tranDate);
			json.writeStringField("ifref",hdr.tranIdRef);
			json.writeStringField("sitecode", hdr.siteCode);
			json.writeStringField("prdcode", hdr.prdCode);
			json.writeStringField("rectype", hdr.recType);
			json.writeStringField("trantype", hdr.tranType);
			json.writeStringField("custcode", hdr.custCode);
			json.writeStringField("custname", hdr.custName);
			json.writeStringField("subtype", hdr.subType);
			json.writeStringField("docchecksum", hdr.docCheckSum);
			json.writeStringField("doctype", hdr.docType);
			json.writeStringField("docnum", hdr.docNum);
			json.writeStringField("docdate", hdr.docDate);
			json.writeNumberField("amt", hdr.amt);
			json.writeStringField("revcharge", hdr.revCharge);
			json.writeStringField("lrno", hdr.lrNo);
			json.writeStringField("lrdate", hdr.lrDate);
			json.writeStringField("reascode", hdr.reasCode);
			json.writeStringField("refidhdr", hdr.refIdInv);
			json.writeStringField("refdatehdr", hdr.refDateInv);
			json.writeStringField("provassmnt", hdr.provAssmnt);
			json.writeStringField("ordno", hdr.ordNo);
			json.writeStringField("orddate", hdr.ordDate);
			json.writeStringField("remark", hdr.remarks);
			json.writeStringField("substatus", hdr.subStatus);
			json.writeStringField("subdate", hdr.subDate);
			json.writeStringField("adduser", hdr.addUser);
			json.writeStringField("adddate", hdr.addDate);
			json.writeStringField("addterm", hdr.addTerm);
			json.writeStringField("chguser", hdr.chgUser);
			json.writeStringField("chgdate", hdr.chgDate);
			json.writeStringField("chgterm", hdr.chgTerm);
			json.writeStringField("taxregno", hdr.taxRegNo);
			json.writeStringField("recostatus", hdr.recoStatus);
			json.writeStringField("ecomregno", hdr.ecomRegNo);
			json.writeStringField("refser", hdr.refSer);
			json.writeStringField("gstcode", hdr.gstCode);
			json.writeStringField("gsttype", hdr.gstType);
			json.writeStringField("refid", hdr.refId);

			writeDetail(generichdr, json, hdr);

			json.writeEndObject();
		} 
		catch (Exception e) 
		{
			System.out.println("BaseSerializer.writeHrd()["+e.getMessage()+"]");
			e.printStackTrace();
		}
	}


	private void writeDetail(GstHrdDetData generichdr, JsonGenerator json, GstHeaderData hdr) throws IOException 
	{
		json.writeFieldName("detaildata");
		json.writeStartArray();

		for(GstDetailData li : hdr.detaildata)
		{
			writeDetailItem(generichdr, json, li);
		}

		json.writeEndArray();
	}

	private void writeDetailItem(GstHrdDetData generichdr, JsonGenerator json, GstDetailData li) 
	{
		try 
		{
			json.writeStartObject();

			json.writeStringField("tranId", li.tranID);
			json.writeNumberField("lineno", li.lineNo);
			json.writeStringField("status", li.status);
			json.writeNumberField("srnoOld", li.srNoOld);
			json.writeStringField("lineType", li.lineType);
			json.writeStringField("gscode", li.gsCode);
			json.writeNumberField("taxableamt", li.taxableAmt);
			json.writeNumberField("igstperc", li.igstPerc);
			json.writeNumberField("igstamt", li.igstAmt);
			json.writeNumberField("cgstperc", li.cgstPerc);
			json.writeNumberField("cgstamt", li.cgstAmt);
			json.writeNumberField("sgstperc", li.sgstPerc);
			json.writeNumberField("sgstamt", li.sgstAmt);
			json.writeStringField("gsdescr", li.gsDescr);
			json.writeStringField("unit", li.unit);
			json.writeNumberField("quantity", li.quantity);
			json.writeStringField("supptype", li.suppType);
			json.writeNumberField("cessperc", li.cessPerc);
			json.writeNumberField("cessamt", li.cessAmt);
			json.writeStringField("remarks", li.remarks);
			json.writeStringField("itctype", li.itcType);
			json.writeNumberField("itcigst", li.itcIgst);
			json.writeNumberField("itccgst", li.itcCgst);
			json.writeNumberField("itcsgst", li.itcSgst);
			json.writeNumberField("itccess", li.itcCess);
			json.writeNumberField("gstrate", li.gstRate);

			json.writeEndObject();
		}
		catch (Exception e) 
		{
			System.out.println("BaseSerializer.writeDetailItem()["+e.getMessage()+"]");
			e.printStackTrace();
		}
	}

}
