package ibase.dashboard.sfa.ejb;
import java.io.File;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import javax.ejb.Stateless;
import org.json.simple.JSONObject;
import ibase.system.config.ConnDriver;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.ITMException;
/**
 * Session Bean implementation class ImpEvents
 */
@Stateless
public class ImpEvents  extends ValidatorEJB implements ImpEventsRemote, ImpEventsLocal {
	
    /**
     * Default constructor. 
     */
    public ImpEvents() {
        // TODO Auto-generated constructor stub
    }


	
    @SuppressWarnings("unchecked")
	@Override
	public JSONObject getEvents(String empCode, String dataSourceName) throws RemoteException, ITMException {
		
    	
    	
    	JSONObject rawDataTomorrowEventsJson = new JSONObject();
    	JSONObject rowData = null;
    	String sql         = "";
    	ResultSet rs       = null;
    	PreparedStatement pstmt = null;
    	Connection conn = null;
    	ConnDriver connDriver = new ConnDriver();
    	String tran_image = "" , doctorName = "" , scCode = "";
    	StringBuffer createHtmlData =null;
    	
    	try
    	{
    		
    	System.out.println(" Inside ImpEvents for getTomorrowEvents Data Source Name ="+dataSourceName+" Employee Code="+ empCode);
    	conn           = connDriver.getConnectDB(dataSourceName);
    	connDriver     = null;	
    	createHtmlData = new StringBuffer();     	
    	if (empCode!=null && empCode.length()>0)
        {
    		
        	sql = "select  to_char(STRG_EVENTS.EVENT_DATE,'dd-MON-yy') as Event_Date, STRG_CUSTOMER.SC_CODE, INITCAP(strg_customer.first_name||' '||strg_customer.middle_name||' '||strg_customer.last_name )AS DrName, LISTAGG(STRG_EVENTS.DESCR, ', ') WITHIN GROUP (ORDER BY STRG_EVENTS.DESCR) as Event FROM SALES_PERS INNER JOIN STRG_SERIES on STRG_SERIES.SALES_PERS = SALES_PERS.SALES_PERS and STRG_SERIES.Cust_Type = 'D' and STRG_SERIES.Status = 'Y' INNER JOIN STRG_CUSTOMER ON STRG_CUSTOMER.SC_CODE = STRG_SERIES.SC_CODE INNER JOIN STRG_EVENTS ON STRG_CUSTOMER.SC_CODE = STRG_EVENTS.SC_CODE "
        			+ "WHERE SALES_PERS.SALES_PERS = ?"
        			+ " AND STRG_EVENTS.EVENT_DATE  <= TO_DATE(sysdate,'dd/mm/yy HH24:MI:SS') group by STRG_EVENTS.EVENT_DATE , STRG_CUSTOMER.SC_CODE, strg_customer.first_name, strg_customer.middle_name, strg_customer.last_name";
        
        	
    	pstmt = conn.prepareStatement(sql);
    	pstmt.setString(1, empCode);
    	rs = pstmt.executeQuery();
    	
    	int count = 0;	
      	createHtmlData.append("<table  cellspacing='1' style='color:#000; width:100%; margin:auto; ' align='center' width='100%'>"
    			+ "<tr><td class='defaultTitle'>Today</td>"
    			+ "</tr>");
    	rowData = new JSONObject();
    	File file =null;
    	while (rs.next())
    	{
    		doctorName = checkNull(rs.getString("DrName"));
    		scCode = checkNull(rs.getString("SC_CODE"));
    		String object = "images"+ File.separator + "users";
         	String userImagePath = "/ibase/CustomMenuImageServlet?fldValue="+scCode+"&object="+object+"&objName="+object+"&ALT_FLD_VALUE="+doctorName;
        	tran_image          = "<img class='cardProdImg2' src='"+userImagePath+"'/>";
			createHtmlData.append(""
				+ "<tr class='row'> <td><table style='border-bottom:1px solid #E8E8E8;' width='100%' >"
				+ "<td width = '2%'>"+tran_image+"</td><td align = 'left'>"
				+ "<table cellspacing='0' cellpadding='0'  ><tr><td class='defaultIconTitle'> "+doctorName+"</td></tr>"
				+ "<tr><td class='defaultIconSubTitle' >"+checkNull(rs.getString("Event"))+" "+checkNull(rs.getString("EVENT_DATE"))+"</td></tr></table>"
				+ "</td></table></td></tr>");
    	
    	}
    	rs.close();
    	rs=null;
    	pstmt.close();
    	pstmt=null;
    	//End of todays event
    	
    	createHtmlData.append(
    			  "<tr><td class='defaultTitle' >Tommorow</td>"
    			+ "</tr>");
    	//Start of Tommorow events
    	sql="select to_char(STRG_EVENTS.EVENT_DATE,'dd-MON-yy') as Event_Date, STRG_CUSTOMER.SC_CODE, INITCAP(strg_customer.first_name||' '||strg_customer.middle_name||' '||strg_customer.last_name )AS DrName, LISTAGG(STRG_EVENTS.DESCR, ', ') WITHIN GROUP (ORDER BY STRG_EVENTS.DESCR) as Event FROM SALES_PERS INNER JOIN STRG_SERIES on STRG_SERIES.SALES_PERS = SALES_PERS.SALES_PERS and STRG_SERIES.Cust_Type = 'D' and STRG_SERIES.Status = 'Y' INNER JOIN STRG_CUSTOMER ON STRG_CUSTOMER.SC_CODE = STRG_SERIES.SC_CODE INNER JOIN STRG_EVENTS ON STRG_CUSTOMER.SC_CODE = STRG_EVENTS.SC_CODE "
    			+ "WHERE SALES_PERS.SALES_PERS = ?  "
    			+ "AND STRG_EVENTS.EVENT_DATE  <= TO_DATE(sysdate,'dd/mm/yy HH24:MI:SS') + 1 group by STRG_EVENTS.EVENT_DATE , STRG_CUSTOMER.SC_CODE, strg_customer.first_name, strg_customer.middle_name, strg_customer.last_name";
    	
    	pstmt = conn.prepareStatement(sql);
    	pstmt.setString(1, empCode);
    	rs = pstmt.executeQuery();
    	
    	while(rs.next()) 
    	{

    	doctorName = checkNull(rs.getString("DrName"));
    	scCode = checkNull(rs.getString("SC_CODE"));
    	String object = "images"+ File.separator + "users";
     	String userImagePath = "/ibase/CustomMenuImageServlet?fldValue="+scCode+"&object="+object+"&objName="+object+"&ALT_FLD_VALUE="+doctorName;
        tran_image = "<img class='cardProdImg2' src='"+userImagePath+"'/>";
		createHtmlData.append(""
				+ "<tr class='row'> <td><table style='border-bottom:1px solid #E8E8E8;' width='100%' >"
				+ "<td width = '2%'>"+tran_image+"</td><td align = 'left'>"
				+ "<table cellspacing='0' cellpadding='0 width='70%'><tr><td class='defaultIconTitle' >"+doctorName+"</td></tr>"
				+ "<tr><td class='defaultIconSubTitle'  >"+checkNull(rs.getString("Event"))+" "+checkNull(rs.getString("EVENT_DATE"))+"</td></tr></table>"
				+ "</td></table></td></tr>");
		
		
		
    	}
    	rs.close();
    	rs=null;
    	pstmt.close();
    	pstmt=null;
    	//End of Tommorows events    	
    	
    	createHtmlData.append(
  			  "<tr><td  class='defaultTitle' >Upcoming Events</td>"
  			+ "</tr>");
    	//Start of Upcoming events   
    	sql="select  to_char (STRG_EVENTS.EVENT_DATE,'dd-MON-yy') as Event_Date, STRG_CUSTOMER.SC_CODE, INITCAP(strg_customer.first_name||' '||strg_customer.middle_name||' '||strg_customer.last_name )AS DrName, LISTAGG(STRG_EVENTS.DESCR, ', ') WITHIN GROUP (ORDER BY STRG_EVENTS.DESCR) as Event FROM SALES_PERS INNER JOIN STRG_SERIES on STRG_SERIES.SALES_PERS = SALES_PERS.SALES_PERS and STRG_SERIES.Cust_Type = 'D' and STRG_SERIES.Status = 'Y' INNER JOIN STRG_CUSTOMER ON STRG_CUSTOMER.SC_CODE = STRG_SERIES.SC_CODE INNER JOIN STRG_EVENTS ON STRG_CUSTOMER.SC_CODE = STRG_EVENTS.SC_CODE "
    			+ " WHERE SALES_PERS.SALES_PERS = ? "
    			+ " AND STRG_EVENTS.EVENT_DATE >= TO_DATE(sysdate,'dd/mm/yy HH24:MI:SS')+2 AND STRG_EVENTS.EVENT_DATE <= TO_DATE(sysdate,'dd/mm/yy HH24:MI:SS')+8 group by STRG_EVENTS.EVENT_DATE, STRG_CUSTOMER.SC_CODE, strg_customer.first_name, strg_customer.middle_name, strg_customer.last_name";
    	pstmt = conn.prepareStatement(sql);
    	pstmt.setString(1, empCode);
    	rs = pstmt.executeQuery();
    	
    	while(rs.next())
    	{

    		doctorName    = checkNull(rs.getString("DrName"));
    		scCode        = checkNull(rs.getString("SC_CODE"));
    		String object = "images"+ File.separator + "users";
         	String userImagePath = "/ibase/CustomMenuImageServlet?fldValue="+scCode+"&object="+object+"&objName="+object+"&ALT_FLD_VALUE="+doctorName;
       		tran_image = "<img class='cardProdImg2' src='"+userImagePath+"'/>";
			createHtmlData.append(""
				+ "<tr class='row'> <td><table style='border-bottom:1px solid #E8E8E8;' width='100%' >"
				+ "<td width = '2%'>"+tran_image+"</td><td align = 'left'>"
				+ "<table cellspacing='0' cellpadding='0 width='70%'><tr class='defaultIconTitle' ><td>"+doctorName+"</td></tr>"
				+ "<tr><td class='defaultIconSubTitle'>"+checkNull(rs.getString("Event"))+" "+checkNull(rs.getString("EVENT_DATE"))+"</td></tr></table>"
				+ "</td></table></td></tr>");
    		
    	}
    	rs.close();
    	rs=null;
    	pstmt.close();
    	pstmt=null;
        	
    	createHtmlData.append("</table>");
    	rowData.put("todayEvent", createHtmlData.toString());
    	rawDataTomorrowEventsJson.put(count, rowData);
    	count++;
    	  }
    	}
    	catch (Exception e)
    	{
    	e.printStackTrace();
    	throw new ITMException(e);
    	}
    	finally
    	{
		    	try
		    	{
		    	if (conn != null)
		    	{
		    	if (rs != null)
		    	rs.close();
		    	rs = null;
		    	if (pstmt != null)
		    	pstmt.close();
		    	pstmt = null;
		    	conn.close();
		    	conn = null;
		    	}
		    	conn = null;
		    	} catch (Exception d)
		    	{
		    	d.printStackTrace();
		    	System.out.println("Exception in :ImpEvents:" + d.getMessage());
		    	throw new ITMException(d);
		    	}
    	}
    	System.out.println("ImpEvents JSON String======>>"+rawDataTomorrowEventsJson.toString());
    	return rawDataTomorrowEventsJson;

    	}

	private String checkNull(String input)
	{
		if (input == null)
		{
			input = "";
		} else
		{
			input = input.trim();
		}
		return input;
	}

}
