package ibase.webitm.ejb.adm;

import ibase.system.config.ConnDriver;
import ibase.utility.E12GenericUtility;	//Modified By Hemlata on[20/11/2014] [As per changes in framework to use genericUtility ]
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.ITMException;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.SimpleDateFormat;
import java.util.ArrayList;  
import java.util.Calendar;
import java.util.Date;

import javax.ejb.Stateless;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Stateless
public class EmpWorkInfo extends ValidatorEJB implements EmpWorkInfoLocal ,EmpWorkInfoRemote
{

	public String itemChanged(String xmlString, String xmlString1,String xmlString2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		
		String errString = null;
		
		//Modified By Hemlata on[20/11/2014] [As per changes in framework to use genericUtility ][Start]
		//GenericUtility genericUtility = GenericUtility.getInstance();
		 E12GenericUtility genericUtility = new E12GenericUtility();
		//Modified By Hemlata on[20/11/2014] [As per changes in framework to use genericUtility ][End]
		 
		try
		{
			System.out.println("EmpWorkInfo xmlString in itemChanged..::["+xmlString+"]");
			System.out.println("EmpWorkInfo xmlString1 in itemChanged..:: ["+xmlString1+"]");
			System.out.println("EmpWorkInfo xmlString2 in itemChanged..:: ["+xmlString2+"]");
			
			if(xmlString != null && xmlString.length() > 0)
			{
				dom = genericUtility.parseString(xmlString);				
			}
			if(xmlString1 != null  &&  xmlString1.length() > 0)
			{
				dom1 = genericUtility.parseString(xmlString1);
			}
			if(xmlString2 != null && xmlString2.length() > 0)
			{
				dom2 = genericUtility.parseString(xmlString2);
			}
			errString = itemChanged( dom, dom1, dom2, objContext, currentColumn,  editFlag,  xtraParams);
			System.out.println("EmpWorkInfo errString Returing at Stage 1["+errString+"]");
		}
		catch(Exception e)
		{
			e.printStackTrace();
			System.out.println("Exception :EmpWorkInfo [:" + e.getMessage() + ":]" );
			errString = genericUtility.createErrorString(e);
		}
		System.out.println("EmpWorkInfo errString returing at Stage 2[" + errString+"]");
		return errString;
	}
		
	//Start of itemChanged block
	public String itemChanged(Document dom, Document dom1,Document dom2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		String sql = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		
		String objNameDefault = "";
		//Variable defined . Start
		String empCode = "";
		String empSite = "";
		String paySite = "";
		String workSite = "";
		String occupationCode = "";
		String occupationCodeDescr = "";
		String workLocCode = "";
		String workLocCodeDescr = "";
		String trainingPrd = "";
		String probationFlag = "";
		String confirmedFlag = "";
		String probationPrd = "";
		String dateJoin = "";
		String probationDate = "";
		String confirmatinDate = "";
		String noticePrd = "";
		String noticePeriod = "";
		String grade = "";
	    String shiftRot = "";
	    String confirmed = "";
	    String probation = "";
	    java.util.Date joinDate = null;
	    String joinDateApp = "";
	    int count = 0;
		//Variable defined  . End

		int currentFormNo = 0;
		
		//Modified By Hemlata on[20/11/2014] [As per changes in framework to use genericUtility ][Start]
		//GenericUtility genericUtility = GenericUtility.getInstance();
		 E12GenericUtility genericUtility = new E12GenericUtility();
		//Modified By Hemlata on[20/11/2014] [As per changes in framework to use genericUtility ][End]
		
		//To get login Employee Code And Login Site
		String loginEmpCode = checkNull(genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginEmpCode"));
		String loginSite = checkNull(genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginSiteCode"));

		StringBuffer valueXmlString = new StringBuffer();
		
		System.out.println("Login Employee got..:: ["+loginEmpCode+"]");
		System.out.println("objContext ..:: ["+objContext+"]");
		System.out.println("currentColumn ..:: ["+currentColumn+"]");
		System.out.println("editFlag ..:: ["+editFlag+"]");
		System.out.println("xtraParams ..:: ["+xtraParams+"]");
		

		if(objContext != null && objContext.trim().length() > 0)
		{
			currentFormNo = Integer.parseInt(objContext);
		}		

		try
		{		
			conn = connDriver.getConnectDB("Driver");
			conn.setAutoCommit(false);

			valueXmlString = new StringBuffer("<?xml version=\"1.0\"?><Root><header><editFlag>");
			valueXmlString.append(editFlag).append("</editFlag></header>");

			objNameDefault  = checkNull(getObjName(dom ,"1"));
			System.out.println("objNameDefault ..:: ["+objNameDefault+"]");
			SimpleDateFormat sdf = new SimpleDateFormat(getApplDateFormat());
			
			switch (currentFormNo)
			{
				case 1:
						{
							valueXmlString.append("<Detail1 domID='1' dbID='' objContext='1' objName='"+objNameDefault+"' selected='Y'>\r\n");
							empCode = genericUtility.getColumnValue("emp_code",dom2);
							
							if(currentColumn.equalsIgnoreCase("itm_defaultedit"))
							{
								sql = " SELECT NOTICE_PRD, GRADE, EMP_SITE, PAY_SITE, WORK_SITE,  TRAINING_PRD, PROBATION_PRD, SHIFT_ROT, CONFIRMED , PROBATION , DATE_JOIN  FROM EMPLOYEE WHERE EMP_CODE =  ? ";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1,empCode);
								rs = pstmt.executeQuery();
								if(rs.next())
								{
									noticePrd = checkNull(rs.getString("NOTICE_PRD"));
									grade = checkNull(rs.getString("GRADE"));
									empSite = checkNull(rs.getString("EMP_SITE"));
									paySite = checkNull(rs.getString("PAY_SITE"));
									workSite = checkNull(rs.getString("WORK_SITE"));
									trainingPrd  = checkNull(rs.getString("TRAINING_PRD"));
									probationPrd = checkNull(rs.getString("PROBATION_PRD"));
									shiftRot = checkNull(rs.getString("SHIFT_ROT"));
									confirmed  = checkNull(rs.getString("CONFIRMED"));
									probation  = checkNull(rs.getString("PROBATION"));
									joinDate = rs.getDate("DATE_JOIN") ;
								}
								if( rs != null )
								{
									rs.close();
									rs = null;
								}
								if( pstmt != null )
								{
									pstmt.close();
									pstmt = null;
								}
								System.out.println("noticePrd ..:: ["+noticePrd+"]");
								System.out.println("grade ..:: ["+grade+"]");
								System.out.println("empSite ..:: ["+empSite+"]");
								System.out.println("paySite ..:: ["+paySite+"]");
								System.out.println("workSite ..:: ["+workSite+"]");
								System.out.println("trainingPrd ..:: ["+trainingPrd+"]");
								System.out.println("probationPrd ..:: ["+probationPrd+"]");
								System.out.println("shiftRot ..:: ["+shiftRot+"]");
								System.out.println("confirmed ..:: ["+confirmed+"]");
								System.out.println("probation ..:: ["+probation+"]");
								System.out.println("joinDate ..:: ["+joinDate+"]");
								
								if(noticePrd == null || noticePrd.length() == 0)
								{
									sql = " SELECT NOTICE_PRD FROM GRADE WHERE GRADE_CODE = ? ";
									pstmt = conn.prepareStatement(sql);
									pstmt.setString(1,grade);
									rs = pstmt.executeQuery();
									if(rs.next())
									{
										noticePeriod = checkNull(rs.getString("NOTICE_PRD"));
									}
									if( rs != null )
									{
										rs.close();
										rs = null;
									}
									if( pstmt != null )
									{
										pstmt.close();
										pstmt = null;
									}	
									System.out.println("noticePeriod ..:: ["+noticePeriod+"]");
									valueXmlString.append("<notice_prd><![CDATA[").append(noticePeriod).append("]]></notice_prd>\r\n");
								}
								else
								{
									valueXmlString.append("<notice_prd><![CDATA[").append(noticePrd).append("]]></notice_prd>\r\n");
								}
								
								// EmpSite, PaySite, WorkSite
								if(loginSite != null && loginSite.length() > 0)
								{
									if( empSite == null || empSite.length() == 0 )
									{
										valueXmlString.append("<emp_site  protect=\"1\"><![CDATA[").append(loginSite).append("]]></emp_site>\r\n");
									}
									else
									{
										valueXmlString.append("<emp_site protect=\"1\"><![CDATA[").append(empSite).append("]]></emp_site>\r\n");
									}
									
									if( paySite == null || paySite.length() == 0 )
									{
										valueXmlString.append("<pay_site><![CDATA[").append(loginSite).append("]]></pay_site>\r\n");
									}
									
									if( workSite == null || workSite.length() == 0 )
									{
										valueXmlString.append("<work_site><![CDATA[").append(loginSite).append("]]></work_site>\r\n");
									}
									
								}
								
								//Trainning Period
								if((trainingPrd == null || trainingPrd.length() == 0 ))
								{
									valueXmlString.append("<training_prd><![CDATA[").append("0").append("]]></training_prd>\r\n");
								}
								
								//Probation Period
								if((probationPrd == null || probationPrd.length() == 0 ))
								{
									valueXmlString.append("<probation_prd><![CDATA[").append("0").append("]]></probation_prd>\r\n");
								}
								
								//Shift Rot
								if((shiftRot == null || shiftRot.length() == 0 ))
								{
									valueXmlString.append("<shift_rot><![CDATA[").append("N").append("]]></shift_rot>\r\n");
								}
								
								//Join Date
								if(joinDate != null )
								{
									 joinDateApp = sdf.format(joinDate);
								}
								if(joinDate == null)
								{
									valueXmlString.append("<date_join  protect=\"0\"><![CDATA[").append("").append("]]></date_join>\r\n");
									
								}
								else
								{
									count = 0;
									sql = " SELECT COUNT(*) AS COUNT FROM PAYROLL WHERE PRD_CODE BETWEEN '00' AND 'ZZ' AND EMP_CODE = ? ";
									pstmt = conn.prepareStatement(sql);
									pstmt.setString(1,empCode);
									rs = pstmt.executeQuery();
									if(rs.next())
									{
										count = rs.getInt("COUNT");
									}
									if( rs != null )
									{
										rs.close();
										rs = null;
									}
									if( pstmt != null )
									{
										pstmt.close();
										pstmt = null;
									}	
									System.out.println("Value of count ..:: ["+count+"]");
									if(count == 0)
									{
										valueXmlString.append("<date_join  protect=\"0\"><![CDATA[").append(joinDateApp).append("]]></date_join>\r\n");
									}
									else
									{
										valueXmlString.append("<date_join  protect=\"1\"><![CDATA[").append(joinDateApp).append("]]></date_join>\r\n");
									}
								}
								
								// Protect or Unprotect Trainning, Period Probation Period and Join Date
								count = 0;
								sql = " SELECT COUNT(*) AS COUNT FROM EMP_STATUSCHG WHERE EMP_CODE = ? AND STATUS_TYPE = ? AND CASE WHEN CONFIRM IS NULL THEN 'N' ELSE CONFIRM END <> 'X' ";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1,empCode);
								pstmt.setString(2,"P");
								rs = pstmt.executeQuery();
								if(rs.next())
								{
									count = rs.getInt("COUNT");
								}
								if( rs != null )
								{
									rs.close();
									rs = null;
								}
								if( pstmt != null )
								{
									pstmt.close();
									pstmt = null;
								}	
								System.out.println("count ..:: ["+count+"]");
								if(count > 0 )
								{
									valueXmlString.append("<training_prd protect=\"1\"><![CDATA[").append(trainingPrd).append("]]></training_prd>\r\n");
									valueXmlString.append("<date_join  protect=\"1\"><![CDATA[").append(joinDateApp).append("]]></date_join>\r\n");
								}
								else
								{
									if(confirmed.equalsIgnoreCase("Y") || (probation.equalsIgnoreCase("Y") && Integer.parseInt(trainingPrd) > 0))
									{
										valueXmlString.append("<training_prd  protect=\"1\"><![CDATA[").append(trainingPrd).append("]]></training_prd>\r\n");
									}
									else
									{
											valueXmlString.append("<training_prd  protect=\"0\"><![CDATA[").append(trainingPrd).append("]]></training_prd>\r\n");
									}
								}
								
								count = 0;
								sql = "";
								sql = "SELECT COUNT(*)AS COUNT FROM EMP_STATUSCHG WHERE EMP_CODE = ? AND STATUS_TYPE = ? AND CASE WHEN CONFIRM IS NULL THEN 'N' ELSE CONFIRM END <> 'X' ";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1,empCode);
								pstmt.setString(2,"C");
								rs = pstmt.executeQuery();
								if(rs.next())
								{
									count = rs.getInt("COUNT");
								}
								if( rs != null )
								{
									rs.close();
									rs = null;
								}
								if( pstmt != null )
								{
									pstmt.close();
									pstmt = null;
								}	
								System.out.println("count ..:: ["+count+"]");
								if(count > 0)
								{
									valueXmlString.append("<training_prd  protect=\"1\"><![CDATA[").append(trainingPrd).append("]]></training_prd>\r\n");
									valueXmlString.append("<date_join  protect=\"1\"><![CDATA[").append(joinDateApp).append("]]></date_join>\r\n");
									valueXmlString.append("<probation_prd protect=\"1\"><![CDATA[").append(probationPrd).append("]]></probation_prd>\r\n");
								}
								else
								{
									if (confirmed.equalsIgnoreCase("Y") && Integer.parseInt(probationPrd) > 0 )
									{
										valueXmlString.append("<probation_prd protect=\"1\"><![CDATA[").append(probationPrd).append("]]></probation_prd>\r\n");
									}
									else
									{
											valueXmlString.append("<probation_prd protect=\"0\"><![CDATA[").append(probationPrd).append("]]></probation_prd>\r\n");
									}
								}
							}
							else if (currentColumn.equalsIgnoreCase("emp_site"))
							{
								empSite = checkNull(getColumnValue("emp_site",dom,"1")) ;
								paySite = checkNull(getColumnValue("pay_site",dom,"1")) ;
								workSite = checkNull(getColumnValue("work_site",dom,"1")) ;
								if(paySite == null || paySite.length() == 0)
								{
									valueXmlString.append("<pay_site><![CDATA[").append(empSite).append("]]></pay_site>\r\n");
								}
								if(workSite == null || workSite.trim().length() == 0)
								{
									valueXmlString.append("<work_site><![CDATA[").append(empSite).append("]]></work_site>\r\n");
								}
							}
							else if (currentColumn.equalsIgnoreCase("occupation_code"))
							{
								occupationCode = checkNull(getColumnValue("occupation_code",dom,"1")) ;
								sql = "SELECT DESCR FROM GENCODES WHERE FLD_NAME = 'OCCUPATION_CODE' AND FLD_VALUE = ? ";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1,occupationCode);
								rs = pstmt.executeQuery();
								if(rs.next())
								{
									occupationCodeDescr = checkNull(rs.getString("DESCR"));
								}
								if( rs != null )
								{
									rs.close();
									rs = null;
								}
								if( pstmt != null )
								{
									pstmt.close();
									pstmt = null;
								}
									System.out.println("occupationCodeDescr ..:: ["+occupationCodeDescr+"]");
									valueXmlString.append("<occupation_descr><![CDATA[").append(occupationCodeDescr).append("]]></occupation_descr>\r\n");
							}
							else if (currentColumn.equalsIgnoreCase("work_loc_code"))
							{
								workLocCode = checkNull(getColumnValue("work_loc_code",dom,"1")) ;
								if(workLocCode != null && workLocCode.length() > 0)
								{
									sql = "SELECT DESCR FROM WORK_LOCATIONS WHERE WORK_LOC_CODE = ?  ";
									pstmt = conn.prepareStatement(sql);
									pstmt.setString(1,workLocCode);
									rs = pstmt.executeQuery();
									if(rs.next())
									{
										workLocCodeDescr = checkNull(rs.getString("DESCR"));
									}
									if( rs != null )
									{
										rs.close();
										rs = null;
									}
									if( pstmt != null )
									{
										pstmt.close();
										pstmt = null;
									}
									System.out.println("workLocCodeDescr ..:: ["+workLocCodeDescr+"]");
									valueXmlString.append("<work_loc_descr><![CDATA[").append(workLocCodeDescr).append("]]></work_loc_descr>\r\n");
								}								
							}
							else if (currentColumn.equalsIgnoreCase("training_prd"))
							{
								trainingPrd = checkNull(getColumnValue("training_prd",dom,"1")) ;
								probationPrd = checkNull(getColumnValue("probation_prd",dom,"1")) ;
								probationFlag = checkNull(getColumnValue("probation",dom,"1")) ;
								confirmedFlag = checkNull(getColumnValue("confirmed",dom,"1")) ;
								empCode = checkNull(getColumnValue("emp_code",dom,"1")) ;
								dateJoin = checkNull(getColumnValue("date_join",dom,"1")) ;
								
								//SimpleDateFormat sdf = new SimpleDateFormat(getApplDateFormat());
								//java.util.Date joinDateStr = sdf.parse(dateJoin);
								//String joinDate = sdf.format(joinDateStr);
								System.out.println("joinDate :::"+dateJoin);
								if (dateJoin != null && dateJoin.length() > 0)
								{
									if(trainingPrd.equalsIgnoreCase("0"))
									{
										probationDate = dateJoin ;
									}
									else 
									{
										probationDate = addMonth(dateJoin , trainingPrd);
									}
									System.out.println("probationDate ..:: ["+probationDate+"]");
									valueXmlString.append("<probation_date><![CDATA[").append(probationDate).append("]]></probation_date>\r\n");
									
									if(probationPrd != null && probationPrd.length() > 0)
									{
										confirmatinDate = addMonth(probationDate , probationPrd);
									}
									System.out.println("confirmatinDate ..:: ["+confirmatinDate+"]");
									valueXmlString.append("<date_conf><![CDATA[").append(confirmatinDate).append("]]></date_conf>\r\n");
								}
								
								if(trainingPrd.equalsIgnoreCase("0"))
								{
									probationFlag = "Y";
								}
								else
								{
									probationFlag = "N";
								}
								System.out.println("probationFlag ..:: ["+probationFlag+"]");
								valueXmlString.append("<probation><![CDATA[").append(probationFlag).append("]]></probation>\r\n");
								
								if(probationPrd.equalsIgnoreCase("0") && (trainingPrd.equalsIgnoreCase("0") ||  probationFlag.equalsIgnoreCase("Y"))) 
								{
									confirmedFlag = "Y";
								}
								else
								{
									confirmedFlag = "N";
								}
								System.out.println("confirmedFlag ..:: ["+confirmedFlag+"]");
								valueXmlString.append("<confirmed><![CDATA[").append(confirmedFlag).append("]]></confirmed>\r\n");
							}
							else if (currentColumn.equalsIgnoreCase("probation_prd"))
							{
								trainingPrd = checkNull(getColumnValue("training_prd",dom,"1")) ;
								probationPrd = checkNull(getColumnValue("probation_prd",dom,"1")) ;
								probationFlag = checkNull(getColumnValue("probation",dom,"1")) ;
								confirmedFlag = checkNull(getColumnValue("confirmed",dom,"1")) ;
								empCode = checkNull(getColumnValue("emp_code",dom,"1")) ;
								probationDate = checkNull(getColumnValue("probation_date",dom,"1")) ;
								
								System.out.println("probationDate :::"+probationDate);
								if(probationDate != null && probationDate.trim().length() > 0)
								{
									if(probationPrd.equalsIgnoreCase("0"))
									{
										confirmatinDate = probationDate ;
									}
									else
									{
										confirmatinDate = addMonth(probationDate , probationPrd);
									}
									System.out.println("confirmatinDate ..:: ["+confirmatinDate+"]");
									valueXmlString.append("<date_conf><![CDATA[").append(confirmatinDate).append("]]></date_conf>\r\n");
								}
								if( probationPrd.equalsIgnoreCase("0") && (trainingPrd.equalsIgnoreCase("0") ||  probationFlag.equalsIgnoreCase("Y"))) 
								{
									confirmedFlag = "Y";
								}
								else
								{
									confirmedFlag = "N";
								 }
								System.out.println("confirmedFlag ..:: ["+confirmedFlag+"]");
								valueXmlString.append("<confirmed><![CDATA[").append(confirmedFlag).append("]]></confirmed>\r\n");
							}
							else if (currentColumn.equalsIgnoreCase("date_join"))
							{
								dateJoin = checkNull(getColumnValue("date_join",dom,"1")) ;
								trainingPrd = checkNull(getColumnValue("training_prd",dom,"1")) ;
								probationPrd = checkNull(getColumnValue("probation_prd",dom,"1")) ;
								
								System.out.println("dateJoin ..:: ["+dateJoin+"]");
								System.out.println("trainingPrd ..:: ["+trainingPrd+"]");
								System.out.println("probationPrd ..:: ["+probationPrd+"]");
								
								valueXmlString.append("<gratuity_date><![CDATA[").append(dateJoin).append("]]></gratuity_date>\r\n");
								if(dateJoin != null && dateJoin.trim().length() > 0)
								{
									if(trainingPrd.equalsIgnoreCase("0"))
									{
										probationDate = dateJoin ;
									}
									else 
									{
										probationDate = addMonth(dateJoin , trainingPrd);
									}
									System.out.println("probationDate ..:: ["+probationDate+"]");
									valueXmlString.append("<probation_date><![CDATA[").append(probationDate).append("]]></probation_date>\r\n");
						
									if(probationPrd.equalsIgnoreCase("0"))
									{
										confirmatinDate = probationDate ;
									}
									else
									{
										confirmatinDate = addMonth(probationDate , probationPrd);
									}
									System.out.println("confirmatinDate ..:: ["+confirmatinDate+"]");
									valueXmlString.append("<date_conf><![CDATA[").append(confirmatinDate).append("]]></date_conf>\r\n");
									
									if(trainingPrd.equalsIgnoreCase("0") || probationDate.equalsIgnoreCase(dateJoin))
									{
										probationFlag = "Y";
									}
									else
									{
										probationFlag = "N";
									}
									System.out.println("probationFlag ..:: ["+probationFlag+"]");
									valueXmlString.append("<probation><![CDATA[").append(probationFlag).append("]]></probation>\r\n");
								}
								if( probationPrd.equalsIgnoreCase("0") && trainingPrd.equalsIgnoreCase("0")) 
								{
									confirmedFlag = "Y";
								}
								else
								{
									confirmedFlag = "N";
								}
								
								System.out.println("confirmedFlag ..:: ["+confirmedFlag+"]");
								valueXmlString.append("<confirmed><![CDATA[").append(confirmedFlag).append("]]></confirmed>\r\n");
							
							}
							
							valueXmlString.append("</Detail1>\r\n");
						
						}//End of Case 1
						break;
			}//END OF SWITCH
			
		}//End of try block		
		catch(Exception e)
		{
			e.printStackTrace();
			System.out.println( "Exception :EmpWorkInfo [itemChanged(String xmlString)] : ==>\n"+e.getMessage());
			throw new ITMException(e);
		}//End of cacth block
		finally
		{
			try
			{
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				if ( conn != null )
				{
					conn.close();
					conn = null;
				}
				
			}
			catch(Exception e)
			{
				System.out.println("Exception ::"+e);
				e.printStackTrace();
			}			
		}//End of finally block
		
		valueXmlString.append("</Root>\r\n");
		System.out.println("valueXmlString....["+valueXmlString.toString());
		return valueXmlString.toString();
	}//End of itemChanged block


	//Start of wfValData Start
	public String wfValData() throws RemoteException,ITMException
	{
		return "";
	}

	public String wfValData(String xmlString, String xmlString1,String xmlString2, String objContext, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		System.out.println("Came Inside 1 wfValData:::");
		
		//Modified By Hemlata on[20/11/2014] [As per changes in framework to use genericUtility ][Start]
		//GenericUtility genericUtility = GenericUtility.getInstance();
		 E12GenericUtility genericUtility = new E12GenericUtility();
		//Modified By Hemlata on[20/11/2014] [As per changes in framework to use genericUtility ][End]

		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String errString = "";
		System.out.println("xmlString ["+xmlString+"]");
		System.out.println("xmlString1["+xmlString1+"]");
		System.out.println("xmlString2["+xmlString2+"]");
		try
		{
			if(xmlString != null && xmlString.trim().length()!=0)
			{
				dom = parseString(xmlString); 
			}
			else
			{
				System.out.println("xmlstring is null");
			}
			if(xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = parseString(xmlString1); 
			}
			else
			{
				System.out.println("xmlstring1 is null");
			}
			if(xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = parseString(xmlString2);
			}
			else
			{
				System.out.println("xmlstring2 is null");
			}
			System.out.println("Before call valdata");
			errString = wfValData(dom,dom1,dom2,objContext,editFlag,xtraParams);
		}
		catch(Exception e)
		{
			System.out.println("Exception : [EmpWorkInfo][wfValData(String xmlString)] : ==>\n"+e.getMessage());
			e.printStackTrace();
			errString = genericUtility.createErrorString(e);
			
		}
		return (errString); 
	}

/*
	public String wfValData( Document dom, Document dom1, Document dom2, String objContext, String editFlag, String xtraParams ) throws RemoteException,ITMException
	{
		System.out.println("Came Inside 2 wfValData:::");
		String errString = "";
		Connection conn = null;
		
		GenericUtility genericUtility = GenericUtility.getInstance();
		try
		{
			ConnDriver connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("Driver");
			conn.setAutoCommit(false);
			
			errString = wfValData( dom, dom1, dom2, objContext, editFlag, xtraParams,conn);
		}
		catch ( Exception e )
		{
			e.printStackTrace();
			errString = genericUtility.createErrorString(e);
		}
		finally
		{
			try
			{
				if ( conn != null )
				{
					conn.close();
					conn = null;
				}
			}
			catch(Exception e1)
			{
				System.out.println( "Exception : [EmpWorkInfo][wfValData] : ==>\n"+e1.getMessage());
				throw new ITMException(e1);
			}
		}
		return errString;
	}
*/
	//30/10/2014
	//public String wfValData(Document dom, Document dom1,Document dom2, String objContext, String editFlag, String xtraParams,Connection conn) throws RemoteException,ITMException
	public String wfValData(Document dom, Document dom1,Document dom2, String objContext, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
	
		Node parentNode = null;
		Node childNode = null;

		NodeList parentNodeList = null;
		NodeList childNodeList = null;

		String errString = "";
		String childNodeName = "";	

		int currentFormNo = 0;		
		int childNodeListLength = 0;

		 
		String msgType = "";
		String errCode = "";
		String errFldName = "";
		StringBuffer errStringXml = new StringBuffer("<?xml version=\"1.0\"?>\r\n<Root><Errors>");

		ArrayList<String> errList = new ArrayList<String>();
		ArrayList<String> errFields = new ArrayList<String>();

		int cnt = 0;
		String sql = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;


		//Varibles used in case 1 Start

		String empCode = "";
		String empSite = "";
		String userId = "";
		String paySite = "";
		String workSite = "";
		String dateJoin = "";
		String posCode = "";
		String deptCode = "";
		String siteCodePayment = "";
		String patternCode = "";
		String workShift = "";
		String dateGratuity = "";
		String suppCodeCon = "";
		String workLocCode = "";
		String trainingPrd = "";
		String probationPrd = "";
		String noticePrd = "";
		String totalExp = "";
		//Varibles used in  case 1 End

		int ctr = 0;		
		int count = 0;	
		
		//Modified By Hemlata on[20/11/2014] [As per changes in framework to use genericUtility ][Start]
		//GenericUtility genericUtility = GenericUtility.getInstance();
		 E12GenericUtility genericUtility = new E12GenericUtility();
		//Modified By Hemlata on[20/11/2014] [As per changes in framework to use genericUtility ][End]
		
		Connection conn = null;//30/10/2014
		try
		{
			//30/10/2014.Start
			ConnDriver connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("Driver");
			conn.setAutoCommit(false);
			
			//30/10/2014.End
			if(objContext != null && objContext.trim().length()>0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
			SimpleDateFormat sdf = new SimpleDateFormat(getApplDateFormat());
			
			switch(currentFormNo)
			{
				case 1:
				{
					parentNodeList = dom.getElementsByTagName("Detail"+currentFormNo);
					parentNode = parentNodeList.item(0);
					childNodeList = parentNode.getChildNodes();
					childNodeListLength = childNodeList.getLength();

					for(ctr = 0; ctr < childNodeListLength; ctr++)
					{
						childNode = childNodeList.item(ctr);
						
						System.out.println("childNode"+childNode);
						if( childNode.getNodeType() != Node.ELEMENT_NODE )
						{
							continue;
						}

						childNodeName = childNode.getNodeName();
						//Validation For Employee Site
						if(childNodeName.equalsIgnoreCase("emp_site"))
						{ 
							count = 0;
							//30/10/2014
							//empSite = checkNull(getColumnValue("emp_site",dom,objContext));
							empSite = genericUtility.getColumnValue("emp_site",dom,objContext);

							System.out.println("empSite got in the validation ..::["+empSite+"]");
							
							sql = "SELECT COUNT(*) AS COUNT FROM SITE WHERE SITE_CODE = ? " ;
							pstmt = conn.prepareStatement(sql);		
							pstmt.setString(1,empSite);	
							rs = pstmt.executeQuery();		
							if( rs.next())
							{
								count  = rs.getInt("COUNT");
							}
							System.out.println("count:::: "+count);
							if ( rs != null )
							{
								rs.close();
								rs = null;
							}
							if ( pstmt != null )
							{
								pstmt.close();
								pstmt = null;
							}
							
							if(count == 0)
							{
								System.out.println("Invalid employment site, not defined in master::::");
								
								errList.add( "VMEMPWR01" );
								errFields.add( childNodeName.toLowerCase() );
								
								msgType =  errorType( conn , "VMEMPWR01" );
								if ( msgType.equalsIgnoreCase("E"))
								{
									break;
								}
							}
						}
						//Validation For Pay Site
						else if(childNodeName.equalsIgnoreCase("pay_site"))
						{
							count = 0 ;
							//30/10/2014
							//paySite = checkNull(getColumnValue("pay_site",dom,objContext));
							paySite = genericUtility.getColumnValue("pay_site",dom,objContext);
							sql = "SELECT COUNT(*) AS COUNT FROM SITE WHERE SITE_CODE = ? " ;
							pstmt = conn.prepareStatement(sql);		
							pstmt.setString(1,paySite);	
							rs = pstmt.executeQuery();		
							if( rs.next())
							{
								count  = rs.getInt("COUNT");
							}
							System.out.println("count:::: "+count);
							if ( rs != null )
							{
								rs.close();
								rs = null;
							}
							if ( pstmt != null )
							{
								pstmt.close();
								pstmt = null;
							}
							
							if(count == 0)
							{
								System.out.println("Invalid payment site, not defined in master:::");
								
								errList.add( "VMEMPWR02" );
								errFields.add( childNodeName.toLowerCase() );
								
								msgType =  errorType( conn , "VMEMPWR02" );
								if ( msgType.equalsIgnoreCase("E"))
								{
									break;
								}
							}
						}
						//Validation For Work Site
						else if(childNodeName.equalsIgnoreCase("work_site"))
						{
							count = 0 ;
							//30/10/2014
							//workSite = checkNull(getColumnValue("work_site",dom,objContext));
							workSite = genericUtility.getColumnValue("work_site",dom,objContext);
							sql = "SELECT COUNT(*) AS COUNT FROM SITE WHERE SITE_CODE = ? " ;
							pstmt = conn.prepareStatement(sql);		
							pstmt.setString(1,workSite);	
							rs = pstmt.executeQuery();		
							if( rs.next())
							{
								count  = rs.getInt("COUNT");
							}
							System.out.println("count:::: "+count);
							if ( rs != null )
							{
								rs.close();
								rs = null;
							}
							if ( pstmt != null )
							{
								pstmt.close();
								pstmt = null;
							}
							
							if(count == 0)
							{
								System.out.println("Invalid work site, not defined in master:::");
								
								errList.add( "VMEMPWR03" );
								errFields.add( childNodeName.toLowerCase() );
								
								msgType =  errorType( conn , "VMEMPWR03" );
								if ( msgType.equalsIgnoreCase("E"))
								{
									break;
								}
							}
						}
						//Validation For Join Date 
						else if(childNodeName.equalsIgnoreCase("date_join"))
						{
							errString = "";
							dateJoin = checkNull(genericUtility.getColumnValue("date_join",dom,objContext));
							
							
							if (dateJoin == null || dateJoin.length() == 0)
							{
								System.out.println("joinDate null:::");
								
								errList.add( "VMJOIN" );
								errFields.add( childNodeName.toLowerCase() );
								
								msgType =  errorType( conn , "VMJOIN" );
								if ( msgType.equalsIgnoreCase("E"))
								{
									break;
								}
							}
							else
							{
								empCode = checkNull(genericUtility.getColumnValue("emp_code",dom,objContext));
							
								java.util.Date joinDate = sdf.parse(dateJoin);
								System.out.println("joinDate l:::"+joinDate);								
															
								sql = "SELECT DEPT_CODE , POS_CODE FROM EMPLOYEE WHERE EMP_CODE = ? ";
								pstmt = conn.prepareStatement(sql);

								pstmt.setString(1,empCode);
								rs = pstmt.executeQuery();

								if(rs.next())
								{
									posCode = rs.getString("POS_CODE");
									deptCode = rs.getString("DEPT_CODE");
								}
								if(rs != null)
								{
									rs.close();
									rs = null;
								}
								if(pstmt != null)
								{
									pstmt.close();
									pstmt = null;
								}
								System.out.println("posCode::::::"+posCode);
								System.out.println("deptCode::::::"+deptCode);
								
								errString = wf_val_pos(empCode , posCode , deptCode , joinDate , conn);
								
								if (errString != null && errString.length() > 0)
								{
									errList.add(errString);
									errFields.add( childNodeName.toLowerCase() );
									
									msgType =  errorType( conn ,errString );
									
									if ( msgType.equalsIgnoreCase("E"))
									{
										break;
									}
								}
							}							

						}
						//Validation For payment  site 
						else if(childNodeName.equalsIgnoreCase("site_code__payment"))
						{
							count = 0 ;
							//30/10/2014
							//siteCodePayment = checkNull(getColumnValue("site_code__payment",dom,objContext));
							siteCodePayment = genericUtility.getColumnValue("site_code__payment",dom,objContext);
							//30/10/2014
							empSite = genericUtility.getColumnValue("emp_site",dom,objContext);
							//empSite = checkNull(getColumnValue("emp_site",dom,objContext));
							
							if(siteCodePayment != null && siteCodePayment.trim().length() > 0)
							{
								sql = "SELECT COUNT(*) AS COUNT FROM SITE WHERE SITE_CODE = ? ";
								pstmt = conn.prepareStatement(sql);		
								pstmt.setString(1,siteCodePayment);	
								rs = pstmt.executeQuery();		
								if( rs.next())
								{
									count  = rs.getInt("COUNT");
								}
								System.out.println("Value in count:::: "+count);
								if ( rs != null )
								{
									rs.close();
									rs = null;
								}
								if ( pstmt != null )
								{
									pstmt.close();
									pstmt = null;
								}
								
								if(count == 0)
								{
									System.out.println("Invalid Payment site, not defined in master::::");
									
									errList.add( "VMSITE" );
									errFields.add( childNodeName.toLowerCase() );
									
									msgType =  errorType( conn , "VMSITE" );
									if ( msgType.equalsIgnoreCase("E"))
									{
										break;
									}
								}
								else
								{
									sql = "SELECT COUNT(*) AS COUNT FROM SITE WHERE SITE_CODE = ?  AND FIN_ENTITY = (SELECT FIN_ENTITY FROM SITE WHERE SITE_CODE = ? )";

									pstmt = conn.prepareStatement(sql);		
									pstmt.setString(1,siteCodePayment);	
									pstmt.setString(2,empSite);
									rs = pstmt.executeQuery();		

									if( rs.next())
									{
										count  = rs.getInt("COUNT");
									}
									System.out.println("Value in count:::: "+count);
									if ( rs != null )
									{
										rs.close();
										rs = null;
									}
									if ( pstmt != null )
									{
										pstmt.close();
										pstmt = null;
									}

									if(count == 0)
									{
										System.out.println("Invalid Payment site, ::::");
										
										errList.add( "VMSITE2" );
										errFields.add( childNodeName.toLowerCase() );
										
										msgType =  errorType( conn , "VMSITE2" );
										if ( msgType.equalsIgnoreCase("E"))
										{
											break;
										}
									}
								}
							}
						}
						else if(childNodeName.equalsIgnoreCase("pattern_code"))
						{
							//30/10/2014
							//patternCode = checkNull(getColumnValue("pattern_code",dom,objContext));
							patternCode = genericUtility.getColumnValue("pattern_code",dom,objContext);

							java.util.Date startDate = null;
							if(patternCode != null && patternCode.trim().length() > 0 )
							{
								empCode = checkNull(getColumnValue("emp_code",dom,objContext));
								//30/10/2014
								//workSite = checkNull(getColumnValue("work_site",dom,objContext));
								workSite = getColumnValue("work_site",dom,objContext);

								sql = "SELECT START_DATE  FROM SHIFT_PATTERN WHERE SITE_CODE = ? AND PATTERN_CODE = ? ";
								pstmt = conn.prepareStatement(sql);		
								pstmt.setString(1,workSite);	
								pstmt.setString(2,patternCode);
								rs = pstmt.executeQuery();		
								if( rs.next())
								{
									startDate = rs.getDate("START_DATE");
								}
								else
								{
									errString = "VTPNOTM";
								}
								System.out.println("startDate:::: "+startDate);
								if ( rs != null )
								{
									rs.close();
									rs = null;
								}
								if ( pstmt != null )
								{
									pstmt.close();
									pstmt = null;
								}
								if (errString != null && errString.length() > 0)
								{
									System.out.println("pattern code not matching work site of employee");
									
									errList.add(errString);
									errFields.add( childNodeName.toLowerCase() );
									
									msgType =  errorType( conn ,errString );
									
									if ( msgType.equalsIgnoreCase("E"))
									{
										break;
									}
								}
								if (startDate != null)
								{
									Date currentDate = new Date();
									if(startDate.after(currentDate))
									{

										System.out.println("Eff date should be greater then pattern start date");
										
										errList.add("VTDTGTST");
										errFields.add( childNodeName.toLowerCase() );
										
										msgType =  errorType( conn ,"VTDTGTST" );
										
										if ( msgType.equalsIgnoreCase("E"))
										{
											break;
										}
									}
								}
								
							}
						}
						else if(childNodeName.equalsIgnoreCase("work_shift"))
						{
							count = 0 ;
							workShift  = checkNull(genericUtility.getColumnValue("work_shift",dom,objContext));
							if(workShift != null && workShift.length() > 0 )
							{
								empCode = checkNull(genericUtility.getColumnValue("emp_code",dom,objContext));
								//30/10/2014
								//workSite = checkNull(getColumnValue("work_site",dom,objContext));
								workSite = genericUtility.getColumnValue("work_site",dom,objContext);

								sql = "SELECT COUNT(*) AS COUNT FROM WORKSHFT WHERE SITE_CODE = ? AND SHIFT = ? ";

								pstmt = conn.prepareStatement(sql);		
								pstmt.setString(1,workSite);	
								pstmt.setString(2,workShift);
								rs = pstmt.executeQuery();	
								
								if( rs.next())
								{
									count = rs.getInt("COUNT");
								}
								System.out.println("count:::: "+count);
								if ( rs != null )
								{
									rs.close();
									rs = null;
								}
								if ( pstmt != null )
								{
									pstmt.close();
									pstmt = null;
								}
								if(count == 0)
								{
									System.out.println("Shift not matching work site of employee ::::");
									
									errList.add( "VTWSNOT" );
									errFields.add( childNodeName.toLowerCase() );
									
									msgType =  errorType( conn , "VTWSNOT" );
									if ( msgType.equalsIgnoreCase("E"))
									{
										break;
									}
								}
								else
								{
									sql = "SELECT COUNT(*) AS COUNT  FROM WORKSHFT WHERE SITE_CODE = ? AND SHIFT = ? AND STATUS = ? ";
									pstmt = conn.prepareStatement(sql);		
									pstmt.setString(1,workSite);	
									pstmt.setString(2,workShift);
									pstmt.setString(3,"I");

									rs = pstmt.executeQuery();
									
									if( rs.next())
									{
										count = rs.getInt("COUNT");
									}
									System.out.println("count:::: "+count);
									if ( rs != null )
									{
										rs.close();
										rs = null;
									}
									if ( pstmt != null )
									{
										pstmt.close();
										pstmt = null;
									}

									if(count > 0)
									{
										System.out.println("Shift not active ::::");
										
										errList.add( "VTSHINAC" );
										errFields.add( childNodeName.toLowerCase() );
										
										msgType =  errorType( conn , "VTSHINAC" );
										if ( msgType.equalsIgnoreCase("E"))
										{
											break;
										}
									}
								}
							}
						}
						else if(childNodeName.equalsIgnoreCase("gratuity_date"))
						{
							dateGratuity  = checkNull(genericUtility.getColumnValue("gratuity_date",dom,objContext));
							dateJoin = checkNull(genericUtility.getColumnValue("date_join",dom,objContext));
							
							if (dateGratuity.length() > 0 && dateJoin.length() > 0)
							{
								//30/10/2014
								//SimpleDateFormat sdf = new SimpleDateFormat(getApplDateFormat());
								java.util.Date gratuitydate = sdf.parse(dateGratuity);
								java.util.Date joinDate = sdf.parse(dateJoin);
								
								if(gratuitydate.before(joinDate))
								{
									System.out.println("gratuity date can't less than join date::::");
									
									errList.add( "VTGRADATE" );
									errFields.add( childNodeName.toLowerCase() );
									
									msgType =  errorType( conn , "VTGRADATE" );
									if ( msgType.equalsIgnoreCase("E"))
									{
										break;
									}
								}
							}
						}
						else if(childNodeName.equalsIgnoreCase("supp_code__con"))
						{
							count = 0;

							//30/10/2014
							//suppCodeCon  = checkNull(getColumnValue("supp_code__con",dom,objContext));
							suppCodeCon  = genericUtility.getColumnValue("supp_code__con",dom,objContext);

							if(suppCodeCon != null && suppCodeCon.trim().length() > 0)
							{
								sql = "SELECT COUNT(1) AS COUNT FROM SUPPLIER WHERE SUPP_CODE = ? ";
								pstmt = conn.prepareStatement(sql);		
								pstmt.setString(1,suppCodeCon);	
								rs = pstmt.executeQuery();		
								if( rs.next())
								{
									count = rs.getInt("COUNT");
								}
								System.out.println("count:::: "+count);
								if ( rs != null )
								{
									rs.close();
									rs = null;
								}
								if ( pstmt != null )
								{
									pstmt.close();
									pstmt = null;
								}
								if(count  == 0)
								{
									errList.add( "VTSUPP1" );
									errFields.add( childNodeName.toLowerCase() );
									
									msgType =  errorType( conn , "VTSUPP1" );
									if ( msgType.equalsIgnoreCase("E"))
									{
										break;
									}
								}
							}
							else if(suppCodeCon != null && suppCodeCon.length() > 0)
							{
								errList.add( "VMSUPPCD" );
								errFields.add( childNodeName.toLowerCase() );
								
								msgType =  errorType( conn , "VMSUPPCD" );
								if ( msgType.equalsIgnoreCase("E"))
								{
									break;
								}
							}
						}
						else if(childNodeName.equalsIgnoreCase("work_loc_code"))
						{
							count = 0;
							workLocCode  = genericUtility.getColumnValue("work_loc_code",dom,objContext);

							if(workLocCode != null && workLocCode.length() > 0 )
							{
								sql = "SELECT COUNT(1) AS COUNT FROM WORK_LOCATIONS WHERE WORK_LOC_CODE = ? ";
								pstmt = conn.prepareStatement(sql);		
								pstmt.setString(1,workLocCode);	
								rs = pstmt.executeQuery();		
								if( rs.next())
								{
									count = rs.getInt("COUNT");
								}
								System.out.println("count:::: "+count);
								if ( rs != null )
								{
									rs.close();
									rs = null;
								}
								if ( pstmt != null )
								{
									pstmt.close();
									pstmt = null;
								}
								if(count  == 0)
								{
									errList.add( "VMEMPWLOC1" );
									errFields.add( childNodeName.toLowerCase() );
									
									msgType =  errorType( conn , "VMEMPWLOC1" );
									if ( msgType.equalsIgnoreCase("E"))
									{
										break;
									}
								}
								else
								{
									count = 0;
									sql= "SELECT COUNT(1) AS COUNT FROM WORK_LOCATIONS WHERE WORK_LOC_CODE = ? AND CASE WHEN ACTIVE IS NULL THEN 'Y' ELSE ACTIVE END = 'Y' ";
									pstmt = conn.prepareStatement(sql);		
									pstmt.setString(1,workLocCode);	
									rs = pstmt.executeQuery();		
									if( rs.next())
									{
										count = rs.getInt("COUNT");
									}
									System.out.println(" Value of count:::: "+count);
									if ( rs != null )
									{
										rs.close();
										rs = null;
									}
									if ( pstmt != null )
									{
										pstmt.close();
										pstmt = null;
									}
									if(count  == 0)
									{
										errList.add( "VMEMPWLOC2" );
										errFields.add( childNodeName.toLowerCase() );
										
										msgType =  errorType( conn , "VMEMPWLOC2" );
										if ( msgType.equalsIgnoreCase("E"))
										{
											break;
										}
									}
								}
							}
						}
						else if(childNodeName.equalsIgnoreCase("training_prd"))
						{
							trainingPrd  = checkNull(genericUtility.getColumnValue("training_prd",dom,objContext));
							if(trainingPrd.length() == 0)
							{
								trainingPrd = "0";
							}
							if(Integer.parseInt(trainingPrd) < 0)
							{
								errList.add( "VMEMPWRK01" );
								errFields.add( childNodeName.toLowerCase() );
								
								msgType =  errorType( conn , "VMEMPWRK01" );
								if ( msgType.equalsIgnoreCase("E"))
								{
									break;
								}
							}
						}
						else if(childNodeName.equalsIgnoreCase("probation_prd"))
						{
							probationPrd = checkNull(genericUtility.getColumnValue("probation_prd",dom,objContext));
							if(probationPrd.length() == 0)
							{
								probationPrd = "0";
							}
							if(Integer.parseInt(probationPrd) < 0)
							{
								errList.add( "VMEMPWRK02" );
								errFields.add( childNodeName.toLowerCase() );
								
								msgType =  errorType( conn , "VMEMPWRK02" );
								if ( msgType.equalsIgnoreCase("E"))
								{
									break;
								}
							}
						}
						else if(childNodeName.equalsIgnoreCase("notice_prd"))
						{
							noticePrd  = checkNull(genericUtility.getColumnValue("notice_prd",dom,objContext));
							if(noticePrd.length() == 0)
							{
								noticePrd = "0";
							}
							if(Integer.parseInt(noticePrd) < 0)
							{
								errList.add( "VMEMPWRK03" );
								errFields.add( childNodeName.toLowerCase() );
								
								msgType =  errorType( conn , "VMEMPWRK03" );
								if ( msgType.equalsIgnoreCase("E"))
								{
									break;
								}
							}
						}
						else if(childNodeName.equalsIgnoreCase("tot_exp"))
						{
							totalExp  = checkNull(genericUtility.getColumnValue("tot_exp",dom,objContext));
							if(totalExp.length() == 0)
							{
								totalExp = "0";
							}
							if(Integer.parseInt(totalExp) < 0)
							{
								errList.add( "VMEMPWRK04" );
								errFields.add( childNodeName.toLowerCase() );
								
								msgType =  errorType( conn , "VMEMPWRK04" );
								if ( msgType.equalsIgnoreCase("E"))
								{
									break;
								}
							}
						}
					}
			}//End of case
			break;		
		}//End of Switch
			int errListSize = errList.size();
				if ( errList != null && errListSize > 0 )
				{
					for (cnt = 0; cnt < errListSize; cnt++ )
					{
						errCode = (String)errList.get(cnt);
						errFldName = (String)errFields.get(cnt);
						System.out.println("errCode .........."+errCode);
						
						errString = getErrorString( errFldName, errCode, userId );
						System.out.println("errString is : ::::>>>> " + errString);
						msgType =  errorType( conn , errCode );
						if ( errString.length() > 0)
						{
							String bifurErrString = errString.substring( errString.indexOf("<Errors>") + 8,errString.indexOf("<trace>"));
							bifurErrString =bifurErrString+errString.substring( errString.indexOf("</trace>") + 8,errString.indexOf("</Errors>"));
							errStringXml.append(bifurErrString);
							System.out.println("errStringXml .........."+errStringXml);
							errString = "";
						}
						if ( msgType.equalsIgnoreCase("E"))
						{
							break;
						}
					}
					errList.clear();
					errList = null;
					errFields.clear();
					errFields = null;
					
					errStringXml.append("</Errors></Root>\r\n");
				}
				else
				{
					errStringXml = new StringBuffer( "" );
				}
				errString = errStringXml.toString();

		}
		catch(Exception e)
		{
			System.out.println( "Exception : [EmpWorkInfo][wfValData(String xmlString)] : ==>\n"+e.getMessage());
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				
				if ( conn != null )
				{
					conn.close();
					conn = null;
				}
			}
			catch(Exception e1)
			{
				System.out.println( "Exception : [EmpWorkInfo][wfValData] : ==>\n"+e1.getMessage());
				throw new ITMException(e1);
			}
		}

	
		return errString;
	}
	//Start of wfValData End


	private String checkNull( String input )
	{
		if (input == null)
		{
			input = "";
		}
		else
		{
			input = input.trim();
		}
		return input;
	}
	private String getObjName(Document dom,String objContext)
	{	
		Node elementName = null;
		NodeList elementList = null;
		String objName = "";
		elementList = dom.getElementsByTagName("Detail"+objContext);
		elementName = elementList.item(0);
		if (elementName!=null && ("Detail"+objContext).equalsIgnoreCase(elementName.getNodeName()))
		{
			NamedNodeMap etlAttributes = elementName.getAttributes();
			if (etlAttributes!=null)
			{
				if (etlAttributes.getNamedItem("objName")!=null)
				{
					objName = etlAttributes.getNamedItem("objName").getNodeValue();
				}
			}
		}
		return objName;
	}

	private String errorType( Connection conn , String errorCode ) throws ITMException
	{
		String msgType = "";
		PreparedStatement pstmt = null ; 
		ResultSet rs = null;
		try
		{			
			String  sql = " SELECT MSG_TYPE FROM MESSAGES WHERE MSG_NO = ? ";
			
			pstmt = conn.prepareStatement( sql );			
			pstmt.setString(1, errorCode);			
			rs = pstmt.executeQuery();
			while( rs.next() )
			{
				msgType = rs.getString("MSG_TYPE");
			}			
		}
		catch (Exception ex)
		{
			ex.printStackTrace();
			throw new ITMException(ex);
		}		
		finally
		{
			try
			{
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch ( Exception e )
			{
				e.printStackTrace();
				throw new ITMException(e);
			}
		}		
		return msgType;
	}

	private String wf_val_pos(String empCode , String posCode , String deptCode , Date joinDate , Connection conn) throws ITMException
	{
		String sql = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String dbPosCode  =  "";
		java.util.Date dbJoinDate = null ;	
		String dbDeptCode = "";
		String tableno = "";
		String errString = "";
		String versionId = "";

		//Modified By Hemlata on[20/11/2014] [As per changes in framework to use genericUtility ][Start]
		//GenericUtility genericUtility = GenericUtility.getInstance();
		 E12GenericUtility genericUtility = new E12GenericUtility();
		//Modified By Hemlata on[20/11/2014] [As per changes in framework to use genericUtility ][End]
		try
		{
			if(posCode == null || posCode.length() == 0)
			{
				return "";
			}

			Date currentDate = new Date();
			SimpleDateFormat sdf = new SimpleDateFormat(getApplDateFormat());
			String curDate = sdf.format(currentDate);
			curDate = genericUtility.getValidDateTimeString(curDate,genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() );
			
			sql = "SELECT POS_CODE  AS  POS_CODE_OLD , DATE_JOIN  AS  JOIN_DATE_OLD ,  DEPT_CODE  AS  DEPT_CODE_OLD  FROM  EMPLOYEE  WHERE  EMP_CODE = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,empCode);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				dbPosCode = checkNull(rs.getString("POS_CODE_OLD"));
				dbJoinDate = rs.getDate("JOIN_DATE_OLD");
				dbDeptCode = checkNull(rs.getString("DEPT_CODE_OLD"));
			}
			else
			{
				dbPosCode = null;
				dbJoinDate = null;
				dbDeptCode = null;
			}
			if( rs != null)
			{
				rs.close();
				rs = null;
			}
			if( pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			
			System.out.println("posCodeOld:::::::::"+dbPosCode);
			System.out.println("joinDateOld:::::::::"+dbJoinDate);
			System.out.println("deptCodeOld:::::::::"+dbDeptCode);
			if(dbJoinDate == null)
			{
				dbJoinDate = currentDate;
			}
			if(joinDate == null)
			{
				joinDate = dbJoinDate ;
			}
			if(dbPosCode == null || dbPosCode.trim().length() == 0 )
			{
				dbPosCode = "!";
			}
			if(dbDeptCode == null || dbDeptCode.trim().length() == 0 )
			{
				dbDeptCode = "!";
			}
			if(deptCode == null || deptCode.trim().length() == 0)
			{
				deptCode = dbDeptCode ;
			}
			if(!(dbPosCode.equalsIgnoreCase(posCode)) || dbJoinDate.compareTo(joinDate) > 0 || !(dbDeptCode.equalsIgnoreCase(deptCode)))
			{
				sql = "SELECT ITEM_SER AS TABLENO FROM DEPARTMENT WHERE DEPT_CODE = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,deptCode);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					tableno = checkNull(rs.getString("TABLENO"));
				}
				if( rs != null)
				{
					rs.close();
					rs = null;
				}
				if( pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				System.out.println("tableno:::::::::"+tableno);
				if(tableno == null || tableno.length() == 0)
				{
					errString = "VMTBLNO";
					return errString;
				}
				sql = "SELECT VERSION_ID  FROM VERSION WHERE ? BETWEEN EFF_FROM AND VALID_UPTO ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setTimestamp(1,java.sql.Timestamp.valueOf(curDate));
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					versionId = checkNull(rs.getString("VERSION_ID"));
				}
				else
				{
					errString ="VERID";
				}
				if( rs != null)
				{
					rs.close();
					rs = null;
				}
				if( pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(errString != null && errString.length() > 0)
				{
					return errString;
				}
				System.out.println("versionId:::::::::"+versionId);
				
				sql = "SELECT EMP_CODE AS EMP_CODE_ORG FROM ORG_STRUCTURE WHERE VERSION_ID = ? AND TABLE_NO = ? AND POS_CODE = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,versionId);
				pstmt.setString(2,tableno);
				pstmt.setString(3,posCode);
				rs = pstmt.executeQuery();
				String empCodeOrg = "";
				if(rs.next())
				{
					empCodeOrg = checkNull(rs.getString("EMP_CODE_ORG"));
				}
				else
				{
					errString = "NOPOS";
				}
				if( rs != null)
				{
					rs.close();
					rs = null;
				}
				if( pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(errString != null && errString.length() > 0)
				{
					return errString;
				}
				System.out.println("empCodeOrg:::::::::"+empCodeOrg);
				if(( empCodeOrg != null && empCodeOrg.trim().length() > 0 ) && !(empCodeOrg.trim().equalsIgnoreCase(empCode.trim())))
				{
					errString = "POSNA";
					return errString;
				}
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
			errString = "DS000";
			throw new ITMException(e);
		}
		return errString ;
	}
	
	private String addMonth(String joinDate , String period)
	{
		String returnDate = joinDate;
		String calDate = "";
		try
		{
			// Modified By Hemlata to prevent from throwing exception when peroid value is zero and period length is zero [Start]
			/*
			 	int month = Integer.parseInt(period) ;
				SimpleDateFormat sdf = new SimpleDateFormat(getApplDateFormat());
				Calendar cal = Calendar.getInstance();
				cal.setTime(sdf.parse(joinDate));
				cal.add(cal.MONTH , month);
				returnDate = sdf.format(cal.getTime());
				System.out.println("Final Calculated Date...::" +returnDate);			
			 */
			if((period != null && period.trim().length() > 0 ) && Integer.parseInt(period) != 0)
			{
				int month = Integer.parseInt(period) ;
				SimpleDateFormat sdf = new SimpleDateFormat(getApplDateFormat());
				Calendar cal = Calendar.getInstance();
				cal.setTime(sdf.parse(joinDate));
				cal.add(cal.MONTH , month);
				returnDate = sdf.format(cal.getTime());
				System.out.println("Final Calculated Date...::" +returnDate);			
				//returnDate = sdf.parse(calDate);
			}
			//Modified By Hemlata to prevent from throwing exception when peroid value is zero and period length is zero [End]
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		return returnDate ;
	}
	
}