package ibase.e12ria.e12table.client;

import java.util.ArrayList;
import java.util.TreeMap;

import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.EventTarget;
import com.google.gwt.dom.client.TableCellElement;
import com.google.gwt.dom.client.TableRowElement;
import com.google.gwt.dom.client.TableSectionElement;
import com.google.gwt.user.cellview.client.DataGrid;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.view.client.ProvidesKey;

/**
 * This class is used to show the data in paged format.
 * 
 * @author base
 */
public abstract class AbstractDataGrid<T> extends DataGrid<T> 
{
	
	protected int selectedRow = -1;
	protected int menuSize = 0;
	protected int rowCount = 0;
	protected boolean performTotaling = true; // To restrict totaling on Checkbox selection

	public AbstractDataGrid(int pageSize) {
		super(pageSize);
		sinkEvents(Event.ONCONTEXTMENU | Event.ONDBLCLICK | Event.ONCLICK);
	}
	
	public AbstractDataGrid(int pageSize, ProvidesKey<T> keyProvider) {
	    super(pageSize, keyProvider);
	    sinkEvents(Event.ONCONTEXTMENU | Event.ONDBLCLICK);
	}

	public AbstractDataGrid(int pageSize, Resources resources)
	{
		super(pageSize, resources);
		sinkEvents(Event.ONCONTEXTMENU | Event.ONDBLCLICK);
	}
	/**
	 * It is used to get nearest parent cell.
	 * 
	 * @param elem
	 * @return null
	 */
	private TableCellElement findNearestParentCell(Element elem) {
		while ((elem != null) && (elem != getElement())) {

			// This would allow us to use TableCellElement.is() -- much cleaner.
			String tagName = elem.getTagName();
			if ("td".equalsIgnoreCase(tagName) || "th".equalsIgnoreCase(tagName)) {
				return elem.cast();
			}
			elem = elem.getParentElement();
		}
		return null;
	}

	public void onBrowserEvent2(Event event) {
		super.onBrowserEvent2(event);
		//event.preventDefault();
		EventTarget eventTarget = event.getEventTarget();
		if (!Element.is(eventTarget)) {
			return;
		}

		final Element target = event.getEventTarget().cast();
		TableCellElement tableCell = findNearestParentCell(target);
		if (tableCell == null) {
			return;
		}

		Element trElem = tableCell.getParentElement();
		if (trElem == null) {
			return;
		}
		TableRowElement tr = TableRowElement.as(trElem);

		Element sectionElem = tr.getParentElement();
		if (sectionElem == null) {
			return;
		}
		TableSectionElement section = TableSectionElement.as(sectionElem);
		switch (DOM.eventGetType(event)) {
		case Event.ONCONTEXTMENU:
			int xPosition = 0;
			int yPosition = 0;
			event.preventDefault();
			try {
				if (section == getTableBodyElement()) {
					selectedRow = tr.getSectionRowIndex();
					xPosition = event.getClientX();
					yPosition = event.getClientY();
					showContextMenu(selectedRow, xPosition, yPosition);
				}
			} catch (Exception e) {
				Window.alert(" Exception in  AbstractDataGrid onBrowserEvent2 ");
			}
			break;

		case Event.ONDBLCLICK:
			if (section == getTableBodyElement()) {
				performDoubleClick();
			}
			break;
			
		case Event.ONCLICK:
			event.preventDefault();
			try {
				if (section == getTableBodyElement()) {
					selectedRow = tr.getSectionRowIndex();
					showOptionMenu( selectedRow );
				}
			} catch (Exception e) {
				Window.alert(" Exception in  AbstractDataGrid onBrowserEvent2 ");
			}
			break;

		default:
			break;
		}
	}
	
	public abstract void performOnTouch();
	
	public abstract void showOptionMenu(int selectedRow);
	
	public abstract void refresh();
	
	public abstract void performDoubleClick();

	public abstract void createContextMenu();
	
	public abstract void showContextMenu(int selectedRow,int xPosition ,int yPosition );
	
	public abstract FlexTable createTableComponent( ArrayList<T> dataGridTableRowList, ArrayList<ColumnInfoBean> dataGridTableColList, FlexTable flexTable);
	
	public abstract FlexTable createTableComponent( ArrayList<T> dataGridTableRowList, TreeMap<Integer, Object>dataGridTableColList);
	
	// To restrict totaling on Checkbox selection
	public boolean isPerformTotaling() {
		return performTotaling;
	}

}
