import { Component, Input } from '@angular/core';
var BBLinkButtonComponent = (function () {
    function BBLinkButtonComponent() {
        this.uxDesign = 'UX3';
        this.bbAutofocus = false;
        this.bbDisabled = false;
        this.appearance = '';
        this.role = '';
    }
    BBLinkButtonComponent.decorators = [
        { type: Component, args: [{
                    selector: 'bb-link-button',
                    template: "\n\n      <span [ngSwitch]=\"uxDesign\">\n      \t<span *ngSwitchCase=\"'UX1'\" [ngSwitch]=\"role\">\n      \t     <span *ngSwitchCase=\"'link'\"> \n         \t\t\t<a [href]=\"!bbDisabled ? link : '#'\" [class.disabled]=\"bbDisabled\">\n         \t\t\t  <ng-container *ngTemplateOutlet=\"label\"></ng-container>\n         \t\t\t</a>\n      \t     </span>\t\n      \t</span> \n\t\n      \t<span *ngSwitchCase=\"'UX3'\" [ngSwitch]=\"role\">\n      \t      <span *ngSwitchCase=\"'link'\"> \n         \t\t\t<a [href]=\"!bbDisabled ? link : '#'\" [class.disabled]=\"bbDisabled\">\n         \t\t\t  <ng-container *ngTemplateOutlet=\"label\"></ng-container>\n         \t\t\t</a>\n      \t      </span>\t\n\t      \n      \t      <span *ngSwitchCase=\"'button'\"> \n      \t         <a md-raised-button [href]=\"!bbDisabled ? link : '#'\" [class.disabled]=\"bbDisabled\">\n      \t         \t<ng-container *ngTemplateOutlet=\"label\"></ng-container>\n      \t         </a>\n      \t\t  </span>\n      \t</span> \n\t\n      \t<ng-template #label><ng-content></ng-content></ng-template>\n      </span>\n    ",
                    styles: ["\n      a.disabled {\n         pointer-events: none;\n         cursor: not-allowed; \n      }\n    "]
                },] },
    ];
    /** @nocollapse */
    BBLinkButtonComponent.ctorParameters = function () { return []; };
    BBLinkButtonComponent.propDecorators = {
        'uxDesign': [{ type: Input, args: ['uxDesign',] },],
        'bbAutofocus': [{ type: Input, args: ['autofocus',] },],
        'bbDisabled': [{ type: Input, args: ['disabled',] },],
        'appearance': [{ type: Input, args: ['appearance',] },],
        'link': [{ type: Input, args: ['link',] },],
        'role': [{ type: Input, args: ['role',] },],
    };
    return BBLinkButtonComponent;
}());
export { BBLinkButtonComponent };
//# sourceMappingURL=bb-link-button.component.js.map