package ibase.webitm.ejb.dis;

import java.sql.Connection;
import java.sql.SQLException;

import javax.naming.InitialContext;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import ibase.system.config.AppConnectParm;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.DBAccessLocal;
import ibase.webitm.ejb.MasterStatefulLocal;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.ITMException;

public class SCMWebServiceDao extends ValidatorEJB
{
	E12GenericUtility e12GenericUtility = new E12GenericUtility();
	
	public String addTransaction(String dataXML, String userCode) throws ITMException
	{
		String retString = "", userInfo = "";
		MasterStatefulLocal masterStatefulLocal = null;
		DBAccessLocal dbAccessEJBLocal = null;
		UserInfoBean userInfoBean = null;
		Connection conn = null;
		boolean isError = false, isCommit = false;
		Document errDom = null;
		StringBuffer retSBuff = new StringBuffer("<Root>");
		try
		{
			System.out.println("SCMWebServiceDao.addTransaction().dataXML["+dataXML+"]");
			System.out.println("SCMWebServiceDao.addTransaction().userCode["+userCode+"]");
			
			dbAccessEJBLocal = (DBAccessLocal)getInitialContext().lookup("ibase/DBAccessEJB/local"); 
			userInfoBean = dbAccessEJBLocal.createUserInfo(userCode);
			
			setUserInfo(userInfoBean);
			userInfo = userInfoBean.toString();
			
			System.out.println("SCMWebServiceDao.addTransaction().userInfo["+userInfo+"]");
			
			conn = getConnection();
			
			masterStatefulLocal = (MasterStatefulLocal) getInitialContext().lookup( "ibase/MasterStatefulEJB/local" );
			retString = masterStatefulLocal.processRequest(userInfo, dataXML, true, conn); 
			
			System.out.println("After masterstateful retString["+retString+"]");
			
			if(retString != null && retString.trim().length()>0 && retString.indexOf("<Errors>") >-1)
			{
				isCommit = false;
				errDom = e12GenericUtility.parseString(retString);
				
				NodeList errNodeList = errDom.getElementsByTagName("error");
				int errNodeListLen = errNodeList.getLength();
				
				for(int i=0; i<errNodeListLen; i++)
				{
					String errorMessage = "";
					Node eachErrNode = errNodeList.item(i);
					NodeList eachErrNodeList = eachErrNode.getChildNodes();
					int eachErrNodeListLen = eachErrNodeList.getLength();
					
					String msgNo = eachErrNode.getAttributes().getNamedItem("id").getNodeValue();
					System.out.println("msgNo["+msgNo+"]");
					for(int j=0; j<eachErrNodeListLen; j++)
					{
						Node eachNode = eachErrNodeList.item(j);
						String nodeName = eachNode.getNodeName();
						String nodeValue = eachNode.getFirstChild() != null ? eachNode.getFirstChild().getNodeValue():"";
						
						if("description".equalsIgnoreCase(nodeName))
						{
							errorMessage = nodeValue;
						}
					}
					retSBuff.append("<tran_id><![CDATA[]]></tran_id>");
					retSBuff.append("<msg_code><![CDATA["+msgNo+"]]></msg_code>");
					retSBuff.append("<msg_descr><![CDATA["+errorMessage+"]]></msg_descr>");
					retSBuff.append("<result><![CDATA[FAILED]]></result>");
				}
			}
			else
			{
				isCommit = true;
				
				if ( retString.indexOf("Success") > -1 && retString.indexOf("<TranID>") > 0 )
				{
				    String tranId = retString.substring( retString.indexOf("<TranID>")+8, retString.indexOf("</TranID>"));
				    
				    retSBuff.append("<tran_id><![CDATA["+tranId+"]]></tran_id>");
					retSBuff.append("<msg_code><![CDATA[]]></msg_code>");
					retSBuff.append("<msg_descr><![CDATA[Transaction is saved]]></msg_descr>");
					retSBuff.append("<result><![CDATA[SUCCESS]]></result>");
				}
			}
			retSBuff.append("</Root>");
			
			retString = retSBuff.toString();
			
			System.out.println("Final retString["+retString+"]");
		}
		catch(Exception e)
		{
			isError = true;
			System.out.println("SCMWebServiceDao.addTransaction()["+e.getMessage()+"]");
			throw new ITMException (e);
		}
		finally
		{
			try
			{
				if(isError)
				{
					if( conn != null && !conn.isClosed() )
					{
						conn.rollback();
					}
				}
				if( conn != null && !conn.isClosed() && !isError)
				{
					if(isCommit)
					{
						conn.commit();
					}
					else
					{
						conn.rollback();
					}
				}
				
				if( conn != null && !conn.isClosed())
				{
					conn.close();
					conn = null;
				}
			}
			catch(SQLException se)
			{
				System.out.println("SCMWebServiceDao.addTransaction().finally["+se.getMessage()+"]");
			}
			
		}
		return retString;
	}
	
	private InitialContext getInitialContext() throws ITMException
	{
		InitialContext ctx = null;
		try
		{
			AppConnectParm appConnect = new AppConnectParm();
			ctx = new InitialContext( appConnect.getProperty() );
		}
		catch( ITMException itme )
		{
			System.out.println( "SCMWebServiceDao : getInitialContext : "+ itme.getMessage() );
			throw itme;
		}
		catch(Exception e)
		{
			System.out.println( "SCMWebServiceDao : getInitialContext : "+ e.getMessage() );
			throw new ITMException(e);
		}
		return ctx;
	}
}
