import { Component, OnInit, ViewChildren, QueryList, Input, Output, EventEmitter} from '@angular/core';
import { Review } from './review-manager/review.model';
import { ReviewEditor } from './review-manager';
import { AppState } from '../ecm-store/reducers';
import { Store } from '@ngrx/store';
import { Observable } from 'rxjs/Observable';
import { UserReviewService } from './ecm-user-review.service';
import { ReviewAction} from '../ecm-store/actions';

@Component({
  selector: 'user-review',
  templateUrl: './user-review.component.html',
  styleUrls: ['./user-review.component.css']
})
export class UserReviewComponent implements OnInit {

 @ViewChildren(ReviewEditor) reviewEditors: QueryList<ReviewEditor>;
 @Output() onCancel = new EventEmitter();
 

 @Input('editMode')  editMode : string = 'V';
 @Input('isDetailPage') isDetailPage: boolean = false;
 @Input('itemCode') itemCode;
    
//    reviewList: Review[]= [
//      new Review('Kabab Special','4','Awesome Taste...Good Quantity','By Bipinraj sartape','very nice to eat never eat such good food in my life i will come again and again'),
//      new Review('Stone Elephant','4','Awesome Product...Good Quality','By Marbel Decorations ','Superb product never seen such a superb marbel product the best part to decorate our house')
//    ];
 
    reviewList: Review = new Review('Kabab Special','4','Awesome Taste...Good Quantity','By Bipinraj sartape on Jan 01,2017','very nice to eat never eat such good food in my life i will come again and again,very nice to eat never eat such good food in my life i will come again and again,very nice to eat never eat such good food in my life i will come again and again','very nice to eat never eat such good food in my life i will come again and again');
   
     userReview : Observable<Review[]>;
    
    constructor(private store: Store<AppState>, private reviewActions: ReviewAction, private userReviewService:UserReviewService){}   
 
    ngOnInit() {
        console.log('isDetailPage',this.isDetailPage);
        localStorage.removeItem('editorId');
    }

    onSaveClick( userReview )
    {
        console.log('On Save Click ', userReview);
        
        this.userReviewService.submitReview(userReview);
        this.onCancel.emit();
    }
    
    deleteCartItem( userReview ) {
        console.log( "deleteCartItem Called" );
        this.store.dispatch(this.reviewActions.deleteReviews(userReview));       
    }

    onDiscard(editorId: string)
    {
        console.log('On Discard Click ', editorId);
        this.reviewEditors.forEach(reviewEditor => {
            if( editorId == reviewEditor.editorId ) {
                console.log(reviewEditor);
                reviewEditor.cancel();
            }
        });
        //TODO Call POST service (address)
    }
}
