package proteus.ecm.hibernate.bean;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Store;
import org.json.JSONObject;

@Indexed
@Entity
@Table(name = "ITEM_ATTRIBUTE")
@XmlRootElement(name = "ItemAttribute")
public class ItemAttribute implements java.io.Serializable 
{
	private static final long serialVersionUID = 1L;

	@Id
	@Field(store = Store.YES, analyze = Analyze.NO)
	@Column(name = "ATTRIB_CODE") // VARCHAR2(15) 
	private String attribCode;

	@Column(name = "DESCR")
	private String descr;

	@Column(name = "SH_DESCR")
	private String shDescr;

	public ItemAttribute() {
    	
    }
    
	public ItemAttribute(String attribCode, String descr, String shDescr) {
		this.attribCode = attribCode;
		this.descr = descr;
		this.shDescr = shDescr;
	}

	public String getAttribCode() {
		return attribCode;
	}

	@XmlElement
	public void setAttribCode(String attribCode) {
		this.attribCode = attribCode;
	}

	public String getDescr() {
		return descr;
	}

	@XmlElement
	public void setDescr(String descr) {
		this.descr = descr;
	}

	public String getShDescr() {
		return shDescr;
	}

	@XmlElement
	public void setShDescr(String shDescr) {
		this.shDescr = shDescr;
	}
	
	@Override
	public String toString() {
		return "\n ItemAtrribute.toString >> [" + new JSONObject(this).toString() + "]";
	}

}
