import { Injectable } from '@angular/core';
import { Http, Response, Headers, RequestOptions } from '@angular/http';
import { Observable } from 'rxjs/Observable';
import 'rxjs/add/operator/catch';
import 'rxjs/add/operator/map';
import { Store } from '@ngrx/store';

import {AppState} from '../ecm-store/reducers';
import { ProfileActions} from '../ecm-store/actions';
import { Profile } from './profile-manager/profile.model';
import { HostUrlService } from '../host-url.service';

@Injectable()
export class ProfileInfoService {

//  private userActionUrl = '/ecm/service/feeds/L2D01/profile';
  
  private userActionUrl = '/ecm/service/feeds';
    
  profile: Profile;  
    
  constructor(public hostUrlService : HostUrlService,private http: Http, private store: Store<AppState>, private profileActions: ProfileActions) { }
  
 
    fetchUserInfo(): Observable<Profile> {
        console.log( "fetchUserInfo Called" );
          let headers = new Headers( { 'Content-Type': 'application/json' });
          let options = new RequestOptions( { headers: headers });
          let siteCode = localStorage.getItem('SITE_CODE'); 
    
          return this.http.get(this.hostUrlService.hostUrl+this.userActionUrl + '/' + siteCode + '/profile', options)
          .map( (res) => this.extractData(res) )
          .catch(this.handleError);
      }
    
    updateUserInfo( userData ) {
        console.log( "StoreInUser Called" );
        console.log(JSON.stringify(userData));
        let headers = new Headers( { 'Content-Type': 'application/json' });
        let options = new RequestOptions( { headers: headers });
        let siteCode = localStorage.getItem('SITE_CODE'); 
        
       return this.http.post( this.hostUrlService.hostUrl+this.userActionUrl + '/' + siteCode + '/profile' , JSON.stringify(userData) , options)
            .map( (res) => this.extractData(res) );
    }
    
    
    private extractData(res: Response) {
        let respJson = res.json();
        console.log('extracData',respJson);
        if(respJson != null)
        {
            for( let key of Object.keys( respJson ) )
            {
                console.log( "getUserInfo Profile ==> key: " + key )
                let data = respJson[key];
                
                try 
                {
                    respJson[key] = JSON.parse( data );
                    console.log( "getUserInfo Profile try : " + respJson[key] );
                }
                catch(e)
                {
                    console.log( "getItemDetail Profile ==> key: " ,data, typeof data === 'object')
                    if(typeof data === 'object')
                        respJson[key] = this.formatObject(data);
                    else
                        respJson[key] = data;
                    console.log( "getUserInfo Profile catch : " + respJson[key] );
                }
            }
            console.log('extractData[' + JSON.stringify(respJson) + ']');
        }
        return respJson || { };
     }
    
    formatObject(respJson: any) {
        
        console.log('formatObject',respJson);
        if(respJson != null)
        {
            for( let key of Object.keys( respJson ) )
            {
                console.log( "formatObject Profile ==> key: " + key )
                let data = respJson[key];
                try 
                {
                    respJson[key] = JSON.parse( data );
                    console.log( "formatObject Profile try : " + respJson[key] );
                }
                catch(e)
                {
                    respJson[key] = data;
                    console.log( "formatObject Profile catch : " + respJson[key] );
                }
            }
            console.log('formatObject[' + JSON.stringify(respJson) + ']');
        }
        return respJson || { };
     }
    
    private handleError (error: Response | any) {
        // In a real world app, we might use a remote logging infrastructure
        let errMsg: string;
        if (error instanceof Response) {
          const body = error.json() || '';
          const err = body.error || JSON.stringify(body);
          errMsg = `${error.status} - ${error.statusText || ''} ${err}`;
        } else {
          errMsg = error.message ? error.message : error.toString();
        }
        console.error('Service handleError:' + errMsg);
        return Observable.throw(errMsg);
      }
      


}
