import {Injectable} from '@angular/core';
import {Action} from '@ngrx/store';

import {Card} from '../../user-card/card-manager/card.model';

@Injectable()
export class SavedCardAction {
    
    static LOAD_SAVED_CARDS = '[Cards] Load Saved Cards';
    loadSavedCards(): Action {
        return {
            type: SavedCardAction.LOAD_SAVED_CARDS
        };
    }
    
    static LOAD_SAVED_CARDS_SUCCESS = '[Cards] Load Saved Cards Success';
    loadSavedCardsSuccess(userCards): Action {
        console.log('card-action-loadSuccess',userCards);
        if(!userCards.length)
       {
            userCards = [];
        }
        return {
            type: SavedCardAction.LOAD_SAVED_CARDS_SUCCESS,
            payload: userCards
        };
        
    }
    
    static ADD_NEW_CARD = '[Cards] Add new Card';
    addNewCard(userCard): Action {
        return {
            type: SavedCardAction.ADD_NEW_CARD,
            payload: userCard
        };
    }

    static ADD_NEW_CARD_SUCCESS = '[Cards] Add new Card Success';
    addNewCardSuccess(userCard): Action {
        console.log('card-store: ',userCard);
        return {
            type: SavedCardAction.ADD_NEW_CARD_SUCCESS,
            payload: userCard
        };
    }
    
    static RESET_CARD = '[Cards] Reset Cards';
    resetCard(): Action {
        return {
            type: SavedCardAction.RESET_CARD
        };
    }
    
    
    static DELETE_CARD = '[Cards] Delete Cards';
    deleteCard(card): Action {
        return {
            type: SavedCardAction.DELETE_CARD,
            payload: card
        };
    }

    static DELETE_CARD_SUCCESS = '[Cards] Delete Cards Success';
    deleteCardSuccess(card): Action {
        return {
            type: SavedCardAction.DELETE_CARD_SUCCESS,
            payload: card
        };
    }
}
