/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpa.event.internal.jpa;

import java.util.HashMap;
import javax.persistence.PersistenceException;
import org.hibernate.jpa.event.spi.jpa.Callback;
import org.hibernate.jpa.event.spi.jpa.CallbackBuilder;
import org.hibernate.jpa.event.spi.jpa.CallbackRegistry;
import org.hibernate.jpa.event.spi.jpa.CallbackType;

public class CallbackRegistryImpl
implements CallbackRegistry,
CallbackBuilder.CallbackRegistrar {
    private HashMap<Class, Callback[]> preCreates = new HashMap();
    private HashMap<Class, Callback[]> postCreates = new HashMap();
    private HashMap<Class, Callback[]> preRemoves = new HashMap();
    private HashMap<Class, Callback[]> postRemoves = new HashMap();
    private HashMap<Class, Callback[]> preUpdates = new HashMap();
    private HashMap<Class, Callback[]> postUpdates = new HashMap();
    private HashMap<Class, Callback[]> postLoads = new HashMap();

    @Override
    public boolean hasRegisteredCallbacks(Class entityClass, CallbackType callbackType) {
        HashMap<Class, Callback[]> map = this.determineAppropriateCallbackMap(callbackType);
        return this.notEmpty(map.get(entityClass));
    }

    @Override
    public void registerCallbacks(Class entityClass, Callback[] callbacks) {
        if (callbacks == null || callbacks.length == 0) {
            return;
        }
        HashMap<Class, Callback[]> map = this.determineAppropriateCallbackMap(callbacks[0].getCallbackType());
        if (map.containsKey(entityClass)) {
            throw new PersistenceException("Error build callback listeners; entity [" + entityClass.getName() + " was already processed");
        }
        map.put(entityClass, callbacks);
    }

    @Override
    public void preCreate(Object bean) {
        this.callback(this.preCreates.get(bean.getClass()), bean);
    }

    private boolean notEmpty(Callback[] callbacks) {
        return callbacks != null && callbacks.length > 0;
    }

    @Override
    public void postCreate(Object bean) {
        this.callback(this.postCreates.get(bean.getClass()), bean);
    }

    @Override
    public boolean preUpdate(Object bean) {
        return this.callback(this.preUpdates.get(bean.getClass()), bean);
    }

    @Override
    public void postUpdate(Object bean) {
        this.callback(this.postUpdates.get(bean.getClass()), bean);
    }

    @Override
    public void preRemove(Object bean) {
        this.callback(this.preRemoves.get(bean.getClass()), bean);
    }

    @Override
    public void postRemove(Object bean) {
        this.callback(this.postRemoves.get(bean.getClass()), bean);
    }

    @Override
    public boolean postLoad(Object bean) {
        return this.callback(this.postLoads.get(bean.getClass()), bean);
    }

    private boolean callback(Callback[] callbacks, Object bean) {
        if (callbacks != null && callbacks.length != 0) {
            for (Callback callback : callbacks) {
                callback.performCallback(bean);
            }
            return true;
        }
        return false;
    }

    private HashMap<Class, Callback[]> determineAppropriateCallbackMap(CallbackType callbackType) {
        if (callbackType == CallbackType.PRE_PERSIST) {
            return this.preCreates;
        }
        if (callbackType == CallbackType.POST_PERSIST) {
            return this.postCreates;
        }
        if (callbackType == CallbackType.PRE_REMOVE) {
            return this.preRemoves;
        }
        if (callbackType == CallbackType.POST_REMOVE) {
            return this.postRemoves;
        }
        if (callbackType == CallbackType.PRE_UPDATE) {
            return this.preUpdates;
        }
        if (callbackType == CallbackType.POST_UPDATE) {
            return this.postUpdates;
        }
        if (callbackType == CallbackType.POST_LOAD) {
            return this.postLoads;
        }
        throw new PersistenceException("Unrecognized JPA callback type [" + (Object)((Object)callbackType) + "]");
    }

    public void release() {
        this.preCreates.clear();
        this.postCreates.clear();
        this.preRemoves.clear();
        this.postRemoves.clear();
        this.preUpdates.clear();
        this.postUpdates.clear();
        this.postLoads.clear();
    }

    @Override
    public boolean hasPostCreateCallbacks(Class entityClass) {
        return this.notEmpty(this.preCreates.get(entityClass));
    }

    @Override
    public boolean hasPostUpdateCallbacks(Class entityClass) {
        return this.notEmpty(this.postUpdates.get(entityClass));
    }

    @Override
    public boolean hasPostRemoveCallbacks(Class entityClass) {
        return this.notEmpty(this.postRemoves.get(entityClass));
    }

    @Override
    public boolean hasRegisteredCallbacks(Class entityClass, Class annotationClass) {
        HashMap<Class, Callback[]> map = this.determineAppropriateCallbackMap(this.toCallbackType(annotationClass));
        return map != null && map.containsKey(entityClass);
    }

    private CallbackType toCallbackType(Class annotationClass) {
        if (annotationClass == CallbackType.POST_LOAD.getCallbackAnnotation()) {
            return CallbackType.POST_LOAD;
        }
        if (annotationClass == CallbackType.PRE_PERSIST.getCallbackAnnotation()) {
            return CallbackType.PRE_PERSIST;
        }
        if (annotationClass == CallbackType.POST_PERSIST.getCallbackAnnotation()) {
            return CallbackType.POST_PERSIST;
        }
        if (annotationClass == CallbackType.PRE_UPDATE.getCallbackAnnotation()) {
            return CallbackType.PRE_UPDATE;
        }
        if (annotationClass == CallbackType.POST_UPDATE.getCallbackAnnotation()) {
            return CallbackType.POST_UPDATE;
        }
        if (annotationClass == CallbackType.PRE_REMOVE.getCallbackAnnotation()) {
            return CallbackType.PRE_REMOVE;
        }
        if (annotationClass == CallbackType.POST_REMOVE.getCallbackAnnotation()) {
            return CallbackType.POST_REMOVE;
        }
        throw new PersistenceException("Unrecognized JPA callback annotation [" + annotationClass + "]");
    }
}

