/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.store.blockcache;

import java.net.URL;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.core.SolrInfoMBean;
import org.apache.solr.search.SolrCacheBase;

public class Metrics
extends SolrCacheBase
implements SolrInfoMBean {
    public AtomicLong blockCacheHit = new AtomicLong(0L);
    public AtomicLong blockCacheMiss = new AtomicLong(0L);
    public AtomicLong blockCacheEviction = new AtomicLong(0L);
    public AtomicLong blockCacheSize = new AtomicLong(0L);
    public AtomicLong rowReads = new AtomicLong(0L);
    public AtomicLong rowWrites = new AtomicLong(0L);
    public AtomicLong recordReads = new AtomicLong(0L);
    public AtomicLong recordWrites = new AtomicLong(0L);
    public AtomicLong queriesExternal = new AtomicLong(0L);
    public AtomicLong queriesInternal = new AtomicLong(0L);
    public AtomicLong shardBuffercacheAllocate = new AtomicLong(0L);
    public AtomicLong shardBuffercacheLost = new AtomicLong(0L);
    public Map<String, MethodCall> methodCalls = new ConcurrentHashMap<String, MethodCall>();
    public AtomicLong tableCount = new AtomicLong(0L);
    public AtomicLong rowCount = new AtomicLong(0L);
    public AtomicLong recordCount = new AtomicLong(0L);
    public AtomicLong indexCount = new AtomicLong(0L);
    public AtomicLong indexMemoryUsage = new AtomicLong(0L);
    public AtomicLong segmentCount = new AtomicLong(0L);
    private long previous = System.nanoTime();

    public static void main(String[] args) throws InterruptedException {
        Metrics metrics = new Metrics();
        MethodCall methodCall = new MethodCall();
        metrics.methodCalls.put("test", methodCall);
        for (int i = 0; i < 100; ++i) {
            metrics.blockCacheHit.incrementAndGet();
            metrics.blockCacheMiss.incrementAndGet();
            methodCall.invokes.incrementAndGet();
            methodCall.times.addAndGet(56000000L);
            Thread.sleep(500L);
        }
    }

    public NamedList<Number> getStatistics() {
        SimpleOrderedMap stats = new SimpleOrderedMap(21);
        long now = System.nanoTime();
        float seconds = (float)(now - this.previous) / 1.0E9f;
        long hits = this.blockCacheHit.getAndSet(0L);
        long lookups = hits + this.blockCacheMiss.getAndSet(0L);
        stats.add("lookups", (Object)Float.valueOf(this.getPerSecond(lookups, seconds)));
        stats.add("hits", (Object)Float.valueOf(this.getPerSecond(hits, seconds)));
        stats.add("hitratio", (Object)Float.valueOf(Metrics.calcHitRatio(lookups, hits)));
        stats.add("evictions", (Object)Float.valueOf(this.getPerSecond(this.blockCacheEviction.getAndSet(0L), seconds)));
        stats.add("size", (Object)this.blockCacheSize.get());
        stats.add("row.reads", (Object)Float.valueOf(this.getPerSecond(this.rowReads.getAndSet(0L), seconds)));
        stats.add("row.writes", (Object)Float.valueOf(this.getPerSecond(this.rowWrites.getAndSet(0L), seconds)));
        stats.add("record.reads", (Object)Float.valueOf(this.getPerSecond(this.recordReads.getAndSet(0L), seconds)));
        stats.add("record.writes", (Object)Float.valueOf(this.getPerSecond(this.recordWrites.getAndSet(0L), seconds)));
        stats.add("query.external", (Object)Float.valueOf(this.getPerSecond(this.queriesExternal.getAndSet(0L), seconds)));
        stats.add("query.internal", (Object)Float.valueOf(this.getPerSecond(this.queriesInternal.getAndSet(0L), seconds)));
        stats.add("buffercache.allocations", (Object)Float.valueOf(this.getPerSecond(this.shardBuffercacheAllocate.getAndSet(0L), seconds)));
        stats.add("buffercache.lost", (Object)Float.valueOf(this.getPerSecond(this.shardBuffercacheLost.getAndSet(0L), seconds)));
        for (Map.Entry<String, MethodCall> entry : this.methodCalls.entrySet()) {
            String key = entry.getKey();
            MethodCall value = entry.getValue();
            long invokes = value.invokes.getAndSet(0L);
            long times = value.times.getAndSet(0L);
            float avgTimes = (float)times / (float)invokes / 1.0E9f;
            stats.add("methodcalls." + key + ".count", (Object)Float.valueOf(this.getPerSecond(invokes, seconds)));
            stats.add("methodcalls." + key + ".time", (Object)Float.valueOf(avgTimes));
        }
        stats.add("tables", (Object)this.tableCount.get());
        stats.add("rows", (Object)this.rowCount.get());
        stats.add("records", (Object)this.recordCount.get());
        stats.add("index.count", (Object)this.indexCount.get());
        stats.add("index.memoryusage", (Object)this.indexMemoryUsage.get());
        stats.add("index.segments", (Object)this.segmentCount.get());
        this.previous = now;
        return stats;
    }

    private float getPerSecond(long value, float seconds) {
        return (float)value / seconds;
    }

    @Override
    public String getName() {
        return "HdfsBlockCache";
    }

    @Override
    public String getDescription() {
        return "Provides metrics for the HdfsDirectoryFactory BlockCache.";
    }

    @Override
    public String getSource() {
        return null;
    }

    @Override
    public URL[] getDocs() {
        return null;
    }

    public static class MethodCall {
        public AtomicLong invokes = new AtomicLong();
        public AtomicLong times = new AtomicLong();
    }
}

