/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopDocsCollector;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.FixedBitSet;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.handler.component.MergeStrategy;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrRequestInfo;
import org.apache.solr.search.QParser;
import org.apache.solr.search.QParserPlugin;
import org.apache.solr.search.RankQuery;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.search.SyntaxError;

public class ExportQParserPlugin
extends QParserPlugin {
    public static final String NAME = "xport";

    @Override
    public void init(NamedList namedList) {
    }

    @Override
    public QParser createParser(String qstr, SolrParams localParams, SolrParams params, SolrQueryRequest request) {
        return new ExportQParser(qstr, localParams, params, request);
    }

    private class ExportCollector
    extends TopDocsCollector {
        private FixedBitSet[] sets;

        public ExportCollector(FixedBitSet[] sets) {
            super(null);
            this.sets = sets;
        }

        public LeafCollector getLeafCollector(LeafReaderContext context) throws IOException {
            FixedBitSet set;
            this.sets[context.ord] = set = new FixedBitSet(context.reader().maxDoc());
            return new LeafCollector(){

                public void setScorer(Scorer scorer) throws IOException {
                }

                public void collect(int docId) throws IOException {
                    ++ExportCollector.this.totalHits;
                    set.set(docId);
                }
            };
        }

        private ScoreDoc[] getScoreDocs(int howMany) {
            ScoreDoc[] docs = new ScoreDoc[Math.min(this.totalHits, howMany)];
            for (int i = 0; i < docs.length; ++i) {
                docs[i] = new ScoreDoc(i, 0.0f);
            }
            return docs;
        }

        public TopDocs topDocs(int start, int howMany) {
            SolrRequestInfo info = SolrRequestInfo.getRequestInfo();
            SolrQueryRequest req = null;
            if (info != null && (req = info.getReq()) != null) {
                Map<Object, Object> context = req.getContext();
                context.put("export", this.sets);
                context.put("totalHits", this.totalHits);
            }
            ScoreDoc[] scoreDocs = this.getScoreDocs(howMany);
            assert (scoreDocs.length <= this.totalHits);
            return new TopDocs(this.totalHits, scoreDocs, 0.0f);
        }

        public boolean needsScores() {
            return true;
        }
    }

    public class ExportQuery
    extends RankQuery {
        private int leafCount;
        private Query mainQuery;
        private Object id;

        public Query clone() {
            ExportQuery clone = new ExportQuery();
            clone.id = this.id;
            clone.leafCount = this.leafCount;
            clone.mainQuery = this.mainQuery;
            return clone;
        }

        @Override
        public RankQuery wrap(Query mainQuery) {
            this.mainQuery = mainQuery;
            return this;
        }

        @Override
        public MergeStrategy getMergeStrategy() {
            return null;
        }

        public Weight createWeight(IndexSearcher searcher) throws IOException {
            return this.mainQuery.createWeight(searcher, true);
        }

        public Query rewrite(IndexReader reader) throws IOException {
            return this.mainQuery.rewrite(reader);
        }

        @Override
        public TopDocsCollector getTopDocsCollector(int len, SolrIndexSearcher.QueryCommand cmd, IndexSearcher searcher) throws IOException {
            FixedBitSet[] sets = new FixedBitSet[this.leafCount];
            return new ExportCollector(sets);
        }

        public int hashCode() {
            return this.id.hashCode() + (int)this.getBoost();
        }

        public boolean equals(Object o) {
            if (o instanceof ExportQuery) {
                ExportQuery q = (ExportQuery)o;
                return this.id == q.id && this.getBoost() == q.getBoost();
            }
            return false;
        }

        @Override
        public String toString(String s) {
            return s;
        }

        public ExportQuery() {
        }

        public ExportQuery(SolrParams localParams, SolrParams params, SolrQueryRequest request) throws IOException {
            this.leafCount = request.getSearcher().getTopReaderContext().leaves().size();
            this.id = new Object();
        }
    }

    public class ExportQParser
    extends QParser {
        public ExportQParser(String qstr, SolrParams localParams, SolrParams params, SolrQueryRequest request) {
            super(qstr, localParams, params, request);
        }

        @Override
        public Query parse() throws SyntaxError {
            try {
                return new ExportQuery(this.localParams, this.params, this.req);
            }
            catch (Exception e) {
                throw new SyntaxError(e.getMessage(), e);
            }
        }
    }
}

