/********************************************************
	Title : Sales Budget Customer Plan[D14GSUN005]
	Date  : 15/01/2015
	Developer: Vishakha Dhoble
 ********************************************************/
/* 
 Window Name : w_sales_budget_cust
 */
package ibase.webitm.ejb.fin;

import ibase.system.config.ConnDriver;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ActionHandlerEJB;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.sys.UtilMethods;
import ibase.webitm.utility.ITMException;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import javax.ejb.Stateless;


@Stateless
// added for ejb3
public class SalesBudgetCustConf extends ActionHandlerEJB implements
		SalesBudgetCustConfLocal, SalesBudgetCustConfRemote {
	E12GenericUtility GenericUtilityObj = new E12GenericUtility();
	UtilMethods utilMethods = UtilMethods.getInstance();
	boolean isError = false;

	public String confirm(String tranId, String xtraParams, String forcedFlag)
			throws RemoteException, ITMException {
		System.out
				.println("--------------confirm method of SalesBudgetCustConf ------------- : ");
		String retString = "";
		try {

			retString = confirmSalesBudgetCust(tranId, xtraParams, forcedFlag);

		} catch (Exception e) {
			System.out.println("Exception :SalesBudgetCustConf :confirm():"
					+ e.getMessage() + ":");
			retString = GenericUtilityObj.createErrorString(e);
			e.printStackTrace();
		}

		return retString;
	}

	public String confirmSalesBudgetCust(String tranId, String xtraParams,
			String forcedFlag) throws ITMException {
		isError = false;

		String sql = "";

		Connection conn = null;
		PreparedStatement pstmt = null;
		ITMDBAccessEJB itmdbAccess = null;
		String xtraParam = xtraParams;
		String forcedF = forcedFlag;
		String errString = null;
		ResultSet rs = null;
		ibase.webitm.utility.GenericUtility genericUtility = null;
		System.out.println("Confirm Action Called:::");
		String confirmed = "";
		String approverCode = "";
		int rowcnt = 0;
		try {
			itmdbAccess = new ITMDBAccessEJB();
			genericUtility = ibase.webitm.utility.GenericUtility.getInstance();
			ConnDriver connDriver = null;
			connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("DriverITM");
			conn.setAutoCommit(false);
			connDriver = null;

			sql = "select confirmed from sales_budget_cust where tran_id = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, tranId);
			rs = pstmt.executeQuery();
			if (rs.next()) {
				confirmed = rs.getString(1) == null ? "N" : rs.getString(1);
			}
			if (pstmt != null) {
				pstmt.close();
				pstmt = null;
			}
			if (rs != null) {
				rs.close();
				rs = null;
			}

			if (confirmed != null && confirmed.equalsIgnoreCase("Y")) {
				// if already confirm then show error
				errString = itmdbAccess.getErrorString("", "VTSBPACONF", "", "",conn);
				return errString;
			}
			if (errString == null || errString.trim().length() == 0) {
				approverCode = genericUtility.getValueFromXTRA_PARAMS(xtraParam, "loginEmpCode");
				System.out.println("approverCode-->[" + approverCode + "]");
				java.util.Date toDay = new java.util.Date();
				java.sql.Timestamp tDay = null;
				tDay = new java.sql.Timestamp(toDay.getTime());
				sql = "update sales_budget_cust set CONFIRMED = ?,CONF_DATE = ?,EMP_CODE__APRV = ? where tran_id = ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, "Y");
				pstmt.setTimestamp(2, tDay);
				pstmt.setString(3, approverCode);
				pstmt.setString(4, tranId);

				rowcnt = pstmt.executeUpdate();
				pstmt.close();
				pstmt = null;
				if (rowcnt > 0) {

					errString = itmdbAccess.getErrorString("", "VTCONFIRM", "","", conn);
					System.out.println("Sales Budget Confirmed Successfully.......");

				} else {

					errString = itmdbAccess.getErrorString("", "STKVNCONF", "","", conn);
					System.out.println("Sales Budget not Confirmed......");

				}
			}
		} catch (Exception e) {
			e.printStackTrace();
			System.out.println("sales budget cust.......Rollback due to Exception");
			try {
				conn.rollback();
			} catch (Exception e1) {
				System.out.println("Exception while rollbacking.......");
			}
			throw new ITMException(e);
		} finally {
			System.out.println("in finally..............");

			try {
				if (rowcnt > 0) {
					conn.commit();
				}
				if (rs != null) {
					rs.close();
					rs = null;
				}
				if (pstmt != null) {
					pstmt.close();
					pstmt = null;
				}
				if (conn != null) {
					conn.close();
					conn = null;
				}
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
		return errString;
	}
	public String checkNull(String input) {
		if (input == null) {
			input = "";
		}
		return input.trim();
	}

}
