<?xml version='1.0' encoding='UTF-8'?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html"/>
<xsl:decimal-format NaN="0"/>

<xsl:template match="/">

<html>
<head>
<meta http-equiv="content-type" content="text/html; charset=UTF-8" />
</head>

<script type="text/javascript" src="/ibase/webitm/js/RequirementWizard.js"></script>

<script language="JavaScript" type="text/javascript">
<![CDATA[
   var maxId = 0;
    
    function resetOrderOfVisit(obj)
    {
	for(cnt=1;cnt <=maxId;cnt++)
	{
		var selBoxID ="Detail2."+cnt+"."+ "selectbox";
		var visitOrderID ="Detail2."+cnt+"."+ "order_of_visit";
		if ( document.getElementById(selBoxID) != null && document.getElementById(selBoxID).value=='true' )
		{
			document.getElementById(selBoxID).value = false;
			document.getElementById(selBoxID).checked = false;
			
			if(document.getElementById(visitOrderID) != null)
			{
			      document.getElementById(visitOrderID).value = "";
			}
		}
		
	}
	orderVisit = 0;
    } 
  
    
]]>

</script>
<body>


<style type="text/css">

.tableClass
{margin-left:10px;margin-top:10px}

.tableClass_rep
<!--{margin-left:0px;width:900px;}-->
{margin-left:0px;width:1500px;}


.header_td
{border:inset 0;background:#FFCCCC;font-family:verdana;font-size:9pt}

.reset
{border:inset 1;font-family:verdana;font-size:9pt; font-weight:bold}

.input_editable
{border:inset 2;color:#102132;background:#D7E5F9;text-align:left;font-family:verdana;font-size:9pt}

.input_num_editable
{border:inset 2;color:#102132;background:#D7E5F9;text-align:right;font-family:verdana;font-size:9pt}

.td_leftAlign
{background:#D7E5F9;text-align:left;font-family:verdana;font-size:9pt}

.td_rightAlign
{background:#D7E5F9;text-align:right;font-family:verdana;font-size:9pt}
.style1
{border:inset 0;background:#FFCCCC;font-family:verdana;font-size:9pt ;width	: 120px;
}

</style>

<form name = "Wizard_Travel" METHOD="post" ACTION="/ibase/ITMWizardHandlerServlet" onSubmit="javascript:return validatePlace('2');">
	<table id="travelTable" width="100PX" class="tableClass" border="0" cellspacing="1" cellpadding="1">
		<xsl:for-each select="//Detail2">
			<xsl:variable name="dbID"><xsl:value-of select="@domID"/></xsl:variable>
			<SCRIPT>
				<![CDATA[ 
				var detCnt ;  
				detCnt ="]]><xsl:value-of select="$dbID"/><![CDATA[";
					maxId= detCnt; 												
				]]>
			</SCRIPT>
		</xsl:for-each>
		<tr>
			<td width="1PX" class="header_td" nowrap="true" valign="bottom">
			<!-- <input  type="checkbox"  name="Detail2.selectAllbox" id="Detail2.selectAllbox" onClick="selectAllbox()"/> -->
			</td>		
			<td width="5PX" class="header_td" nowrap="true" valign="bottom">
				<strong>Site Code</strong>
			</td>
			<td width="15PX" class="header_td" nowrap="true" valign="bottom" style="width:125px">
				<strong>Item Code</strong>
			</td>
			<td  width="50px" class="header_td" nowrap="true" valign="bottom" >
				<strong>Item Description</strong>
			</td>
			<td width="5PX" class="header_td" nowrap="true" valign="bottom">
				<strong>Unit</strong>
			</td>
			<td width="10PX" class="header_td" nowrap="true" valign="bottom">
				<strong>Bom Code</strong>
			</td>	
			<td width="10PX" class="header_td" nowrap="true" valign="bottom">
				<strong>No.of Batch</strong>
			</td>
			<td width="10PX" class="header_td" nowrap="true" valign="bottom">
				<strong>Quantity</strong>
			</td>
			<!-- <td width="10PX" class="header_td" nowrap="true" valign="bottom">
				<strong>Mps Order</strong>
			</td> -->
				
		</tr>
		
		<xsl:for-each select="//Detail2">				
		<xsl:variable name="site_code"><xsl:value-of select="site_code"/></xsl:variable>
		<xsl:variable name="item_code"><xsl:value-of select="item_code"/></xsl:variable>
		<xsl:variable name="item_descr"><xsl:value-of select="item_descr"/></xsl:variable>   
		<xsl:variable name="unit"><xsl:value-of select="unit"/></xsl:variable>
		<xsl:variable name="bom_code"><xsl:value-of select="bom_code"/></xsl:variable>
		<xsl:variable name="no_of_batch"><xsl:value-of select="no_of_batch"/></xsl:variable>  
		<xsl:variable name="quantity"><xsl:value-of select="quantity"/></xsl:variable>	
		<xsl:variable name="mpsorder"><xsl:value-of select="mpsorder"/></xsl:variable> 
		<xsl:variable name="batch_qty"><xsl:value-of select="batch_qty"/></xsl:variable>   
		<xsl:variable name="dbID"><xsl:value-of select="@domID"/></xsl:variable>
		<xsl:variable name="chkbox"><xsl:value-of select="@selected"/></xsl:variable>
	    <tr>
				
			<td class="td_leftAlign">
			        <xsl:choose>
				<xsl:when test="$chkbox ='Y'">
					<script>
						<![CDATA[ orderVisit = parseInt("]]> <xsl:value-of select="order_of_visit"/><![CDATA[");]]>
					</script>
					<input  type="checkbox"  name="Detail2.{normalize-space($dbID)}.selectbox" id="Detail2.{normalize-space($dbID)}.selectbox"  value="true" checked="Y" onClick="setCheckedPlace(this, '{normalize-space($dbID)}' )"/>
				</xsl:when>	
				<xsl:otherwise>
					<input  type="checkbox"  name="Detail2.{normalize-space($dbID)}.selectbox" id="Detail2.{normalize-space($dbID)}.selectbox" value="false" onClick="setCheckedPlace(this, '{normalize-space($dbID)}' )"/>
				</xsl:otherwise>
				</xsl:choose>
			</td>
			
			
			<td class="td_leftAlign" align="left">
				<input  type="text" name="Detail2.{normalize-space($dbID)}.site_code" id="Detail2.{normalize-space($dbID)}.site_code" value="{$site_code}" size="06"  ISCHANGED="true" readonly="readonly" tabindex="10" onFocus="blur();"/>
			</td>
			
			<td class="td_leftAlign"  align="left" >
				<input  type="text"   name="Detail2.{normalize-space($dbID)}.item_code" id="Detail2.{normalize-space($dbID)}.item_code" value="{$item_code}" size="10" ISCHANGED="true"  onblur="return upperCase(this.id)"  />
				
				 <a href="javascript:callPopHelpJSP( '{normalize-space($dbID)}','{normalize-space($item_code)}','{normalize-space($site_code)}' );"> <img src="/ibase/webitm/images/Standard/e12_pophelp_16.jpg" border="0"/> </a>
			</td>

			<td class="td_leftAlign"  align="left" >
				<input  type="text"  name="Detail2.{normalize-space($dbID)}.item_descr" id="Detail2.{normalize-space($dbID)}.item_descr" value="{$item_descr}" size="20" ISCHANGED="true" readonly="readonly" tabindex="10" onFocus="blur();"/>
			</td>
			<td class="td_leftAlign"  align="left" >
				<input  type="text"  name="Detail2.{normalize-space($dbID)}.unit" id="Detail2.{normalize-space($dbID)}.unit" value="{$unit}" size="5" ISCHANGED="true" readonly="readonly" tabindex="10" onFocus="blur();"/>
				
			</td>
			<td class="td_leftAlign"  align="left" >
				<input  type="text"  name="Detail2.{normalize-space($dbID)}.bom_code" id="Detail2.{normalize-space($dbID)}.bom_code" value="{$bom_code}" size="10" ISCHANGED="true" readonly="readonly" tabindex="10" onFocus="blur();"/>
			</td>
			<td class="td_rightAlign" align="left" >
			<!-- <xsl:choose>
				<xsl:when test="no_of_batch ='0'">
				<input  type="text"   style="text-align:right" name="Detail2.{normalize-space($dbID)}.no_of_batch" id="Detail2.{normalize-space($dbID)}.no_of_batch" value="{$no_of_batch}" size="10" ISCHANGED="true"  />
				</xsl:when>
				<xsl:otherwise>
				<input  type="text"   style="text-align:right" name="Detail2.{normalize-space($dbID)}.no_of_batch" id="Detail2.{normalize-space($dbID)}.no_of_batch" value="{$no_of_batch}" size="10" ISCHANGED="true" readonly="readonly" onFocus="blur();" />
				</xsl:otherwise>
			</xsl:choose> -->
			<input  type="text"   style="text-align:right" name="Detail2.{normalize-space($dbID)}.no_of_batch" id="Detail2.{normalize-space($dbID)}.no_of_batch" value="{$no_of_batch}" size="10" ISCHANGED="true" readonly="readonly" onFocus="blur();" />
			</td>
			<td class="td_rightAlign" align="left">
				<!-- <input  type="text" style="text-align:right" name="Detail2.{normalize-space($dbID)}.quantity" id="Detail2.{normalize-space($dbID)}.quantity" value="{$quantity}" size="10" ISCHANGED="true"  onkeydown="isNumberKey(event)"/> -->
				<input  type="text" style="text-align:right" name="Detail2.{normalize-space($dbID)}.quantity" id="Detail2.{normalize-space($dbID)}.quantity" value="{$quantity}" size="10" ISCHANGED="true" readonly="readonly" onFocus="blur();" onkeydown="isNumberKey(event)"/>
			</td>
			<td class="td_leftAlign" align="left">
				<input  type="hidden"  name="Detail2.{normalize-space($dbID)}.mpsorder" id="Detail2.{normalize-space($dbID)}.mpsorder" value="{$mpsorder}" size="10" ISCHANGED="true" />
			</td> 
			<td class="td_leftAlign" align="left">
				<input  type="hidden"  name="Detail2.{normalize-space($dbID)}.batch_qty" id="Detail2.{normalize-space($dbID)}.batch_qty" value="{$batch_qty}" size="10" ISCHANGED="true" />
			</td>
		   </tr> 
		    
                  </xsl:for-each>
	</table>
	<div id="repeatPlacesDiv" style="margin-left:10px"></div>
	<table>
		<tr>
		    <td>
			<input  type="hidden"  value="2" name="FORM_NO" ID="FORM_NO" />
			<input  type="hidden"  value="requirement" name="OBJ_NAME" />
			<input  type="hidden"  value="" name="action" id="action" />

			<input type="submit" style="cursor:hand" value="Previous" id="Previous" name="Previous" title='' onclick="javascript:setActionVal('previous')"/>
			<input type="submit" style="cursor:hand" value="Next" id="Next" name="Next" title='' onclick="return setActionValPrc('next')"/>
			<input type="button" style="cursor:hand" class="tableClass" value="Add" onclick="addRow('travelTable')" />
			<input type="button" style="cursor:hand" class="tableClass" value="Delete" onclick="deleteRowRecord('travelTable')" /> 
			
			
		    </td>
                </tr>
	</table>
	<table id="errorTravelTable" width="85%" class="tableClass" border="0" cellspacing="1" cellpadding="1">
	<xsl:for-each select="//error">
			<xsl:variable name="message"><xsl:value-of select="message"/></xsl:variable>
			<xsl:variable name="description"><xsl:value-of select="description"/></xsl:variable>
			<xsl:variable name="type"><xsl:value-of select="type"/></xsl:variable>
			<xsl:variable name="dbID"><xsl:value-of select="@domId"/></xsl:variable>  
			<xsl:variable name="column_name"><xsl:value-of select="@column_name"/></xsl:variable> 
			<xsl:if test="position() = 1">
					<tr>	
						<td class="td_leftAlign" nowrap="true" valign="bottom">
							Message :
						</td>
						<td class="td_leftAlign" nowrap="true" valign="bottom">
							Description :
						</td>
					</tr>
			</xsl:if>
			<tr>
				<td class="td_leftAlign" nowrap="true">
					<xsl:value-of select="message"/>
				</td>
				<td class="td_leftAlign" nowrap="true">
					<xsl:value-of select="description"/>
				</td>
			</tr>
	</xsl:for-each>
	<xsl:for-each select="//error">
			<xsl:variable name="type"><xsl:value-of select="type"/></xsl:variable>
			<xsl:if test="position() = 1">
				<xsl:if test="$type = 'W'">
				<tr>
					<td class="td_leftAlign" nowrap="true" valign="bottom">
						Override Warnings :
					</td>
					<td class="td_leftAlign" nowrap="true" valign="bottom">
						<input  type="checkbox"  name="forceSave"  value="false" onClick="javascript:setChecked(this)"/>
					</td>
				</tr>
				</xsl:if>
			</xsl:if>	
	</xsl:for-each>
	</table>
						
</form>
</body>

</html>
</xsl:template>
</xsl:stylesheet>
