package ibase.webitm.util.gst;

import java.io.IOException;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;

import ibase.webitm.bean.gst.GSTR2;

public class GSTR2Serailizer extends JsonSerializer<GSTR2> {
    @Override
    public void serialize(GSTR2 gstr2, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonProcessingException 
    {
        jsonGenerator.writeStartObject();
        jsonGenerator.writeStringField("gstin", gstr2.gstin);
        jsonGenerator.writeStringField("fp", gstr2.financialPeriod);
        if(gstr2.b2b != null)
        {
        	jsonGenerator.writeObjectField("b2b", gstr2.b2b);
        } 
        if(gstr2.b2bur != null)
        {
        	jsonGenerator.writeObjectField("b2bur", gstr2.b2bur);
        }
        if(gstr2.cdnr != null)
        {
        	jsonGenerator.writeObjectField("cdn", gstr2.cdnr);
        }
        if(gstr2.hsn != null)
        {
        	jsonGenerator.writeObjectField("hsnsum", gstr2.hsn);
        }
        if(gstr2.impg != null)
        {
        	jsonGenerator.writeObjectField("imp_g", gstr2.impg);
        }
        if(gstr2.imps != null)
        {
        	jsonGenerator.writeObjectField("imp_s", gstr2.imps);
        }
        if(gstr2.nil != null)
        {
        	jsonGenerator.writeObjectField("nil_supplies", gstr2.nil);
        }
        if(gstr2.txi != null)
        {
        	jsonGenerator.writeObjectField("txi", gstr2.txi);
        }
        if(gstr2.txpd != null)
        {
        	jsonGenerator.writeObjectField("txpd", gstr2.txpd);
        }
        if(gstr2.itcReversal != null)
        {
        	jsonGenerator.writeObjectField("itc_rvsl", gstr2.itcReversal);
        }
        if(gstr2.cdnur != null)
        {
        	jsonGenerator.writeObjectField("cdnur", gstr2.cdnur);
        }
        jsonGenerator.writeEndObject();
    }
}
