/********************************************************
Title 	 : BankGauranteeConf [F15DSUN018]
Date  	 : 23/JUL/15
Developer: Pankaj R.
********************************************************/
package ibase.webitm.ejb.fin.adv;

import java.rmi.RemoteException;
import java.sql.*;
import java.text.SimpleDateFormat;

import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.*;
import ibase.system.config.*;
import javax.ejb.Stateless;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.dis.DistCommon;
//import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;

@Stateless
public class BankGuaranteeConf extends ActionHandlerEJB implements BankGuaranteeConfLocal,BankGuaranteeConfRemote 
{
	public String confirm(String tranId,String xtraParams,String forcedFlag) throws RemoteException,ITMException
	{
		System.out.println("Inside Confirm Method");
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String sql = "",sql1="";
		String siteCode="";
		ConnDriver connDriver = null;
		String loginEmpCode = "";
		String confirm = "",empCodeAprv="" ;
		String errString = ""; 
		int updateCount=0;
		ValidatorEJB validatorEJB = null;
		ITMDBAccessEJB itmDBAccessEJB = null;
		SimpleDateFormat sdf=null;
		Timestamp timestamp=null;
		E12GenericUtility genericUtility = new E12GenericUtility();
		try
		{
			itmDBAccessEJB = new ITMDBAccessEJB();
			validatorEJB = new ValidatorEJB();
			connDriver = new ConnDriver();
			//Changes and Commented By Bhushan on 06-06-2016 :START
//conn = connDriver.getConnectDB("DriverITM");
conn = getConnection();
//Changes and Commented By Bhushan on 06-06-2016 :END
			connDriver = null;
			conn.setAutoCommit(false);
//			ibase.utility.E12GenericUtility genericUtility = null;
//			genericUtility = new ibase.utility.E12GenericUtility();
			
			empCodeAprv = validatorEJB.getValueFromXTRA_PARAMS(xtraParams, "loginEmpCode");
			System.out.println("empCodeAprv@@@@@@@"+empCodeAprv);
			
			sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			timestamp = new Timestamp(System.currentTimeMillis());
			System.out.println("TimeStamp>>>>>>>>>>"+timestamp);
			
			sql = "select confirmed from lc_voucher where tran_id = ? and tran_type='B'";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,tranId);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				confirm = checkNull(rs.getString("confirmed"));
			}
			System.out.println("Confirm@@@@@@@@"+confirm);
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
			
			if((confirm==null || confirm.length()<=0))
			{
				System.out.println("Confirm is null");
				errString = itmDBAccessEJB.getErrorString("", "VMTYPE", "","", conn);
				return errString;
			}

			if(confirm != null && confirm.equalsIgnoreCase("Y"))
			{
				System.out.println("This tansaction is  already confirmed");
				errString = itmDBAccessEJB.getErrorString("","VTINVCONF2","","",conn);
				return errString;
			}
			else /*(confirm != null  && confirm.equalsIgnoreCase("N"))*/
			{
				sql = "update lc_voucher set confirmed = 'Y', conf_date = ?,emp_code__aprv = ? where tran_id = ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setTimestamp(1, timestamp);
				pstmt.setString(2, empCodeAprv);
				pstmt.setString(3, tranId);
				updateCount = pstmt.executeUpdate();
				System.out.println("no of row update: "+updateCount);
				System.out.println("Date>>>>>"+timestamp);
				System.out.println("Employee Approved Code>>> "+empCodeAprv);
				System.out.println("tranId@@@@@@@@@"+tranId);
				pstmt.close();
				pstmt = null;
							
				if(updateCount > 0) 
				{
					System.out.println(">>The selected transaction is confirmed");
					errString = itmDBAccessEJB.getErrorString("","VTCONSUCF","","",conn);
				}	
			}
		} 
		catch(Exception e)
		{
			System.out.println("Exception ::"+e.getMessage());
			errString = genericUtility.createErrorString(e);
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				System.out.println(">>>>>In finally errString:"+errString);
				if(errString != null && errString.trim().length() > 0)
				{
					if(errString.indexOf("VTCONSUCF") > -1)
					{
						conn.commit();
						System.out.println("Commit Completed");
					}
					else
					{
						conn.rollback();
					}
				}
				if(rs != null)
				{	
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				conn.close();
			}
			catch(Exception e)
			{
				System.out.println("Exception : "+e);e.printStackTrace();
				throw new ITMException(e);
			}
		}
		return errString;

	}//end of confirm method
	private String checkNull( String input )
	{
		if (input == null )
		{
			input = "";
		}
		return input;
	}//end of checkNull
}//end of class

