/*
 * Decompiled with CFR 0.152.
 */
package jxl.biff.formula;

import jxl.biff.DoubleHelper;
import jxl.biff.formula.NumberValue;
import jxl.biff.formula.ParsedThing;
import jxl.biff.formula.Token;
import jxl.common.Logger;

class DoubleValue
extends NumberValue
implements ParsedThing {
    private static Logger logger = Logger.getLogger(DoubleValue.class);
    private double value;

    public DoubleValue() {
    }

    DoubleValue(double v) {
        this.value = v;
    }

    public DoubleValue(String s) {
        try {
            this.value = Double.parseDouble(s);
        }
        catch (NumberFormatException e) {
            logger.warn(e, e);
            this.value = 0.0;
        }
    }

    @Override
    public int read(byte[] data, int pos) {
        this.value = DoubleHelper.getIEEEDouble(data, pos);
        return 8;
    }

    @Override
    byte[] getBytes() {
        byte[] data = new byte[9];
        data[0] = Token.DOUBLE.getCode();
        DoubleHelper.getIEEEBytes(this.value, data, 1);
        return data;
    }

    @Override
    public double getValue() {
        return this.value;
    }

    @Override
    void handleImportedCellReferences() {
    }
}

