/*
 * Decompiled with CFR 0.152.
 */
package ibase.e12ria.client;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import ibase.e12ria.client.E12Constants;
import ibase.e12ria.client.E12WizardFooter;

public class CollabPostPager
extends Composite {
    int totalPosts = 0;
    int currentStartPos = 0;
    int displayFeedLength = 4;
    Label feedDataLabel = new Label(E12Constants.constants.setNoDataLbl());
    Button feedDataNextButton = new Button("");
    Button feedDataPreButton = new Button("");
    Command updateCommand = new Command(){

        public void execute() {
        }
    };

    public CollabPostPager(int totalNoOfPosts) {
        this.totalPosts = totalNoOfPosts;
        this.feedDataPreButton.setStyleName("prevButtonIcon");
        this.feedDataNextButton.setStyleName("nextButtonIcon");
        this.feedDataNextButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                CollabPostPager.this.currentStartPos += CollabPostPager.this.displayFeedLength;
                CollabPostPager.this.updateCommand.execute();
            }
        });
        this.feedDataPreButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                CollabPostPager.this.currentStartPos -= CollabPostPager.this.displayFeedLength;
                if (CollabPostPager.this.currentStartPos < 0) {
                    CollabPostPager.this.currentStartPos = 0;
                }
                CollabPostPager.this.updateCommand.execute();
            }
        });
        E12WizardFooter footer = new E12WizardFooter();
        Widget w = footer.createFooter(null, E12WizardFooter.FooterType.FOOTERTYPE_TWO);
        footer.addWidgetInFooter((Widget)this.feedDataPreButton, 2);
        footer.addWidgetInFooter((Widget)this.feedDataLabel, 3);
        footer.addWidgetInFooter((Widget)this.feedDataNextButton, 1);
        this.initWidget(w);
    }

    public Command getUpdateCommand() {
        return this.updateCommand;
    }

    public void setUpdateCommand(Command updateCommand) {
        this.updateCommand = updateCommand;
    }

    public int getCurrentStartPos() {
        return this.currentStartPos;
    }

    public void setCurrentStartPos(int currentStartPos) {
        this.currentStartPos = currentStartPos;
    }

    public int getDisplayFeedLength() {
        return this.displayFeedLength;
    }

    public void setDisplayFeedLength(int displayFeedLength) {
        this.displayFeedLength = displayFeedLength;
    }

    public String getFeedDataText() {
        return this.feedDataLabel.getText();
    }

    public void setFeedDataText(String feedDataText) {
        this.feedDataLabel.setText(feedDataText);
    }

    public void updatePosts() {
        if (this.currentStartPos == 0) {
            this.feedDataPreButton.setEnabled(false);
        } else {
            this.feedDataPreButton.setEnabled(true);
        }
        if (this.currentStartPos + this.displayFeedLength >= this.totalPosts) {
            this.feedDataNextButton.setEnabled(false);
        } else {
            this.feedDataNextButton.setEnabled(true);
        }
        int totalPage = this.totalPosts / this.displayFeedLength;
        if (this.totalPosts % this.displayFeedLength != 0) {
            ++totalPage;
        }
        this.feedDataLabel.setText("Page " + (this.currentStartPos / this.displayFeedLength + 1) + " of " + totalPage);
        this.feedDataLabel.setTitle("Page " + (this.currentStartPos / this.displayFeedLength + 1) + " of " + totalPage);
    }
}

