import { Component, Directive, Input, ContentChildren, forwardRef, Optional, Output, EventEmitter, ChangeDetectorRef, ViewChild } from '@angular/core';
import { UniqueSelectionDispatcher } from '@angular/material/core';
import { FocusMonitor } from '@angular/cdk/a11y';
import { NG_VALUE_ACCESSOR } from '@angular/forms';
import { coerceBooleanProperty } from '@angular/cdk/coercion';
export class MatRadioChange {
}
export const MAT_RADIO_GROUP_CONTROL_VALUE_ACCESSOR = {
    provide: NG_VALUE_ACCESSOR,
    useExisting: forwardRef(() => BBRadiobuttonGroup),
    multi: true
};
let nextUniqueId = 0;
export class BBRadiobuttonGroup {
    constructor(_changeDetector) {
        this._changeDetector = _changeDetector;
        this._name = `bb-radio-group-${nextUniqueId++}`;
        this._value = null;
        this._selected = null;
        this._disabled = false;
        this._isInitialized = false;
        this._controlValueAccessorChangeFn = () => { };
        this.onTouched = () => { };
        this.change = new EventEmitter();
    }
    _markRadiosForCheck() {
        if (this._radios) {
            this._radios.forEach(radio => radio._markForCheck());
        }
    }
    writeValue(value) {
        this.value = value;
        this._changeDetector.markForCheck();
    }
    registerOnChange(fn) {
        this._controlValueAccessorChangeFn = fn;
    }
    registerOnTouched(fn) {
        this.onTouched = fn;
    }
    setDisabledState(isDisabled) {
        this.disabled = isDisabled;
        this._changeDetector.markForCheck();
    }
    get name() { return this._name; }
    set name(value) {
        this._name = value;
        this._updateRadioButtonNames();
    }
    get value() { return this._value; }
    set value(newValue) {
        if (this._value != newValue) {
            this._value = newValue;
            this._updateSelectedRadioFromValue();
            this._checkSelectedRadioButton();
        }
    }
    get selected() { return this._selected; }
    set selected(selected) {
        this._selected = selected;
        console.log('-------');
        this.value = selected ? selected.bbValue : null;
        this._checkSelectedRadioButton();
    }
    get disabled() { return this._disabled; }
    set disabled(value) {
        this._disabled = coerceBooleanProperty(value);
        this._markRadiosForCheck();
    }
    _checkSelectedRadioButton() {
        if (this._selected && !this._selected.bbChecked) {
            this._selected.bbChecked = true;
        }
    }
    ngAfterContentInit() {
        this._isInitialized = true;
    }
    _touch() {
        if (this.onTouched) {
            this.onTouched();
        }
    }
    _updateRadioButtonNames() {
        if (this._radios) {
            this._radios.forEach(radio => {
                radio.name = this.name;
            });
        }
    }
    _updateSelectedRadioFromValue() {
        // If the value already matches the selected radio, do nothing.
        const isAlreadySelected = this._selected != null && this._selected.bbValue == this._value;
        if (this._radios != null && !isAlreadySelected) {
            this._selected = null;
            this._radios.forEach(radio => {
                radio.bbChecked = this.value == radio.bbValue;
                if (radio.bbChecked) {
                    this._selected = radio;
                }
            });
        }
    }
    _emitChangeEvent() {
        if (this._isInitialized) {
            const event = new MatRadioChange();
            event.source = this._selected;
            event.value = this._value;
            this.change.emit(event);
        }
    }
    ngAfterViewChecked() {
        console.log('_selected', this._selected);
        console.log('_value', this._value);
    }
}
BBRadiobuttonGroup.decorators = [
    { type: Directive, args: [{
                selector: 'bb-radio-group',
                providers: [MAT_RADIO_GROUP_CONTROL_VALUE_ACCESSOR]
            },] },
];
/** @nocollapse */
BBRadiobuttonGroup.ctorParameters = () => [
    { type: ChangeDetectorRef, },
];
BBRadiobuttonGroup.propDecorators = {
    '_radios': [{ type: ContentChildren, args: [forwardRef(() => BBRadiobuttonComponent),] },],
    'change': [{ type: Output },],
    'name': [{ type: Input },],
    'value': [{ type: Input },],
    'selected': [{ type: Input },],
    'disabled': [{ type: Input },],
};
export class BBRadiobuttonComponent {
    constructor(radioGroup, _changeDetector, _radioDispatcher, _focusMonitor) {
        this._changeDetector = _changeDetector;
        this._radioDispatcher = _radioDispatcher;
        this._focusMonitor = _focusMonitor;
        this._uniqueId = `bb-radio-${++nextUniqueId}`;
        this.uxDesign = 'UX3';
        this.bbChecked = false;
        this.bbValue = false;
        this.bbId = this._uniqueId;
        this.bbDisabled = false;
        this.bbRequired = false;
        this.bbLabelPosition = 'after';
        this.bbType = 'radio';
        this._value = null;
        this._checked = false;
        this.change = new EventEmitter();
        this.radioGroup = radioGroup;
        console.log('radioGroup', this.radioGroup);
    }
    ngOnInit() {
        if (this.radioGroup) {
            this.name = this.radioGroup.name;
        }
    }
    _markForCheck() {
        this._changeDetector.markForCheck();
    }
    changeInput() {
        console.log('---Input Changed---');
        event.stopPropagation();
        const groupValueChanged = this.radioGroup && this.bbValue != this.radioGroup.value;
        this.bbChecked = true;
        this._emitChangeEvent();
        if (this.radioGroup) {
            this.radioGroup._controlValueAccessorChangeFn(this.bbValue);
            console.log('this.radioGroup', this.radioGroup);
            console.log('value--', +this.bbValue);
            this.radioGroup._touch();
            if (groupValueChanged) {
                this.radioGroup._emitChangeEvent();
            }
        }
    }
    _emitChangeEvent() {
        const event = new MatRadioChange();
        event.source = this;
        event.value = this._value;
        this.change.emit(event);
    }
}
BBRadiobuttonComponent.decorators = [
    { type: Component, args: [{
                selector: 'bb-radio-button',
                template: `

      <span [ngSwitch]="uxDesign">
      	<span *ngSwitchCase="'UX1'">
      		<span *ngIf="bbLabelPosition =='before'">
                 <ng-container *ngTemplateOutlet="content"></ng-container>	
      		   <input (change)="changeInput()" [type]="bbType"[id]="bbId" [name]="name" [required]="bbRequired" [disabled]="bbDisabled" [checked]="bbChecked" [value]="bbValue">
              </span>
      		<span *ngIf="bbLabelPosition =='after'" >
      		   <input (change)="changeInput()" [type]="bbType"[id]="bbId" [name]="name" [required]="bbRequired" [disabled]="bbDisabled" [checked]="bbChecked" [value]="bbValue">
                 <ng-container *ngTemplateOutlet="content"></ng-container>
      		</span>          
           
      	</span>
	
      	<span *ngSwitchCase="'UX3'">
      		<md-radio-button (change)="changeInput()" [id]="bbId" [name]="name" [required]="bbRequired" [disabled]="bbDisabled" [checked]="bbChecked" [value]="bbValue" [labelPosition]="bbLabelPosition">
      			<ng-container *ngTemplateOutlet="content"></ng-container>
      		</md-radio-button>
      	</span>
	
      	<ng-template #content><ng-content></ng-content></ng-template>
      </span>
    `,
                styles: [`

    `]
            },] },
];
/** @nocollapse */
BBRadiobuttonComponent.ctorParameters = () => [
    { type: BBRadiobuttonGroup, decorators: [{ type: Optional },] },
    { type: ChangeDetectorRef, },
    { type: UniqueSelectionDispatcher, },
    { type: FocusMonitor, },
];
BBRadiobuttonComponent.propDecorators = {
    'uxDesign': [{ type: Input, args: ['uxDesign',] },],
    'bbChecked': [{ type: Input, args: ['checked',] },],
    'bbValue': [{ type: Input, args: ['value',] },],
    'name': [{ type: Input, args: ['name',] },],
    'bbId': [{ type: Input, args: ['id',] },],
    'bbDisabled': [{ type: Input, args: ['disabled',] },],
    'bbRequired': [{ type: Input, args: ['required',] },],
    'bbLabelPosition': [{ type: Input, args: ['labelPosition',] },],
    'bbType': [{ type: Input, args: ['type',] },],
    '_inputElement': [{ type: ViewChild, args: ['input',] },],
    'change': [{ type: Output },],
};
//# sourceMappingURL=bb-radio-button-group.component.js.map