(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('rxjs/observable/merge'), require('rxjs/operator/ignoreElements'), require('@angular/core'), require('@ngrx/store'), require('rxjs/Observable'), require('rxjs/operator/filter'), require('rxjs/Subscription')) :
    typeof define === 'function' && define.amd ? define(['exports', 'rxjs/observable/merge', 'rxjs/operator/ignoreElements', '@angular/core', '@ngrx/store', 'rxjs/Observable', 'rxjs/operator/filter', 'rxjs/Subscription'], factory) :
    (factory((global.ngrx = global.ngrx || {}, global.ngrx.effects = global.ngrx.effects || {}),global.Rx.Observable,global.Rx.Observable.prototype,global.ng.core,global.ngrx.store,global.Rx,global.Rx.Observable.prototype,global.Rx));
}(this, (function (exports,rxjs_observable_merge,rxjs_operator_ignoreElements,_angular_core,_ngrx_store,rxjs_Observable,rxjs_operator_filter,rxjs_Subscription) { 'use strict';

var METADATA_KEY = '@ngrx/effects';
function Effect(_a) {
    var dispatch = (_a === void 0 ? { dispatch: true } : _a).dispatch;
    return function (target, propertyName) {
        if (!Reflect.hasOwnMetadata(METADATA_KEY, target)) {
            Reflect.defineMetadata(METADATA_KEY, [], target);
        }
        var effects = Reflect.getOwnMetadata(METADATA_KEY, target);
        var metadata = { propertyName: propertyName, dispatch: dispatch };
        Reflect.defineMetadata(METADATA_KEY, effects.concat([metadata]), target);
    };
}
function getEffectsMetadata(instance) {
    var target = Object.getPrototypeOf(instance);
    if (!Reflect.hasOwnMetadata(METADATA_KEY, target)) {
        return [];
    }
    return Reflect.getOwnMetadata(METADATA_KEY, target);
}
function mergeEffects(instance) {
    var observables = getEffectsMetadata(instance).map(function (_a) {
        var propertyName = _a.propertyName, dispatch = _a.dispatch;
        var observable = typeof instance[propertyName] === 'function' ?
            instance[propertyName]() : instance[propertyName];
        if (dispatch === false) {
            return rxjs_operator_ignoreElements.ignoreElements.call(observable);
        }
        return observable;
    });
    return rxjs_observable_merge.merge.apply(void 0, observables);
}

var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (undefined && undefined.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (undefined && undefined.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
// TODO: This is a copy of this: https://github.com/redux-observable/redux-observable/blob/master/src/ActionsObservable.js
// Remove after this is resolved: https://github.com/redux-observable/redux-observable/issues/95
var Actions = (function (_super) {
    __extends(Actions, _super);
    function Actions(actionsSubject) {
        var _this = _super.call(this) || this;
        _this.source = actionsSubject;
        return _this;
    }
    Actions.prototype.ofType = function () {
        var keys = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            keys[_i] = arguments[_i];
        }
        return rxjs_operator_filter.filter.call(this, function (_a) {
            var type = _a.type;
            var len = keys.length;
            if (len === 1) {
                return type === keys[0];
            }
            else {
                for (var i = 0; i < len; i++) {
                    if (keys[i] === type) {
                        return true;
                    }
                }
            }
            return false;
        });
    };
    Actions = __decorate([
        _angular_core.Injectable(),
        __param(0, _angular_core.Inject(_ngrx_store.Dispatcher)),
        __metadata("design:paramtypes", [rxjs_Observable.Observable])
    ], Actions);
    return Actions;
}(rxjs_Observable.Observable));

var __extends$1 = (undefined && undefined.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate$2 = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata$2 = (undefined && undefined.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param$1 = (undefined && undefined.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var effects = new _angular_core.OpaqueToken('ngrx/effects: Effects');
var EffectsSubscription = (function (_super) {
    __extends$1(EffectsSubscription, _super);
    function EffectsSubscription(store, parent, effectInstances) {
        var _this = _super.call(this) || this;
        _this.store = store;
        _this.parent = parent;
        if (Boolean(parent)) {
            parent.add(_this);
        }
        if (Boolean(effectInstances)) {
            _this.addEffects(effectInstances);
        }
        return _this;
    }
    EffectsSubscription.prototype.addEffects = function (effectInstances) {
        var sources = effectInstances.map(mergeEffects);
        var merged = rxjs_observable_merge.merge.apply(void 0, sources);
        this.add(merged.subscribe(this.store));
    };
    EffectsSubscription.prototype.ngOnDestroy = function () {
        if (!this.closed) {
            this.unsubscribe();
        }
    };
    EffectsSubscription = __decorate$2([
        _angular_core.Injectable(),
        __param$1(0, _angular_core.Inject(_ngrx_store.Store)),
        __param$1(1, _angular_core.Optional()), __param$1(1, _angular_core.SkipSelf()),
        __param$1(2, _angular_core.Optional()), __param$1(2, _angular_core.Inject(effects)),
        __metadata$2("design:paramtypes", [Object, EffectsSubscription, Array])
    ], EffectsSubscription);
    return EffectsSubscription;
}(rxjs_Subscription.Subscription));

var afterBootstrapEffects = new _angular_core.OpaqueToken('ngrx:effects: Bootstrap Effects');
function runAfterBootstrapEffects(injector, subscription) {
    return function () {
        var effectInstances = injector.get(afterBootstrapEffects, false);
        if (effectInstances) {
            subscription.addEffects(effectInstances);
        }
    };
}

var __decorate$1 = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata$1 = (undefined && undefined.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var EffectsModule = (function () {
    function EffectsModule(effectsSubscription) {
        this.effectsSubscription = effectsSubscription;
    }
    EffectsModule_1 = EffectsModule;
    EffectsModule.run = function (type) {
        return {
            ngModule: EffectsModule_1,
            providers: [
                EffectsSubscription,
                type,
                { provide: effects, useExisting: type, multi: true }
            ]
        };
    };
    EffectsModule.runAfterBootstrap = function (type) {
        return {
            ngModule: EffectsModule_1,
            providers: [
                type,
                { provide: afterBootstrapEffects, useExisting: type, multi: true }
            ]
        };
    };
    EffectsModule = EffectsModule_1 = __decorate$1([
        _angular_core.NgModule({
            providers: [
                Actions,
                EffectsSubscription,
                {
                    provide: _angular_core.APP_BOOTSTRAP_LISTENER,
                    multi: true,
                    deps: [_angular_core.Injector, EffectsSubscription],
                    useFactory: runAfterBootstrapEffects
                }
            ]
        }),
        __metadata$1("design:paramtypes", [EffectsSubscription])
    ], EffectsModule);
    return EffectsModule;
    var EffectsModule_1;
}());

function toPayload(action) {
    return action.payload;
}

exports.Effect = Effect;
exports.mergeEffects = mergeEffects;
exports.Actions = Actions;
exports.EffectsModule = EffectsModule;
exports.EffectsSubscription = EffectsSubscription;
exports.toPayload = toPayload;
exports.runAfterBootstrapEffects = runAfterBootstrapEffects;

Object.defineProperty(exports, '__esModule', { value: true });

})));