package ibase.webitm.ejb.fin.adv;

import ibase.system.config.ConnDriver;
import ibase.utility.E12GenericUtility;

import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.ITMDBAccessLocal;
//import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;
import ibase.webitm.ejb.ActionHandlerEJB;
import java.sql.*;
import java.util.StringTokenizer;
import java.rmi.RemoteException;
import javax.ejb.Stateless;



@Stateless
public class SalesPersonBankDeactivate extends ActionHandlerEJB implements SalesPersonBankDeactivateLocal,SalesPersonBankDeactivateRemote
{
	E12GenericUtility genericUtility = new E12GenericUtility();
	public String confirm(String tranId, String xtraParams, String forcedFlag) throws RemoteException,ITMException
	{
		System.out.println("--------------confirm method of SalesPersonBankDeactivate ------------- : ");
		String retString = "";		
		try
		{
						
				retString = deactive(tranId,xtraParams,forcedFlag);
			
		}
		catch(Exception e)
		{
			System.out.println("Exception :SalesPersonBankDeactivate :confirm():" + e.getMessage() + ":");
			retString = genericUtility.createErrorString(e);
			e.printStackTrace();
		}
		
		return retString;
	}
	
	private String deactive(String tranId,String xtraParams,String forcedFlag) 
	{
		System.out.println("---------Class : SalesPersonBankDeactivate-->> deactive method called-----------");   
		String salespers = null;
		String bankcode = null;
		ResultSet rs=null;
		Connection conn=null;
		ConnDriver ConnDriver = new ConnDriver();
		PreparedStatement pstmt=null;
		String errString="",sql="",loginSite="",ActiveYN="",itemCode="",regulatedPrice="";
		String itmCodeDt2="",lotNo="",lotSl="", detail2xmlString="";
		double invRate=0.0,invQty=0.0,PODrate=0.0,PODqty=0.0,allowedAmt=0.0,stockistAmt=0.0,debitNoteAmtAct=0.0;
		int updCnt=0,lineNo=0;
		ITMDBAccessLocal itmdbAccess=new ITMDBAccessEJB();
		try
		{		
			ConnDriver connDriver = null;
			connDriver = new ConnDriver();
			//Changes and Commented By Bhushan on 13-06-2016 :START
			//conn = connDriver.getConnectDB("DriverValidator");
			conn = getConnection();
			//Changes and Commented By Bhushan on 13-06-2016 :END
			conn.setAutoCommit(false);
			String confirmed="";
			String[] pkValuesArr = string2StringArray(tranId, ":");
			salespers = pkValuesArr[0].trim();
			bankcode = pkValuesArr[1].trim();
			
			sql = "select confirmed,active_yn from sales_pers_bank WHERE sales_pers = ? and bank_code__ben = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, salespers);
			pstmt.setString(2, bankcode);
			rs = pstmt.executeQuery();
			if( rs.next() )
			{
				confirmed =rs.getString(1)==null ? "N":rs.getString(1);
				ActiveYN=rs.getString(2)==null ? "Y" : rs.getString(2);
			}	
			if( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}
			if ( rs != null )
			{
				rs.close();
				rs = null;
			}
			if( ActiveYN != null && ActiveYN.equalsIgnoreCase("N") )
			{
				//deactivate transaction can not confirm
				System.out.println("transaction is already deactivated");
				errString = itmdbAccess.getErrorString("", "VMDETPTALS", "", "", conn);
				return errString;
			}				
			
//			if( confirmed != null && confirmed.equalsIgnoreCase("Y") )
//			{
//				
//				System.out.println("confirm transaction can not be deactivated");
//				//if already confirm then show error
//				errString = itmdbAccess.getErrorString("", "VMDECTRACF", "", "", conn);
//				return errString;
//			}	
//			GenericUtility genericUtility=new GenericUtility();
			String loginCode=genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
			System.out.println("Login Code ------->> "+loginCode);
			sql="update sales_pers_bank set active_yn = ? where sales_pers = ? and bank_code__ben = ? ";
			pstmt=conn.prepareStatement(sql);
			pstmt.setString(1, "N");
			pstmt.setString(2, salespers);
			pstmt.setString(3, bankcode);
			updCnt=pstmt.executeUpdate();
			
			if (updCnt > 0)
			{	
				System.out.println("successfully deactivated");
				conn.commit();
				errString = itmdbAccess.getErrorString("", "VMDETRASUC", "", "", conn);
				return errString;
				
			}
			
		}
		catch(SQLException se)
		{
			System.out.println("SQLException : class SalesPersonBankDeactivate : ");
			se.printStackTrace();
			try
			{
			  conn.rollback();
			}
			catch(Exception e){
				System.out.println("Exception : Occure during rollback........");e.printStackTrace();
				}
		}
		catch(Exception e)
		{
			try
			{
				conn.rollback();
			}
			catch (Exception e1)
			{
			}
			e.printStackTrace();
			System.out.println("Exception Class [SalesPersonBankDeactivate]::"+e.getMessage());
			
		}
		finally
		{
			try
			{
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;					
				}	
				if (conn!=null)
				{
					conn.close();
					conn=null;
				}
							
			}
			catch(Exception e)
			{
				System.out.println(e.getMessage());
				e.printStackTrace();
				
			}
		}
		System.out.println("[SalesPersonBankDeactivate]errstring :"+errString);
		return errString;
	
}
	private String[] string2StringArray(String str1 , String delimeter)
	{
		StringTokenizer st = new StringTokenizer(str1,delimeter);
		int count = st.countTokens() ;
		String[] arry1 = new String[count];
		int i =  0;
		while(st.hasMoreTokens()) 
		{
			arry1[i] = st.nextToken();
			System.out.println("Token "+i+" :["+arry1[i]+"]");
			i++;
		}
		return arry1 ;	
	}
	
}
