package ibase.dashboard.sfa.servlet;
import ibase.dashboard.sfa.ejb.LiveEventDetailsRemote;
import ibase.system.config.AppConnectParm;
import ibase.webitm.utility.ITMException;
import java.io.IOException;
import java.io.OutputStream;
import javax.naming.InitialContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.json.simple.JSONObject;

public class ActiveEventServlet extends HttpServlet
{
	private static final long serialVersionUID = 1L;
	JSONObject jsonObjMetaData = null;
	JSONObject jsonMetaData = null;

	public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException
	{
		doPost(request, response);
	}

	@SuppressWarnings("unchecked")
	public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException
	{
		LiveEventDetailsRemote liveEventDetailsRemote = null;
		InitialContext context = null;
		AppConnectParm appConnectParm = new AppConnectParm();
		String dataSourceName  = "";
		
				
		try
		{
			response.setContentType("application/xml");			
			dataSourceName = request.getParameter("dataSourceName");			
			context = new InitialContext(appConnectParm.getProperty());
			liveEventDetailsRemote = (LiveEventDetailsRemote) context.lookup("ibase/LiveEventDetails/remote");
			System.out.println("in ActiveEventServlet");		
			JSONObject jsonObjData      = (JSONObject) liveEventDetailsRemote.getActiveEvent(dataSourceName);
			OutputStream outputStream   = response.getOutputStream();			
		    outputStream.write(jsonObjData.toString().getBytes());
			outputStream.flush();
			outputStream.close();
			System.out.println(" Final data set for ActiveEventServlet for the build the Graph is===" + jsonObjData);		

		} catch (Exception e)
		{
			System.out.println("Exception : ActiveEventServlet :doPost(HttpServletRequest request, HttpServletResponse response) :" + e);
			try
			{
				throw new ITMException(e);
			} catch (ITMException e1)
			{
				e1.printStackTrace();
			}
		}

	}

}