package ibase.dashboard.scm.servlet;

import ibase.dashboard.scm.ejb.ShortageInventoryRemote;
import ibase.system.config.AppConnectParm;
import ibase.webitm.utility.ITMException;
import java.io.IOException;
import java.io.OutputStream;
import javax.naming.InitialContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.json.simple.JSONObject;


public class ShortageInventoryServlet extends HttpServlet 
{
	
	private static final long serialVersionUID = 1L;

	public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException
	{
		doPost(request, response);
	}
	
	public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException
	{
		ShortageInventoryRemote shortageInventoryRemote = null;
		InitialContext context = null;
		AppConnectParm appConnectParm = new AppConnectParm();
		String dataSourceName = "";
		String loginSiteCode  = "";
		String finYear        = "";
		
		try
		{
			System.out.println("Try block of ShortageInventoryServlet.doPost()");
			
			response.setContentType("application/xml");
			HttpSession session                 = request.getSession(true);
			ibase.utility.UserInfoBean userInfo = (ibase.utility.UserInfoBean) session.getAttribute("USER_INFO");
			loginSiteCode                      = userInfo.getSiteCode();		
			dataSourceName = request.getParameter("dataSourceName");
			finYear        = request.getParameter("finYear");
			context = new InitialContext(appConnectParm.getProperty());
			shortageInventoryRemote = (ShortageInventoryRemote) context.lookup("ibase/ShortageInventory/remote");
			JSONObject jsonObjData = (JSONObject) shortageInventoryRemote.getShortageInventory(dataSourceName,loginSiteCode,finYear);
			OutputStream outputStream  = response.getOutputStream();			
		    outputStream.write(jsonObjData.toString().getBytes());
			outputStream.flush();
			outputStream.close();
			System.out.println("Final data set for ShortageInventoryServlet build the Graph is === " + jsonObjData);
		
			

		} catch (Exception e)
		{
			System.out.println("Catch block of ShortageInventoryServlet.doPost()");
			try
			{
				throw new ITMException(e);
			} catch (ITMException e1)
			{
				e1.printStackTrace();
			}
		}

	}
}
