package ibase.dashboard.common.webService;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;

import org.json.JSONObject;

import ibase.dashboard.hibernate.dao.AccountActivityDao;
import ibase.utility.BaseException;
import ibase.utility.UserInfoBean;

@Path("/accountActivity")
public class AccountActivityService {
	@Context
	HttpServletRequest request; // The proxy of Request will be injected into this singleton

	@GET
	@Path("/")
	@Produces(MediaType.APPLICATION_JSON)
	public String getAccountActivityData(@QueryParam("fromDate") String fromDate, 
			@QueryParam("toDate") String toDate,
			@QueryParam("date") String date,
			@QueryParam("startBattery") int startBattery,
			@QueryParam("USER_INFO") String userInfoString) throws Exception 
	{
		JSONObject accountActivityData = new JSONObject();
		System.out.println("getAccountActivityData fromDate date [" + fromDate + "]");
		System.out.println("getAccountActivityData toDate date [" + toDate + "]");
		System.out.println("getAccountActivityData  date [" + date + "]");
		System.out.println("getAccountActivityData startBattery [" + startBattery + "]");

		if(date != null){
			fromDate = date;
			toDate = date;
			System.out.println("getAccountActivityData date not null [" + fromDate + "] toDate ["+toDate+"]");
		}
		if (fromDate == null) 
		{
			DateTimeFormatter formatter1 = DateTimeFormatter.ofPattern("dd-MM-YY");
			fromDate = LocalDate.now().format(formatter1);
			System.out.println("getAccountActivityData fromDate is null [" + fromDate + "]");
		}
		if (toDate == null) 
		{
			DateTimeFormatter formatter1 = DateTimeFormatter.ofPattern("dd-MM-YY");
			toDate = LocalDate.now().format(formatter1);
			System.out.println("getAccountActivityData toDate is null [" + toDate + "]");
		}
		if (startBattery == 0) 
		{
			startBattery = 100;
			System.out.println("getAccountActivityData startBattery is null [" + startBattery + "]");
		}
		
		if( userInfoString == null )
		{
			HttpSession session = request.getSession();
			Object userObj = session.getAttribute("USER_INFO");
			System.out.println("getAccountActivityData userObj [" + userObj + "]");
			if (userObj != null) 
			{
				userInfoString = userObj.toString();
			}
			else
			{
				userInfoString = null;
			}
		}

		String userId = "";
		String profileId = "";
		System.out.println("getAccountActivityData userInfoString [" + userInfoString + "]");
		if (userInfoString != null) 
		{
			try 
			{
				AccountActivityDao accountActivityDao = new AccountActivityDao();
				UserInfoBean userInfo = new UserInfoBean( userInfoString );
				userId = userInfo.getLoginCode();
				profileId = userInfo.getProfileId();
				System.out.println(" userInfo >>[" + userId + "] profile Id [" + profileId + "]");
				accountActivityData = accountActivityDao.getUserActivityData(userId, profileId, fromDate, toDate, startBattery);
			} 
			catch (BaseException e) 
			{
				e.printStackTrace();
			}
		}
		System.out.println("getAccountActivityData accountActivityData : " + accountActivityData.toString());
		return accountActivityData.toString();
	}
}