package ibase.dashboard.hibernate.util;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;

public class GenericUtil 
{
	public List<String> getDateList(String fromDate, String toDate, String format) throws ParseException 
	{
		SimpleDateFormat newFormat = new SimpleDateFormat(format);
		DateFormat formatter = new SimpleDateFormat("dd-MM-yy");
		
		Date startDate = (Date) formatter.parse(fromDate);
		Date endDate = (Date) formatter.parse(toDate);

		List<String> formattedDateRange = new ArrayList<String>();
		Calendar calendar = new GregorianCalendar();
		calendar.setTime(startDate);
		while (calendar.getTime().before(endDate)) 
		{
			Date currentDate = calendar.getTime();
			calendar.add(Calendar.DATE, 1);
			formattedDateRange.add( newFormat.format(currentDate) );
		}
		formattedDateRange.add(newFormat.format(endDate));

		System.out.println(" getDateList formattedDateRange::::" + formattedDateRange);
		return formattedDateRange;
	}
	
	public String getEnclosedString(List<String> valueList) 
	{
		StringBuffer enclosedStringBuffer = new StringBuffer();
		int len = 0;
		for(String value : valueList)
		{
			enclosedStringBuffer.append("'").append(value.trim()).append("'");
			len++;
			if( len < valueList.size() )
			{
				enclosedStringBuffer.append(",");
			}
		}
		if( enclosedStringBuffer.length() == 0 )
		{
			enclosedStringBuffer.append("''");
		}
		System.out.println("Inside getEnclosedString enclosedStringBuffer: [" + enclosedStringBuffer +"]");
		
		return enclosedStringBuffer.toString();
	}
	
	public Object checkNull(Object data) 
    {
    	if(data==null)
    	{
    		return "NA";
    	}
    	else 
    	{
    		return data;
    	}
    }
	
	public Object checkNullDate(Object data) 
    {
    	System.out.println("Inside checkNull"+data);
    	if(data==null)
    	{
    		return  new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
    	}
    	else 
    	{
    		return data;
    	}
    }
}
