package proteus.ecm.cache;

import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
/**
 * 
 * Utility class that help in providing valid Infinispan Cache Manager to the
 * client code.
 * 
 */

public class CacheManager {

    public static String SYSTEM_CACHE_NAME = "DEFAULT";

    private static EmbeddedCacheManager manager;
    
    /**
     * Initializes Cache Manager using configuration file. Returns Manager if
     * already initialized.
     * 
     * @return instance of embedded cache manager
     */
    /*
    public synchronized static EmbeddedCacheManager getInstance() 
    {
    	if (manager == null)
		{
			try 
			{
		    	System.out.println("\n\n In getInstance: manager is being lookup");
              	InitialContext ctx = new InitialContext();
               	manager = ((EmbeddedCacheManager)ctx.lookup("java:jboss/infinispan/container/ProteusECM"));
               	manager.start();
			}
			catch (Exception e1)
			{
				System.out.println("\n\n Exception in getInstance:: " + e1);
				e1.printStackTrace();
			}
		}
    	System.out.println("\n\n In getInstance: manager is : " + manager);
		return manager;
    }
    */
    public synchronized static EmbeddedCacheManager getInstance() 
    {
    	if (manager == null)
		{
			try 
			{
               	manager = new DefaultCacheManager("resource/infinispan.xml");
			}
			catch (Exception e1)
			{
				System.out.println("\n\n Exception in getInstance:: " + e1);
				e1.printStackTrace();
			}
			System.out.println("\n\n In getInstance: manager is : " + manager);
		}
		return manager;
    }
    
    public static void createInstance(String cacheName){
	    	System.out.println("\n createInstance Called for cacheName:"+cacheName);
    		try 
			{
				manager.defineConfiguration(cacheName, manager.getDefaultCacheConfiguration());
			}
			catch (Exception e1)
			{
				System.out.println("\n\n Exception in getInstance:: " + e1);
				e1.printStackTrace();
			}
    }
    
    /**
     * Closes cache manager.
     */
    public static void stop() {
    	manager.stop();
    }

    private CacheManager() {
    	// intentionally left blank
    }

}
