import { Component, OnChanges, Input, ElementRef } from '@angular/core';

@Component({
  selector: 'ecm-readmore',
  templateUrl: './ecm-readmore.component.html',
  styleUrls: ['./ecm-readmore.component.css']
})
export class EcmReadmoreComponent implements OnChanges {
    @Input() text: string;
    @Input() maxLength: number = 100;
    currentText: string;
    hideToggle: boolean = true;

    public isCollapsed: boolean = true;

      constructor(private elementRef: ElementRef) { }

      ngOnChanges()
        {
           this.determineView();    
        }
        
        toggleView()
      {
       this.isCollapsed = !this.isCollapsed;
       this.determineView();
      }
      
      determineView()
      {
        if(this.text.length <= this.maxLength)
        {
          this.currentText = this.text;
          this.isCollapsed = false;
          this.hideToggle = true;
          return;
        }
        this.hideToggle = false;
        if(this.isCollapsed == true)
        {
            this.currentText = this.text.substring(0, this.maxLength) + ".....";
        }
        else if(this.isCollapsed == false)
        { 
           this.currentText = this.text;
        }
      
      }

}
