/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.embedded;

import java.util.Map;
import java.util.TreeMap;
import javax.servlet.Filter;
import org.apache.solr.client.solrj.embedded.SSLConfig;
import org.eclipse.jetty.servlet.ServletHolder;

public class JettyConfig {
    public final int port;
    public final String context;
    public final boolean stopAtShutdown;
    public final Map<ServletHolder, String> extraServlets;
    public final Map<Class<? extends Filter>, String> extraFilters;
    public final SSLConfig sslConfig;

    private JettyConfig(int port, String context, boolean stopAtShutdown, Map<ServletHolder, String> extraServlets, Map<Class<? extends Filter>, String> extraFilters, SSLConfig sslConfig) {
        this.port = port;
        this.context = context;
        this.stopAtShutdown = stopAtShutdown;
        this.extraServlets = extraServlets;
        this.extraFilters = extraFilters;
        this.sslConfig = sslConfig;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(JettyConfig other) {
        Builder builder = new Builder();
        builder.port = other.port;
        builder.context = other.context;
        builder.stopAtShutdown = other.stopAtShutdown;
        builder.extraServlets = other.extraServlets;
        builder.extraFilters = other.extraFilters;
        builder.sslConfig = other.sslConfig;
        return builder;
    }

    public static class Builder {
        int port = 0;
        String context = "/solr";
        boolean stopAtShutdown = true;
        Map<ServletHolder, String> extraServlets = new TreeMap<ServletHolder, String>();
        Map<Class<? extends Filter>, String> extraFilters = new TreeMap<Class<? extends Filter>, String>();
        SSLConfig sslConfig = null;

        public Builder setPort(int port) {
            this.port = port;
            return this;
        }

        public Builder setContext(String context) {
            this.context = context;
            return this;
        }

        public Builder stopAtShutdown(boolean stopAtShutdown) {
            this.stopAtShutdown = stopAtShutdown;
            return this;
        }

        public Builder withServlet(ServletHolder servlet, String servletName) {
            this.extraServlets.put(servlet, servletName);
            return this;
        }

        public Builder withServlets(Map<ServletHolder, String> servlets) {
            if (servlets != null) {
                this.extraServlets.putAll(servlets);
            }
            return this;
        }

        public Builder withFilter(Class<? extends Filter> filterClass, String filterName) {
            this.extraFilters.put(filterClass, filterName);
            return this;
        }

        public Builder withFilters(Map<Class<? extends Filter>, String> filters) {
            if (filters != null) {
                this.extraFilters.putAll(filters);
            }
            return this;
        }

        public Builder withSSLConfig(SSLConfig sslConfig) {
            this.sslConfig = sslConfig;
            return this;
        }

        public JettyConfig build() {
            return new JettyConfig(this.port, this.context, this.stopAtShutdown, this.extraServlets, this.extraFilters, this.sslConfig);
        }
    }
}

