package ibase.webitm.ejb.sys;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.text.DecimalFormat;
import java.util.Calendar;
import java.util.Date;

public class UtilMethods {
	public UtilMethods(){

	}

	public static UtilMethods getInstance()
	{
		return new UtilMethods();
	}

	public java.sql.Timestamp RelativeDate(java.sql.Timestamp baseDate, int noOfDays)
	{
		Calendar cal = Calendar.getInstance();
		cal.setTime(baseDate);
		cal.add(Calendar.DATE, noOfDays);
		Date newDate = cal.getTime();
    	SimpleDateFormat sdt = new SimpleDateFormat("yyyy-MM-dd");
    	return java.sql.Timestamp.valueOf(sdt.format(newDate) + " 00:00:00.000");

	}
	public Date RelativeDate(Date baseDate, int noOfDays)
	{
		Calendar cal = Calendar.getInstance();
		cal.setTime(baseDate);
		cal.add(Calendar.DATE, noOfDays);
		Date newDate = cal.getTime();
		return newDate;
	}
	public Date AddMonths(Date baseDate, int noOfMonths)
	{
		Calendar cal = Calendar.getInstance();
		cal.setTime(baseDate);
		cal.add(Calendar.MONTH, noOfMonths);
		java.util.Date newDate = cal.getTime();
		return newDate;
	}
	public java.sql.Timestamp AddMonths(java.sql.Timestamp baseDate, int noOfMonths)
	{
		Calendar cal = Calendar.getInstance();
		cal.setTime(baseDate);
		cal.add(Calendar.MONTH, noOfMonths);
		java.util.Date newDate = cal.getTime();
    	SimpleDateFormat sdt = new SimpleDateFormat("yyyy-MM-dd");
    	return java.sql.Timestamp.valueOf(sdt.format(newDate) + " 00:00:00.000");

	}

    public long DaysAfter(java.sql.Timestamp date1, java.sql.Timestamp date2)
    {
    	// 18-04-2007 manoharan to find the elapsed days
    	// between 2 dates (timestamp).
    	// Return positive days if first argument date1 is earlier date
    	// and second argument date2 is a later date
    	// other wise returns negative days
    	Calendar calen = Calendar.getInstance();
    	Calendar calen1 = Calendar.getInstance();
    	SimpleDateFormat sdt = new SimpleDateFormat("yyyy-MM-dd");
    	long totDays = 0;

    	date1 = java.sql.Timestamp.valueOf(sdt.format(date1) + " 00:00:00.000");
    	calen.setTime(date1);

    	date2 = java.sql.Timestamp.valueOf(sdt.format(date2) + " 00:00:00.000");
    	calen1.setTime(date2);

    	totDays = (calen.getTime().getTime() - calen1.getTime().getTime()) / (24 * 3600 * 1000);

    	return totDays;
    }

	public String getReqDecString(double actVal, int prec)
	{
		String fmtStr = "############0";
		String strValue = null;
		if (prec > 0)
		{
			fmtStr = fmtStr + "." + "000000000".substring(0, prec);
		}
		DecimalFormat decFormat = new DecimalFormat(fmtStr);
		return decFormat.format(actVal);
	}
    public int MonthsBetween(java.sql.Timestamp date1, java.sql.Timestamp date2)
    {
    	// 18-04-2007 manoharan to find the elapsed months
    	// between 2 dates (timestamp).
    	Calendar calen = Calendar.getInstance();
    	Calendar calen1 = Calendar.getInstance();
    	SimpleDateFormat sdt = new SimpleDateFormat("yyyy-MM-dd");
    	long totDays = 0;
    	int startMonth = 0, endMonth = 0, startDay = 0;
    	int totMonths = 0;
		java.sql.Timestamp tmpDate = null;

    	date1 = java.sql.Timestamp.valueOf(sdt.format(date1) + " 00:00:00.000");

    	date2 = java.sql.Timestamp.valueOf(sdt.format(date2) + " 00:00:00.000");
    	if (date2.compareTo(date1) < 0)
    	{
    		tmpDate = date2;
    		date2 = date1;
    		date1 = tmpDate;
    	}
    	calen.setTime(date1);
    	calen1.setTime(date2);

    	startDay = calen.get(Calendar.DAY_OF_MONTH);
    	startMonth = calen.get(Calendar.MONTH) + 1;
    	endMonth = calen1.get(Calendar.MONTH) + 1;
    	System.out.println("start month before" + startMonth);
    	if (startDay > 15)
    	{
    		startMonth++;
    		if ( startMonth > 12)
    		{
    			startMonth = 1;
    		}
    	}

    	if (startMonth > endMonth)
    	{
    		totMonths = 12 - startMonth + 1 + endMonth;
    	}
    	else
    	{
    		totMonths = endMonth - startMonth + 1;
    	}

    	return totMonths ;
    }
    public double ElapsedTimeHHMM(java.sql.Timestamp date1, java.sql.Timestamp date2)
    {
    	// 19/01/2009 manoharan to find the elapsed time
    	// between 2 dates (timestamp). in the format hh.mm
    	// Return positive hours/minutes if first argument date1 is earlier date
    	// and second argument date2 is a later date
    	// other wise returns negative hours/minutes
    	Calendar calen = Calendar.getInstance();
    	Calendar calen1 = Calendar.getInstance();
    	SimpleDateFormat sdt = new SimpleDateFormat("yyyy-MM-dd kk:mm");
    	double totHHMM = 0;
    	long totalTime = 0,amills = 0, bmills = 0;
		java.sql.Timestamp tmpDate;
		int multiplier = 1;
    	if (date2.compareTo(date1) < 0)
    	{
    		tmpDate = date2;
    		date2 = date1;
    		date1 = tmpDate;
    		multiplier = -1;
    	}

    	date1 = java.sql.Timestamp.valueOf(sdt.format(date1) + ":00.000");
    	
    	
    	calen.setTime(date1);

    	date2 = java.sql.Timestamp.valueOf(sdt.format(date2) + ":00.000");
    	calen1.setTime(date2);
    	bmills = calen.getTimeInMillis();
		amills = calen1.getTimeInMillis();
		
		totalTime = amills - bmills;
		
		//System.out.println("Total Time Spend :: "+totalTime+" Milliseconds");

		int totSecs = (int)(((double)1/1000)*(totalTime));
		int totalHrs = (int)(totSecs / 3600);
		int totlMts = (int)(((totSecs - ( totalHrs *  3600))/ 60));

		totSecs = (int) ( totSecs - (( totalHrs *  3600) + (totlMts * 60)) );

		//System.out.println("Tot Hours   : " + totalHrs);
		//System.out.println("tot Minutes : " + totlMts);
		
		totHHMM = (double) Double.parseDouble( Integer.toString(totalHrs).trim() + "." + Integer.toString(totlMts).trim() );
		totHHMM = totHHMM * multiplier ;
    	return totHHMM;
    }


}
