package ibase.webitm.ejb.dis.adv;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import javax.ejb.Stateless;

import ibase.webitm.ejb.ActionHandlerEJB;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.ejb.dis.GenericWorkflowClass;
import ibase.webitm.utility.ITMException;

@Stateless
public class SContractConfWfEJB extends ActionHandlerEJB implements SContractConfWfEJBLocal, SContractConfWfEJBRemote 
{
	public String confirm(String tranId, String xtraParams, String forcedFlag) throws RemoteException, ITMException {
		System.out.println("@@@@@@@@@@@@@@@@@@@@ SContractConfWfEJB @@@@@@@@@@@@@@@@");
		String userId = "";
		String errString = "";
		ValidatorEJB validatorEJB = null;
		ITMDBAccessEJB itmDBAccessEJB = null;
		Connection conn = null;
		PreparedStatement pStmt = null;
		ResultSet rs = null;
		String sql = "";
		String status = "",confirmed = "",retString = "";
		String[] authencate = new String[2];
		authencate[0] = "";
		authencate[1] = "";
		boolean isError = false;
		
		try {
			itmDBAccessEJB = new ITMDBAccessEJB();
			validatorEJB = new ValidatorEJB();
			conn = getConnection();
			conn.setAutoCommit(false);
			userId = validatorEJB.getValueFromXTRA_PARAMS(xtraParams, "loginCode");

			System.out.println("tran_id ..> " + tranId+" userId: "+userId+" xtraParams: "+xtraParams+" forcedFlag: "+forcedFlag);
			tranId = checkNull(tranId);

			sql = "SELECT confirmed FROM scontract WHERE contract_no = ? ";

			pStmt = conn.prepareStatement(sql);
			pStmt.setString(1, tranId);
			rs = pStmt.executeQuery();
			
			if (rs.next()) {
				confirmed  = rs.getString("confirmed");
			}
			
			confirmed = checkNull(confirmed);
			closePstmtRs(pStmt, rs);

			if(!"Y".equalsIgnoreCase(confirmed))
			{
				GenericWorkflowClass wfGenericClass = new GenericWorkflowClass();
				retString = wfGenericClass.invokeWorkflow(conn, tranId, xtraParams, "w_scontract", "scontract");
				if ("success".equalsIgnoreCase(retString)) 
				{
							
					sql = "UPDATE SCONTRACT SET SET conf_date = sysdate WHERE CONTRACT_NO = ? ";
					pStmt = conn.prepareStatement(sql);
					//pStmt.setString(1, confirmed);
					pStmt.setString(1, tranId);
					int updCount = pStmt.executeUpdate();
							
					if (updCount > 0) 
					{
						errString = new ITMDBAccessEJB().getErrorString("", "VFMWRKFLWS", "");
					}
					else{
						errString = new ITMDBAccessEJB().getErrorString("", "VFMWRKFLWF", "");
	    				isError=true;
					}
				} 
				else {
					errString = new ITMDBAccessEJB().getErrorString("", "VFMWRKFLWF", "");
				}
				
			}
			else{
				errString = new ITMDBAccessEJB().getErrorString("", "VTMWFALCNF", "");
			}
		} catch (Exception e) {
			isError = true;
			System.out.println("Exception: confirm method ..> " + e.getMessage());
			e.printStackTrace();
			errString = itmDBAccessEJB.getErrorString("", "VFMWRKFLWF", userId);
			throw new ITMException(e);
		} finally {
			if (conn != null) {
				try {
					if (isError) {
						conn.rollback();
						System.out.println("SContractConfWfEJB: confirm: Connection Rollback");
					} else {
						conn.commit();
						System.out.println("SContractConfWfEJB: confirm: Connection Commit");
					}
					conn.close();
					conn = null;
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		}
		return errString;
	}


	private String checkNull(String str) {
		if(str == null){
			str = "";
		}
		else{
			str = str.trim();
		}
		return str;
	}

	private void closePstmtRs(PreparedStatement pStmt, ResultSet rs) {
		if (pStmt != null) {
			try {
				pStmt.close();
			} catch (SQLException localSQLException1) {
			}
			pStmt = null;
		}
		if (rs != null) {
			try {
				rs.close();
			} catch (SQLException e) {
				e.printStackTrace();
			}
			rs = null;
		}
	}
}
