package ibase.dashboard.gst.servlet;
import ibase.dashboard.gst.ejb.TransactionInOutEJBRemote;
import ibase.system.config.AppConnectParm;
import ibase.webitm.utility.ITMException;

import java.io.IOException;
import java.io.OutputStream;

import javax.naming.InitialContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.json.simple.JSONObject;

@SuppressWarnings("serial")
public class TaxandMismatchSummaryServlet extends HttpServlet
{

	public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException
	{
		 doPost( request, response );
	}
	public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException
	{
		TransactionInOutEJBRemote transactionInOutEJBRemote = null;
		InitialContext context                = null;
		AppConnectParm appConnectParm         = new AppConnectParm();
		JSONObject jsonObjData                = null;
		OutputStream outputStream             = null;
		ibase.utility.UserInfoBean userInfo = null;
		String dataSourceName                 = "";
		String month = "", year = "", status = "", gstCode = "", sessionSiteCode = "";
		try
		{
			response.setContentType("application/xml");			
			HttpSession session = request.getSession(true);
			userInfo 			= (ibase.utility.UserInfoBean) session.getAttribute("USER_INFO");
			sessionSiteCode 	= userInfo.getSiteCode();
			
			dataSourceName 		= request.getParameter("dataSourceName");
			month   			= request.getParameter("CURRENT_MONTH");
			year   				= request.getParameter("CURRENT_YEAR");
			status   			= request.getParameter("GST_STATUS");
			gstCode   			= request.getParameter("GST_NUMBER");
			System.out.println("=====status: "+status+" gstCode: "+gstCode);
			System.out.println("=========== TaxandMismatchSummaryServlet SessionSiteCode: "+sessionSiteCode);
			context        		= new InitialContext(appConnectParm.getProperty());
			System.out.println("=========== TaxandMismatchSummaryServlet after context SessionSiteCode: "+sessionSiteCode);
			transactionInOutEJBRemote = (TransactionInOutEJBRemote) context.lookup("ibase/TransactionInOutEJB/remote");
			jsonObjData         = transactionInOutEJBRemote.getTaxMismatchSummary(dataSourceName, month, year, status, gstCode, sessionSiteCode);			
			outputStream        = response.getOutputStream();
		    outputStream.write(jsonObjData.toString().getBytes());
			outputStream.flush();
			outputStream.close();
			System.out.println("Final data set for TaxandMismatchSummaryServlet.java build the Graph is===" + jsonObjData);

		} catch (Exception e)
		{
			System.out.println("Exception : TaxandMismatchSummaryServlet :doPost(HttpServletRequest request, HttpServletResponse response) :" + e);
			try
			{
				throw new ITMException(e);
			} catch (ITMException e1)
			{
				e1.printStackTrace();
			}
		}

	}

		
	
	
}