SET DEFINE OFF;

ALTER TABLE EMPLOYEE ADD EMP_FNAME_LONG VARCHAR2(30);
ALTER TABLE EMPLOYEE ADD EMP_MNAME_LONG VARCHAR2(30);
ALTER TABLE EMPLOYEE ADD EMP_LNAME_LONG VARCHAR2(30);

UPDATE EMPLOYEE SET EMP_FNAME_LONG = EMP_FNAME WHERE EMP_FNAME_LONG IS NULL;
UPDATE EMPLOYEE SET EMP_MNAME_LONG = EMP_MNAME WHERE EMP_MNAME_LONG IS NULL;
UPDATE EMPLOYEE SET EMP_LNAME_LONG = EMP_LNAME WHERE EMP_LNAME_LONG IS NULL;
COMMIT;

ALTER TABLE EMPLOYEE MODIFY EMP_FNAME_LONG NOT NULL;
ALTER TABLE EMPLOYEE MODIFY EMP_MNAME_LONG NOT NULL;
ALTER TABLE EMPLOYEE MODIFY EMP_LNAME_LONG NOT NULL;

Create Or Replace Trigger Trg_Upd_Empnames Before Insert Or Update On Employee 
REFERENCING OLD AS OLD NEW AS NEW FOR EACH ROW 

BEGIN
	IF :NEW.EMP_FNAME_LONG IS NULL AND :NEW.EMP_FNAME IS NOT NULL THEN
		:NEW.EMP_FNAME_LONG := :NEW.EMP_FNAME;
	ELSIF :NEW.EMP_FNAME_LONG IS NOT NULL AND :NEW.EMP_FNAME IS NULL THEN
		:NEW.EMP_FNAME := :NEW.EMP_FNAME_LONG ;
	END IF;

	IF :NEW.EMP_MNAME_LONG IS NULL AND :NEW.EMP_MNAME IS NOT NULL THEN
		:NEW.EMP_MNAME_LONG := :NEW.EMP_MNAME;
	ELSIF :NEW.EMP_MNAME_LONG IS NOT NULL AND :NEW.EMP_MNAME IS NULL THEN
		:NEW.EMP_MNAME := :NEW.EMP_MNAME_LONG ;
	END IF;

	IF :NEW.EMP_LNAME_LONG IS NULL AND :NEW.EMP_LNAME IS NOT NULL THEN
		:NEW.EMP_LNAME_LONG := :NEW.EMP_LNAME;
	ELSIF :NEW.EMP_LNAME_LONG IS NOT NULL AND :NEW.EMP_LNAME IS NULL THEN
		:NEW.EMP_LNAME := :NEW.EMP_LNAME_LONG ;
	END IF;

END;
/

INSERT INTO OBJ_ITEMCHANGE 
(
	OBJ_NAME,
	FORM_NO,
	FIELD_NAME,
	MANDATORY
)
VALUES 
(
	'empp_complete',
	'1',
	'emp_fname_long',
	'Y'
);

INSERT INTO OBJ_ITEMCHANGE 
(
	OBJ_NAME,
	FORM_NO,
	FIELD_NAME,
	MANDATORY
)
VALUES 
(
	'empp_complete',
	'1',
	'emp_mname_long',
	'Y'
);

INSERT INTO OBJ_ITEMCHANGE 
(
	OBJ_NAME,
	FORM_NO,
	FIELD_NAME,
	MANDATORY
)
VALUES 
(
	'empp_complete',
	'1',
	'emp_lname_long',
	'Y'
);

COMMIT;
