package proteus.ecm.hibernate.dao;

import java.rmi.RemoteException;
import java.sql.*;
import java.text.SimpleDateFormat;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;

import javax.naming.InitialContext;
import javax.naming.NamingException;

import org.hibernate.HibernateException;
import org.hibernate.query.Query;
import org.hibernate.Session;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.quartz.impl.jdbcjobstore.SybaseDelegate;
import org.w3c.dom.Node;

import ibase.system.config.AppConnectParm;
import ibase.system.config.ConnDriver;
import ibase.utility.BaseException;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.MasterStatefulLocal;
import ibase.webitm.ejb.dis.DistCommon;
import ibase.webitm.ejb.dis.SalesOrderIC;
import ibase.webitm.utility.ITMException;
import proteus.ecm.cache.bean.ECMUserTracker;
import proteus.ecm.cache.dao.ProductCache;
import proteus.ecm.cache.dao.UserActivityCache;
import proteus.ecm.hibernate.bean.ECMOrder;
import proteus.ecm.hibernate.bean.EntityAddress;
import proteus.ecm.hibernate.bean.ItemDetails;
import proteus.ecm.hibernate.util.HibernateUtil;
import ibase.webitm.ejb.dis.*;


public class ECMOrderDAO {
	private String siteTranDB = "DEFAULT";
	UserActivityCache userActivityCache = new UserActivityCache();
	private UserInfoBean userInfo = null;
	private E12GenericUtility genericUtility = new E12GenericUtility();
	ProductCache productCache = new ProductCache();
	   
	private DistCommon distCommon=new DistCommon();
	private SalesOrderIC salesOrderIc=new SalesOrderIC();


	ProductDAO productDAO = new ProductDAO();
	String siteCode = "";
	public  ECMOrder getOrder(String orderNo){	
		
		ECMOrder order =new ECMOrder();
		try {
			// 1. Get Session object
			Session session = HibernateUtil.getSessionFactory(siteTranDB).openSession();
			// 2. Create Query
			System.out.println("Inside getOrder orderNo: [" + orderNo + "]");
			Query query = session.createQuery("from ECMOrder where orderNo=' "+orderNo+"'");
			System.out.println("Inside getOrder query: [" + query + "]");
			List<ECMOrder> orderList = query.getResultList();
			if(orderList != null && orderList.size() > 0) {
				order = orderList.get(0);
				System.out.println("Inside getOrder order2: [" + order + "]");
			}	
			System.out.println("getOrder: [" + order + "]");
			session.close();
		} 
		catch (HibernateException e) {
			System.out.println("HibernateException :");
			System.out.println(e.getMessage());
		}
		return order;
	}
	
	public List<ECMOrder> getOrderList(String userid,String siteCode) {
		List<ECMOrder> orderList = new ArrayList<ECMOrder>();
		try  {
			System.out.println("Inside get order list try [" +userid+"] site code ["+siteCode+"]");	
			// 1. Get Session object
			Session session = HibernateUtil.getSessionFactory(siteTranDB).openSession();
			// 2. Create Query
			Query query = session.createQuery("from ECMOrder where userId='"+ userid+"' AND ecmSite='"+ siteCode+ "' order by orderNo");
			
			List<ECMOrder> ordersList = query.getResultList();
			
			for( ECMOrder eOrder : ordersList ){
				orderList.add(eOrder);
			}
			System.out.println("orderList.["+ordersList+"][" + ordersList.size() + "]");
			session.close();
		} 
		catch (HibernateException e) {
			System.out.println("HibernateException :");
			System.out.println(e.getMessage());
		}
		return orderList;
	}

	public String saveOrder(String uniqueId,String cacheName,String data,  String siteCode ,Object auth_user, Object contexObject ) throws JSONException{
		JSONObject requestData = new JSONObject(data);
	    System.out.println("Inside save Order Dao data is" +data);
		String returnString ;
		String result="Invalid";
		ECMUserTracker userBean = userActivityCache.getCachedUserData(uniqueId, cacheName);
		System.out.println("inside save order userbean>" + userBean );
		if( userBean != null ) {
			this.siteCode = siteCode;
			Map<String, String> cartMap = userBean.getCartProducts();
			System.out.println("Inside getCartItem > cartMap >" + cartMap );
			returnString = "Success";
			try 
			{
				returnString = getXMLString("ecm_order", requestData, siteCode,cartMap,cacheName);
				System.out.println("returnString json " +returnString);
				//returnString = genericUtility.jsonToXMLString( returnString );
				result = checkNull( processRequest( returnString, contexObject ) );
			}
			catch (ITMException e) {
				// TODO Auto-generated catch block
				System.out.println(" ITMException saveOrder :"+e.getMessage());
				e.printStackTrace();
			} catch (BaseException e) {
				// TODO Auto-generated catch block
				System.out.println(" BaseException saveOrder :"+e.getMessage());
				e.printStackTrace();
			} catch (Exception e) {
				// TODO Auto-generated catch block
				System.out.println(" Exception saveOrder :" + e.getMessage());
				e.printStackTrace();
			}
			System.out.println("After orderJsonObj \n returnString >> " + result);
		}

		return result;
	}

	// Added By PriyankaB on start	
	public double getsalesRate(String siteCode, String itemCode,String custCode) throws BaseException, Exception{
		Connection conn = null;
		String transDB = getUserInfo().getTransDB();
		ConnDriver connDriver = new ConnDriver();
		if( checkNull( transDB ).length() > 0 )
		{
			System.out.println("Inside processRequest transDB ");
			conn = connDriver.getConnectDB( transDB );
		}
		else
		{
			System.out.println("Inside processRequest transDB  else");
			conn = connDriver.getConnectDB( "DriverITM" );
		}
		Timestamp orderDt = new Timestamp(System.currentTimeMillis());
		System.out.println("Inside get Sales Price List orderDt:"+orderDt);
		String ContractNo = salesOrderIc.getContract(siteCode, custCode, orderDt, itemCode, "", "", conn);
		String orderDate = genericUtility.getValidDateString(new Date(), genericUtility.getApplDateFormat() );
		String ldtDateStr = orderDate;
		String mOrderDateStr =orderDate;
		System.out.println("Inside get Sales Price List ContNo:"+ContractNo);
		String lsContractNo=ContractNo;
		String pricelist=  distCommon.getSalesPriceList(custCode, custCode, siteCode, ContractNo, itemCode, orderDate, conn);
		double SalesRate =distCommon.getSalesRate(pricelist, siteCode, custCode, mOrderDateStr, ldtDateStr, "C", ContractNo, lsContractNo, itemCode, 0.0, conn);
		System.out.println("In Order DAO SalesRate[ " +SalesRate+"]");
		return SalesRate;
		
	}	
	// Added By PriyankaB on end	
	
	private JSONObject createDocumentJSON() {
		JSONObject rootObj = new JSONObject();
		JSONObject docRoot = new JSONObject();
		JSONObject docGroup0 = new JSONObject();
		JSONObject docHeader0 = new JSONObject();
		JSONObject detail1 = new JSONObject(); // ECM_ORDER
		JSONArray detail2 = new JSONArray(); // ECM_ORDER_DET
		try 
		{
			rootObj.put("DocumentRoot", docRoot);
			
			docRoot.put("description", "Datawindow Root");
			docRoot.put("group0", docGroup0);
			
			docGroup0.put("description", "Group0 description");
			docGroup0.put("Header0", docHeader0);
			
			docHeader0.put("description", "Header0 description");
			docHeader0.put("Detail1", detail1);
			docHeader0.put("Detail2", detail2);
		} 
		catch (JSONException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		System.out.println("createDocumentJSON" + rootObj);
		return rootObj;
	}
	
	/*From E12ExtService processRequest, addFollowUpAction*/
	private String processRequest( String xmlString, Object contexObject   ) throws ITMException
	{
		String resultString = "";
		Connection conn = null;
		boolean isError = false;
		MasterStatefulLocal masterStateful=null;
		System.out.println("inside process request xmlString[" + xmlString + "]");
		try 
		{
			System.out.println("Inside processRequest try ");
			String userInfoStr = getUserInfo().toString();
			System.out.println( "getUserInfo() - "+ userInfoStr );
			String transDB = getUserInfo().getTransDB();
			ConnDriver connDriver = new ConnDriver();
			if( checkNull( transDB ).length() > 0 )
			{
				System.out.println("Inside processRequest transDB ");
				conn = connDriver.getConnectDB( transDB );
			}
			else
			{
				System.out.println("Inside processRequest transDB  else");
				conn = connDriver.getConnectDB( "DriverITM" );
			}
			connDriver = null;
			conn.setAutoCommit( false );
			System.out.println("Inside processRequest before  masterStateful");
			masterStateful = (MasterStatefulLocal) getInitialContext().lookup( "ibase/MasterStatefulEJB/local" );
			System.out.println("masterStateful ejb "+masterStateful);
			int randInt = new Random().nextInt();
			masterStateful.setEditorId( ""+randInt );
			masterStateful.setUserInfo( userInfoStr, xmlString );
			resultString = checkNull( masterStateful.processRequest( getUserInfo(), xmlString, true, conn ) );
			System.out.println("inside process request try  resultString " +resultString);
			if ( checkNull( xmlString ).length() > 0 )
			{
				String saveLevel = "";
				Node saveLevelNode = genericUtility.parseString( xmlString ).getElementsByTagName( "saveLevel" ).item(0);
				if ( saveLevelNode != null && saveLevelNode.getFirstChild() != null )
				{
					saveLevel = saveLevelNode.getFirstChild().getNodeValue();
				}
				if ( ( saveLevel != null && resultString != null ) && ( saveLevel.equals( "1" ) && resultString.indexOf( "Success" ) != -1 ) )
				{
					try 
				    {
						String tranID = "";
					    Node tranIdNode = genericUtility.parseString( resultString ).getElementsByTagName( "TranID" ).item(0);
						if ( tranIdNode != null && tranIdNode.getFirstChild() != null)
						{
							tranID = tranIdNode.getFirstChild().getNodeValue();
						}
						String objName = "";
						Node objNameNode = genericUtility.parseString( xmlString ).getElementsByTagName( "objName" ).item(0);
						if ( objNameNode != null && objNameNode.getFirstChild() != null )
						{
							objName = objNameNode.getFirstChild().getNodeValue();
						}
						System.out.println( "objName - ["+ objName +"], tranID - ["+ tranID +"]" );
						String userId = getUserInfo().getLoginCode();
						String randomNo = ""+ new Random().nextInt();
						//	addFollowUpAction( userId, randomNo, tranID, objName, contexObject );
					}
				    catch (Exception e) 
				    {
						e.printStackTrace();
					}
				}
			}

		}
		catch (ITMException e) 
		{
			System.out.println("ITMException :: processRequest() :==>\n"+e.getMessage());
			isError = true;
			throw new ITMException(e);
		}
		catch (RemoteException e) 
		{
			System.out.println("RemoteException :: processRequest() :==>\n"+e.getMessage());
			isError = true;
			throw new ITMException(e);
		}
		catch (SQLException e) 
		{
			System.out.println("SQLException :: processRequest() :==>\n"+e.getMessage());
			isError = true;
			throw new ITMException(e);
		}
		catch (NamingException e) 
		{
			System.out.println("NamingException :: processRequest() :==>\n"+e.getMessage());
			isError = true;
			throw new ITMException(e);
		}
		catch (Exception e) 
		{
			System.out.println("Exception :: processRequest() :==>\n"+e.getMessage());
			isError = true;
			throw new ITMException(e);
		}
		finally
		{
			if ( resultString.indexOf( "<Errors>" ) != -1 || resultString.indexOf( "Exception" ) != -1 )
			{
				isError = true;
			}
			if( conn !=null )
			{
				try 
				{
					if ( isError )
					{
						conn.rollback();
					}
					else
					{
						conn.commit();
					}
					conn.close();
					conn = null;
				}
				catch (SQLException e) 
				{
					e.printStackTrace();
				}
			}
			if(masterStateful!=null)
			{
				masterStateful.remove();
				masterStateful=null;
			}
	}
		return resultString;
	}	

	
	public UserInfoBean getUserInfo() {
		return userInfo;
	}

	public void setUserInfo(UserInfoBean userInfo) {
		this.userInfo = userInfo;
	}

	private String checkNull(String input) {
		if ( input == null || "null".equalsIgnoreCase(input) || "undefined".equalsIgnoreCase(input) )
		{
			input= "";
		}
		return input.trim();
	}
	
	private InitialContext getInitialContext() throws ITMException  {
		InitialContext ctx = null;
		try
		{
			AppConnectParm appConnect = new AppConnectParm();
			ctx = new InitialContext( appConnect.getProperty() );
		}
		catch( ITMException itme )
		{
			System.out.println( "ITMException : getInitialContext : "+ itme.getMessage() );
			throw itme;
		}
		catch(Exception e)
		{
			System.out.println( "Exception : getInitialContext : "+ e.getMessage() );
			throw new ITMException(e);
		}
		return ctx;
	}
	
	// Added By PriyankaB on start	
	private String getXMLString(String objName, JSONObject requestData,String siteCode, Map<String, String> cartMap, String cacheName) throws ITMException, BaseException, Exception{
		StringBuffer finalXML = new StringBuffer();
		finalXML.append("<DocumentRoot>");
		finalXML.append("<description>Datawindow Root</description>");
		finalXML.append("<group0>");
		finalXML.append("<description>Group0 description</description>");
		finalXML.append("<Header0>");
		finalXML.append("<description>Header0 members</description>");
		finalXML.append("<objName><![CDATA[" + objName + "]]></objName>");
		finalXML.append("<pageContext><![CDATA[1]]></pageContext>");
		finalXML.append("<objContext><![CDATA[1]]></objContext>");
		finalXML.append("<editFlag><![CDATA[A]]></editFlag>");
		finalXML.append("<focusedColumn><![CDATA[]]></focusedColumn>");
		finalXML.append("<action><![CDATA[ADD]]></action>");
		finalXML.append("<elementName><![CDATA[]]></elementName>");
		finalXML.append("<keyValue><![CDATA[1]]></keyValue>");
		finalXML.append("<taxKeyValue><![CDATA[]]></taxKeyValue>");
		finalXML.append("<saveLevel><![CDATA[1]]></saveLevel>");
		finalXML.append("<forcedSave><![CDATA[false]]></forcedSave>");
		finalXML.append("<taxInFocus><![CDATA[false]]></taxInFocus>");
		// <Detail1 dbID="supplier_bill_edit:test1" domID="1" objContext="1"
		// objName="obj_attach_config">
		// <attribute pkNames="obj_name:doc_type:" selected="N" status="O"
		// updateFlag="E" />
		// </Detail1>
		
		finalXML.append( getDetail1XML(objName, requestData,siteCode, cartMap,  cacheName) );
		finalXML.append( getDetail2XML(objName, requestData,cartMap,  cacheName) );
		
		finalXML.append("</Header0>");
		finalXML.append("</group0>");
		finalXML.append("</DocumentRoot>");
		
		return finalXML.toString();
	}
	
	private String getDetail1XML(String objName, JSONObject requestData, String siteCode, Map<String, String> cartMap, String cacheName ) throws ITMException, BaseException, Exception
	{
		StringBuffer detailBuff = new StringBuffer();
	
		String ecm_type =requestData.getString("ecm_type");
		System.out.println("getDetail1XML cart map data [" + cartMap +"] ecm_type :" +ecm_type);		
		System.out.println("In getDetail1XML cartMap.size" + cartMap.size());
		List<String > keySet=new ArrayList<String>( cartMap.keySet());
		System.out.println("In getDetail1XML keySet" + keySet);
		int idx = 0;
		double orderAmount = 0;
		double orderDiscAmount = 0;
		double orderNetAmount = 0;
		
		String addr1;
		String addr2 ;
		String addr3 ;
		String countDescr;
		String stateDescr ;
		String pinCode;
		String city ;
		String dlvAdd ="";
		String billAdd ="";
		String address="";
		System.out.println("In getDetail1XML requestData" + requestData);
	    char ecmType = ecm_type.charAt(0);
		if(ecmType=='2') {
			System.out.println("Inside getDetail1XML Sale Address");
			JSONObject saleAddress = new JSONObject();
			saleAddress=requestData.getJSONObject("saleAddress");
			System.out.println("Inside getDetail1XML Sale Address" + saleAddress);
			JSONObject billTo = new JSONObject();
			billTo=saleAddress.getJSONObject("billTo");
			JSONObject billToAddress = new JSONObject();
			billToAddress=billTo.getJSONObject("address");
			addr1 = billToAddress.optString("addr1");
			addr2 = billToAddress.optString("addr2");
			addr3 = billToAddress.optString("addr3");
			countDescr = billToAddress.optString("countDescr");
			stateDescr = billToAddress.optString("stateDescr");
			pinCode = billToAddress.optString("pinCode");
			city = billToAddress.optString("city");
			billAdd=addr1+" "+addr2+" "+addr3+" "+city+" " +countDescr+" "+stateDescr+" "+pinCode;	
			System.out.println("Inside getDetail1XML billAdd" + billAdd);
			
			JSONObject deliverTo = new JSONObject();
			deliverTo=saleAddress.getJSONObject("deliverTo");
			JSONObject dlvToAddress = new JSONObject();
			dlvToAddress=deliverTo.getJSONObject("address");
			addr1 = dlvToAddress.optString("addr1");
			addr2 = dlvToAddress.optString("addr2");
			addr3 = dlvToAddress.optString("addr3");
			countDescr = dlvToAddress.optString("countDescr");
			stateDescr = dlvToAddress.optString("stateDescr");
			pinCode = dlvToAddress.optString("pinCode");
			city = dlvToAddress.optString("city");
			dlvAdd=addr1+" "+addr2+" "+addr3+" "+city+" " +countDescr+" "+stateDescr+" "+pinCode;
			System.out.println("Inside getDetail1XML dlvAdd" + dlvAdd);
			
		} // for sales catalog category
		else{
			JSONObject billAddress = new JSONObject();
			billAddress=requestData.getJSONObject("billAddress");
			System.out.println("In getDetail1XML billAddress" + billAddress);
			addr1 = billAddress.optString("addr1");
			addr2 = billAddress.optString("addr2");
			addr3 = billAddress.optString("addr3");
			countDescr = billAddress.optString("countDescr");
			stateDescr = billAddress.optString("stateDescr");
			pinCode = billAddress.optString("pinCode");
			city = billAddress.optString("city");
			String addrUse = billAddress.optString("addrUse");
			System.out.println("cartMap.keySet() getDetail1XML addrUse" + addrUse);
			address=addr1+" "+addr2+" "+addr3+" "+city+" " +countDescr+" "+stateDescr+" "+pinCode;
			char addrUsed=addrUse.charAt(0);
			if(addrUsed=='D') {     
				dlvAdd=address;
				System.out.println("getDetail1XML dlvAdd in if" + addrUsed);
			}//if(address is Delivery Address)
			else if(addrUsed=='B'){
				billAdd=address;
				System.out.println("getDetail1XML dlvAdd in if" + addrUsed);
			}//if(address is Billing Address)
			else {
				dlvAdd=address;
				billAdd=address;
				System.out.println("getDetail1XML dlvAdd in if" + addrUsed);
			}//if(address is both delivery and billing Address)
		}


		for (Iterator iterator = keySet.iterator(); iterator.hasNext();) {
			String itemCode = (String) iterator.next();
			int itemQuantity = Integer.parseInt(cartMap.get(itemCode));
			System.out.println("item_Detail in getDetail2XML quantity[" + itemQuantity + "]");
			System.out.println("item_Detail in getDetail2XML index [" +idx +"] itemCode[" + itemCode + "]");
    		ItemDetails itemDetail = productCache.getCachedItemDetail(itemCode, cacheName);
			if( itemDetail == null )
			{
				productDAO.prepareItemDetails(cacheName, siteCode, itemCode);
				itemDetail = productCache.getCachedItemDetail(itemCode, cacheName);
			}
			JSONObject itemHeader = new JSONObject(itemDetail.getItemHeader());
			System.out.println("itemHeader.getDouble(itemCostRate) [" + itemHeader.getDouble("itemCostRate") +"] and discountrate [" + itemHeader.getDouble("itemDiscountedRate") +"]");
			orderAmount  =orderAmount + (itemHeader.getDouble("itemCostRate") * itemQuantity );  //  Total Amount of Items  [Sum of RATE multiply with QUANTITY of ecm_order_det]
			orderNetAmount =orderNetAmount + (itemHeader.getDouble("itemDiscountedRate") * itemQuantity ) ;  //  Total Amount of Items - Total Discount Amount [Multiply with QUANTITY of ecm_order_det]
			orderDiscAmount =orderAmount-orderNetAmount; // Total Discount Amount of Items
			idx++;
		}
		System.out.println("orderAmount" + orderAmount);
		System.out.println("orderDiscAmount" + orderDiscAmount);
		System.out.println("orderNetAmount" + orderNetAmount);

		detailBuff.append("<Detail1 dbID=\"\" domID=\"1\" objContext=\"1\" objName=\"" + objName + "\">");
		detailBuff.append("<attribute pkNames=\"\" selected=\"N\" status=\"N\" updateFlag=\"A\" />");
		detailBuff.append("<eorder_no>").append("<![CDATA[]]>").append("</eorder_no>");
		detailBuff.append("<user_id>").append("<![CDATA[" + userInfo.getLoginCode() + "]]>").append("</user_id>");
		detailBuff.append("<ecm_site>").append("<![CDATA[" + siteCode + "]]>").append("</ecm_site>");
		detailBuff.append("<curr_code>").append("<![CDATA[INR]]>").append("</curr_code>");
		detailBuff.append("<exch_rate>").append("<![CDATA[1]]>").append("</exch_rate>");
		detailBuff.append("<order_date>").append("<![CDATA[ " + genericUtility.getValidDateString(new Date(), genericUtility.getApplDateFormat() ) +"]]>").append("</order_date>");
		detailBuff.append("<order_stat>").append("<![CDATA[]]>").append("</order_stat>");
		detailBuff.append("<stat_date>").append("<![CDATA[]]>").append("</stat_date>");
		detailBuff.append("<dlv_address>").append("<![CDATA[" + dlvAdd + "]]>").append("</dlv_address>");
		detailBuff.append("<bill_address>").append("<![CDATA[ "+ billAdd +" ]]>").append("</bill_address>");
		detailBuff.append("<amount>").append("<![CDATA["+  orderAmount +"]]>").append("</amount>");
		detailBuff.append("<tax_amt>").append("<![CDATA[0]]>").append("</tax_amt>");
		detailBuff.append("<disc_amt>").append("<![CDATA["+orderDiscAmount+"]]>").append("</disc_amt>");
		detailBuff.append("<promo_amt>").append("<![CDATA[0]]>").append("</promo_amt>");
		detailBuff.append("<net_amt>").append("<![CDATA["+  orderNetAmount +"]]>").append("</net_amt>");
		detailBuff.append("<wf_stat>").append("<![CDATA[]]>").append("</wf_stat>");
		detailBuff.append("<wf_stat_date>").append("<![CDATA[]]>").append("</wf_stat_date>");
		detailBuff.append("<chg_date>").append("<![CDATA[]]>").append("</chg_date>");
		detailBuff.append("<chg_user>").append("<![CDATA[]]>").append("</chg_user>");
		detailBuff.append("<chg_term>").append("<![CDATA[]]>").append("</chg_term>");
		detailBuff.append("<ecm_type>").append("<![CDATA["+ requestData.getString("ecm_type") +"]]>").append("</ecm_type>");
		detailBuff.append("</Detail1>");
		
		return detailBuff.toString();
	}
	
	
	private String getAddress( JSONObject requestData ){
		String billAddress = "";
		
		try 
		{
			if( requestData.has("billAddress") )
			{
				System.out.println("billAddress >>" + requestData.getJSONObject("billAddress") );
			}
		} 
		catch (JSONException e) 
		{
			e.printStackTrace();
		}
		
		return billAddress;
	}
	
	private String getDetail2XML(String objName,JSONObject requestData, Map<String, String> cartMap, String cacheName) throws ITMException, BaseException, Exception
	{
		StringBuffer detailBuff = new StringBuffer();
		System.out.println("getDetail2XML" + cartMap);
		System.out.println("cartMap.size()" + cartMap.size());
		List<String > keySet=new ArrayList<String>( cartMap.keySet());
		System.out.println("cartMap.keySet()" + keySet);
		int idx = 0;

		for (Iterator iterator = keySet.iterator(); iterator.hasNext();) {
			String itemCode = (String) iterator.next();
			String lineNo = (idx+1) + "";
			int quantity = Integer.parseInt(cartMap.get(itemCode));
			System.out.println("item_Detail in getDetail2XML quantity[" + quantity + "]");
			System.out.println("item_Detail in getDetail2XML index [" +idx +"] itemCode[" + itemCode + "]");

			double netAmount ;  

			ItemDetails itemDetail = productCache.getCachedItemDetail(itemCode, cacheName);
			if( itemDetail == null )
			{
				productDAO.prepareItemDetails(cacheName, siteCode, itemCode);
				itemDetail = productCache.getCachedItemDetail(itemCode, cacheName);
			}
			JSONObject itemHeader = new JSONObject(itemDetail.getItemHeader());
			netAmount=itemHeader.getDouble("itemDiscountedRate") * quantity;  // Rate of an Item -  Discount % available on an Item [Multiply with QUANTITY]
			System.out.println("itemHeader.getDouble(itemCostRate) in detail2 [" + itemHeader.getDouble("itemCostRate") +"] and discountrate [" + itemHeader.getDouble("itemDiscountedRate") +"]");
			System.out.println("item_Detail in getDetail2XML netAmount[" + netAmount + "]");

			detailBuff.append("<Detail2 dbID=\"\" domID=\"" + lineNo + "\" objContext=\"2\" objName=\"" + objName + "\" >");
			detailBuff.append("<attribute pkNames=\"\" selected=\"N\" status=\"N\" updateFlag=\"A\" />");
			detailBuff.append("<eorder_no>").append("<![CDATA[]]>").append("</eorder_no>");
			detailBuff.append("<item_code>").append("<![CDATA[" + itemCode + "]]>").append("</item_code>");
			detailBuff.append("<line_no>").append("<![CDATA[" + lineNo + "]]>").append("</line_no>");
			detailBuff.append("<promo_code>").append("<![CDATA[]]>").append("</promo_code>");
			detailBuff.append("<quantity>").append("<![CDATA[" + quantity + "]]>").append("</quantity>");
			detailBuff.append("<rate>").append("<![CDATA[" + itemHeader.getDouble("itemCostRate") + "]]>").append("</rate>");
			detailBuff.append("<disc_perc>").append("<![CDATA[" +   itemHeader.getDouble("itemDiscount") + "]]>").append("</disc_perc>");
			detailBuff.append("<tax_amt>").append("<![CDATA[0]]>").append("</tax_amt>");
			detailBuff.append("<tax_chap>").append("<![CDATA[]]>").append("</tax_chap>");
			detailBuff.append("<tax_class>").append("<![CDATA[]]>").append("</tax_class>");
			detailBuff.append("<tax_env>").append("<![CDATA[]]>").append("</tax_env>");
			detailBuff.append("<net_amt>").append("<![CDATA[" +  netAmount + "]]>").append("</net_amt>");
			detailBuff.append("<ord_stat>").append("<![CDATA[]]>").append("</ord_stat>");
			detailBuff.append("<stat_date>").append("<![CDATA[" + genericUtility.getValidDateString(new Date(), genericUtility.getApplDateFormat() ) + "]]>").append("</stat_date>");
			detailBuff.append("<stat_remarks>").append("<![CDATA[]]>").append("</stat_remarks>");
			detailBuff.append("<stat_date>").append("<![CDATA[" + genericUtility.getValidDateString(new Date(), genericUtility.getApplDateFormat() ) + "]]>").append("</stat_date>");
			detailBuff.append("<stat_remarks>").append("<![CDATA[]]>").append("</stat_remarks>");
			detailBuff.append("<ship_date>").append("<![CDATA[]]>").append("</ship_date>");	
			detailBuff.append("<dlv_date>").append("<![CDATA[]]>").append("</dlv_date>");
			
			detailBuff.append("</Detail2>");
			idx++;
		}
		return detailBuff.toString();
	}
	// Added By PriyankaB on end	
	
    /*chitranga */
	
	public String getCustomerList(String userType, String entityCode ,String siteCode) {
			Statement stmt = null;
			Connection conn = null;
			String sql = null;
			ResultSet rs = null;
			JSONArray customerList = new JSONArray();
			System.out.println(" userType in getCustomerList EcmOrderDao >>[" + userType + "]");
		    System.out.println(" entityCode in getCustomerList EcmOrderDao >>[" + entityCode + "]");
		    try{
		    	
	    	System.out.println("getUserInfo()"+getUserInfo());
	        String transDB = getUserInfo().getTransDB();
		    System.out.println("transDB ["+transDB+"]");
		    ConnDriver connDriver = new ConnDriver();
			    if( checkNull( transDB ).length() > 0 )
			 {
				System.out.println("Inside getCustomerList transDB ");
				conn = connDriver.getConnectDB( transDB );
			 }
			 else
			 {
				System.out.println("Inside getCustomerList transDB  else");
				conn = connDriver.getConnectDB( "DriverITM" );
			 }
		      System.out.println("Inside getCustomerList conn ["+conn+"]");
		      char userTypeCh = userType.charAt(0);
		      System.out.println("userTypeCh ["+userTypeCh+"]");
		      stmt = conn.createStatement();
			  if(userTypeCh == 'U') //TODO
				    {
			      	    System.out.println("entity of user type");
				        sql = "select CUST_CODE,CUST_NAME,CUST_CODE__BIL  FROM customer where cust_code = '" + entityCode + "' ";
				        
				    }
		       if(userTypeCh == 'E')
				    {
				    	System.out.println("entity of employee type");
				    	sql = "select CUST_CODE, CUST_NAME, CUST_CODE__BIL from CUSTOMER where SALES_PERS = '"+ entityCode + "'"+" union select CUST_CODE, CUST_NAME, CUST_CODE__BIL from CUSTOMER where CUST_CODE in (select CUST_CODE from SITE_CUSTOMER where SALES_PERS = '"+ entityCode + "'"+" and SITE_CUSTOMER.SITE_CODE = '" + siteCode + "' )";
				      
				    }
		       if(userTypeCh == 'P')//TODO
				    {
				    	System.out.println("entity of sales person type");
				    }
		       if(userTypeCh == 'C')
				    {
				    	   System.out.println("entity of customer type");
			    	    //   sql = "select CUST_CODE, CUST_NAME, CUST_CODE__BIL from CUSTOMER where CONTACT_CODE in (select CONTACT_CODE from CUSTOMER where CUST_CODE = '" + entityCode + "' )" ;
		                     sql ="select CUST_CODE, CUST_NAME, CUST_CODE__BIL, ADDR1,ADDR2 ,ADDR3 ,CITY, S.DESCR AS STATE, S.STATE_CODE  AS STATE_CODE ,PIN , CNTRY.DESCR as COUNTRY, STAN_CODE  from CUSTOMER C, STATE S, COUNTRY CNTRY where C.CONTACT_CODE in (select CONTACT_CODE from CUSTOMER where CUST_CODE = '" + entityCode + "'"+") and S.STATE_CODE = C.STATE_CODE and CNTRY.COUNT_CODE = C.COUNT_CODE ";
    	     
				    	   
				    }
		      if(userTypeCh == 'S') //TODO
				    {
				    	System.out.println("entity of supplier type type");
			
				    }
			    System.out.println("sql statement "+sql);
			    rs = stmt.executeQuery(sql);

	  	        while (rs.next()) {
	
					String custCode = rs.getString("CUST_CODE");
					String custName = rs.getString("CUST_NAME");
					String custCodeBil = rs.getString("CUST_CODE__BIL");
					
					String addr1 = rs.getString("ADDR1");
					String addr2 = rs.getString("ADDR2");
					String addr3 = rs.getString("ADDR3");
					String city = rs.getString("CITY");
					String state = rs.getString("STATE");
					String stateCode = rs.getString("STATE_CODE");
					String pin = rs.getString("PIN");
					String country = rs.getString("COUNTRY");
					String stanCode = rs.getString("STAN_CODE");
					
					System.out.println("custCode : " + custCode);
					System.out.println("custName : " + custName);
					System.out.println("custCodeBil : " + custCodeBil);
					System.out.println("addr1 : " + addr1);
					System.out.println("addr2 : " + addr2);
					System.out.println("addr3 : " + addr3);
					System.out.println("city : " + city);
					System.out.println("state : " + state);
					System.out.println("stateCode : " + stateCode);
					System.out.println("country : " + country);
					System.out.println("pin : " + pin);
					System.out.println("stanCode : " + stanCode);
					
					JSONObject custDetails = new JSONObject();
					
					custDetails.put("custCode",custCode.trim());
					custDetails.put("custName",custName.trim() );
					custDetails.put("custCodeBil",custCodeBil.trim() );
				/*	custDetails.put("addr2",addr2.trim() );
					custDetails.put("addr3",addr3.trim() );
					custDetails.put("city",city.trim() );
					custDetails.put("state",state.trim() );
					custDetails.put("pin",pin.trim() );
					custDetails.put("custCodeBil",custCodeBil.trim() );
                  */ 
					EntityAddress address = new EntityAddress();
                    address.setAddr1(addr1);
                    address.setAddr2(addr2);
                    address.setAddr3(addr3);
                    address.setCity(city);
                    
                    address.setStateDescr(state);
                    address.setStateCode(stateCode);
                    address.setCountDescr(country);
                    address.setPinCode(pin);
                    address.setStanCode(stanCode);
                    
                    System.out.println("address in ECM Order Dao"+address);
                    
					custDetails.put("address", new JSONObject(address));
					
					customerList.put(custDetails);
					
				}
            System.out.println("customerList "+customerList);

	    }
    	catch(SQLException se){
    	      //Handle errors for JDBC
    	      System.out.println("SQLException occures"+se);
    	      se.printStackTrace();
    	   }catch(Exception e){
    	      //Handle errors for Class.forName
	    	  System.out.println("SQLException occures"+e);
    	      e.printStackTrace();
    	   }
	    
		return customerList.toString();
	}
	    
	/*chitranga */


}


/*  private JSONObject createHeaderDetail(JSONObject requestData, String siteCode,Object auth_user) throws JSONException {
	System.out.println("createDetail1" + requestData);
	DateFormat df = new SimpleDateFormat("dd/MM/yy");
	Date dateobj = new Date();
	JSONObject detail = new JSONObject();
	detail.put("eorder_no","" );
	detail.put("user_id",auth_user );
	detail.put("ecm_site", siteCode );
	detail.put("curr_code","");
	detail.put("exch_rate","");
	detail.put("order_date","");
	detail.put("order_stat","");
	detail.put("stat_date","");
	detail.put("dlv_address","");
	detail.put("bill_address", requestData.get("billAddress") );
	detail.put("amount","");
	detail.put("tax_amt","");
	detail.put("disc_amt","");
	detail.put("promo_amt","");
	detail.put("net_amt","");
	detail.put("wf_stat","");
	detail.put("wf_stat_date","");
	detail.put("chg_date", df.format(dateobj));
	detail.put("chg_user",auth_user);
	detail.put("chg_term","SYSTEM" ); //TODO - User Host M/C IP
	
	//Detail1 AttributeList 
	JSONObject detailAttribs = new JSONObject();
	detailAttribs.put("@dbID", "");
    detailAttribs.put("@domID", "1");
    detailAttribs.put("@objContext", "1");
    detailAttribs.put("@objName", "event_plan");
    detail.put("attrib",detailAttribs );
   
    //Attribute AttributeList
    JSONObject attribute = new JSONObject();
	JSONObject attributeAttribs = new JSONObject();
	attributeAttribs.put("@IS_CHANGE", "Y");
	attributeAttribs.put("@pkNames", "");
	attributeAttribs.put("@selected", "N");
	attributeAttribs.put("@status", "N");
	attributeAttribs.put("@updateFlag", "A");
    attribute.put("attrib", attributeAttribs);
    detail.put("attribute", attribute);
	return detail;
}

private JSONArray createDetailArray(Map<String, String> cartMap) throws JSONException {
	System.out.println("createDetailArray" + cartMap);
	System.out.println("cartMap.size()" + cartMap.size());
	JSONArray headerDetail = new JSONArray();
	List<String > keySet=new ArrayList<String>( cartMap.keySet());
	System.out.println("cartMap.keySet()" + keySet);
	int idx = 0;
	for (Iterator iterator = keySet.iterator(); iterator.hasNext();) {
		String itemCode = (String) iterator.next();
		String lineNo = (idx+1) + "";
		String quantity = cartMap.get(itemCode);
		System.out.println("item_code[" + idx + "]" + itemCode);
		JSONObject detail = new JSONObject();
	    detail.put("item_code", itemCode);
	    detail.put("eorder_no","" );
	    detail.put("line_no", lineNo );
	    detail.put("promo_code","" );
	    detail.put("quantity", quantity );
	    detail.put("rate","" );
	    detail.put("dist_perc","" );
	    detail.put("tax_amt","" );
	    detail.put("tax_chap","");
	    detail.put("tax_class","" );
	    detail.put("tax_env","" );
	    detail.put("net_amt","" );
	    detail.put("ord_stat","" );
	    detail.put("stat_date", new Date() );
	    detail.put("stat_remarks", "" );	
	    
	    JSONObject detailAttribs = new JSONObject();
	    detailAttribs.put("@dbID", "");
	    detailAttribs.put("@domID", lineNo);
	    detailAttribs.put("@objContext", "2");
	    detailAttribs.put("@objName", "ecm_order");
		detail.put("attrib",detailAttribs );
		
		JSONObject attributeNode = new JSONObject();
		JSONObject attributeAttribs = new JSONObject();
		attributeAttribs.put("@IS_CHANGE", "Y");
		attributeAttribs.put("@pkNames", "");
		attributeAttribs.put("@selected", "N");
		attributeAttribs.put("@status", "N");
		attributeAttribs.put("@updateFlag", "A");
		attributeNode.put("attrib", attributeAttribs);
        detail.put("attribute",attributeNode );

        headerDetail.put(detail);
        idx++;
	}
	System.out.println("root \n "+headerDetail);
	return headerDetail;
}  */


/*  To Do	
	private void addFollowUpAction( String userId, String editorId, String tranId, String objName, Object contexObject )
	{
		try 
		{
			String pendingWrkflwMapKey = userId + "~" + editorId;
			String pendingWrkflwMapValue = objName + "~" + tranId;
			Map<String, String> pendingWrkflwMap = new HashMap<String, String>();
			if ( contexObject != null )
			{
				pendingWrkflwMap = (Map<String, String>) contexObject;
				if ( pendingWrkflwMap != null )
				{
					pendingWrkflwMap.put( pendingWrkflwMapKey, pendingWrkflwMapValue );
				}
				AppConnectParm appConnect = new AppConnectParm();
				InitialContext ctx = new InitialContext( appConnect.getProperty() );
				E12FollowUpActionLocal followUpActionLocal = (E12FollowUpActionLocal) ctx.lookup( "ibase/E12FollowUpActionEJB/local" );
				followUpActionLocal.followUpAction( pendingWrkflwMapKey, pendingWrkflwMap );
			}
			System.out.println("pendingWrkflwMap - "+ contexObject);
		}
		catch (Exception e) 
		{
			System.out.println( "Exception - "+ e.getMessage() );
			e.printStackTrace();
		}
		
		System.out.println("root \n "+headerDetail);
		return headerDetail;
	}
	*/