package proteus.ecm.hibernate.dao;

import java.util.List;

import org.hibernate.HibernateException;
import org.hibernate.query.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.json.JSONException;
import org.json.JSONObject;

import proteus.ecm.hibernate.bean.ECMUserActivity;
import proteus.ecm.hibernate.bean.ItemMaster;
import proteus.ecm.hibernate.util.HibernateUtil;

public class DataEntryDAO {
	
	public ItemMaster fetchItemMaster(String siteCode, String itemCode)
	{
		ItemMaster itemMaster = null;

		try
		{
			// 1. Get Session object
			Session session = HibernateUtil.getSessionFactory("DEFAULT").openSession();

			// 2. Create Query
			Query query = session.createQuery("FROM ItemMaster WHERE ITEM_CODE = '" + itemCode + "'");

			List<ItemMaster> entryDataList = query.list();
			if (entryDataList != null && entryDataList.size() > 0) {
				itemMaster = entryDataList.get(0);
			}

			System.out.println("User data: [" + itemMaster + "]");
			session.close();

		}
		catch (HibernateException e)
		{
			System.out.println("HibernateException :");
			System.out.println(e.getMessage());
		}
		return itemMaster;
	}
	
	private void update(ItemMaster entryData)
	{
		try
		{
			// 1. Get Session object
			Session session = HibernateUtil.getSessionFactory("DEFAULT").openSession();
			Transaction tx = session.beginTransaction();

			session.update(entryData);
			tx.commit();
			session.close();
		}
		catch (HibernateException e)
		{
			System.out.println("HibernateException :");
			System.out.println(e.getMessage());
			e.printStackTrace();
		}
	}
	
	public void update(JSONObject entryData) throws JSONException{
		ItemMaster itemMaster = fetchItemMaster("L2D01" , entryData.getString("item_code"));
		
		//itemMaster.setItemCode(entryData.getString("item_code"));
		itemMaster.setPhyAttribId1(entryData.getString("phyAttribId1"));
		itemMaster.setPhyAttribId2(entryData.getString("phyAttribId2"));
		itemMaster.setPhyAttribId3(entryData.getString("phyAttribId3"));
		itemMaster.setPhyAttribId4(entryData.getString("phyAttribId4"));
		itemMaster.setPhyAttribId5(entryData.getString("phyAttribId5"));
		itemMaster.setPhyAttribId6(entryData.getString("phyAttribId6"));
		itemMaster.setPhyAttribId8(entryData.getString("phyAttribId8"));
		itemMaster.setPhyAttribId9(entryData.getString("phyAttribId9"));
		itemMaster.setPhyAttribId23(entryData.getString("phyAttribId23"));
		itemMaster.setPhyAttribId24(entryData.getString("phyAttribId24"));
		
		update(itemMaster);
	}
}
