 package proteus.ecm.hibernate.bean;
 
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlRootElement;
import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Store;
import org.json.JSONObject;
 
 @Indexed
 @Entity
 @Table(name="STATE")
 @XmlRootElement(name="State")
 public class State
 implements Serializable
 {
   private static final long serialVersionUID = 1L;
 
   @Id
   @Column(name="STATE_CODE")
   @Field(store=Store.YES, analyze=Analyze.NO)
   private String stateCode;
 
   @Column(name="DESCR")
   private String descr;
 
   @Transient
   private String ldescr;
 
   @Column(name="COUNT_CODE")
   private String countCode;
 
   public State()
   {
   }
 
   public State(String stateCode, String descr, String countCode)
   {
     this.stateCode = stateCode;
     this.descr = descr;
     this.countCode = countCode;
   }
 
   public String getStateCode() {
     return this.stateCode;
   }
 
   public void setStateCode(String stateCode) {
     this.stateCode = stateCode;
   }
 
   public String getDescr() {
     return this.descr;
   }
 
   public void setDescr(String descr) {
    this.descr = descr;
  }

  public String getLdescr() {
    return this.ldescr;
  }

  public void setLdescr(String ldescr) {
    this.ldescr = ldescr;
  }

  public String getCountCode() {
    return this.countCode;
  }

  public void setCountCode(String countCode) {
    this.countCode = countCode;
  }

  public String toString()
  {
    return "\n State.toString >> [" + new JSONObject(this).toString() + "]";
  }
}

