package proteus.ecm.hibernate.bean;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Store;



@Indexed
@Entity
@Table(name = "DOC_TRANSACTION_LINK")
@XmlRootElement(name = "doc_link")
public class DocTransLink  implements java.io.Serializable  {

	
	@Id
	@Field(store = Store.YES, analyze = Analyze.NO)
	@Column(name="DOC_ID")
	private String docId;
	
	@Column(name="REF_SER")
	private String refSer;
    
	@Column(name="REF_ID")
	private String refId;
   
	@Column(name="FILE_TYPE_ATTACH")
	private String fileTypeAttach;

	public DocTransLink() {
		
	}

	public DocTransLink(String docId, String refSer, String refId, String fileTypeAttach) {
		super();
		this.docId = docId;
		this.refSer = refSer;
		this.refId = refId;
		this.fileTypeAttach = fileTypeAttach;
	}

	public String getDocId() {
		return docId;
	}
	@XmlElement
	public void setDocId(String docId) {
		this.docId = docId;
	}

	public String getRefSer() {
		return refSer;
	}
    
	@XmlElement
	public void setRefSer(String refSer) {
		this.refSer = refSer;
	}

	public String getRefId() {
		return refId;
	}
    
	@XmlElement
	public void setRefId(String refId) {
		this.refId = refId;
	}

	public String getFileTypeAttach() {
		return fileTypeAttach;
	}
    
	@XmlElement
	public void setFileTypeAttach(String fileTypeAttach) {
		this.fileTypeAttach = fileTypeAttach;
	}
	
}
